/*
 * Decompiled with CFR 0.152.
 */
package hec.data.characteristic;

import hec.data.AbstractJDomDataObject;
import hec.data.DbOfficeId;
import hec.data.DefaultCwmsProperty;
import hec.data.ICwmsProperty;
import hec.data.JDomDataObjectException;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.characteristic.ICharacteristic;
import hec.data.characteristic.ICharacteristicType;
import hec.data.characteristic.ICharacteristicTypeRef;
import hec.data.characteristic.JDomCharacteristic;
import hec.data.characteristic.JDomCharacteristicTypeRef;
import hec.lang.annotation.EntityBeanType;
import hec.util.BaseXMLUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.CharacteristicObjTUser")
public class JDomCharacteristicType
extends AbstractJDomDataObject
implements ICharacteristicType {
    private JDomCharacteristicTypeRef _ref;
    private SortedMap<String, JDomCharacteristic> _characteristicMap = new TreeMap<String, JDomCharacteristic>();

    public JDomCharacteristicType() {
        this.setDescription("");
        this._ref = new JDomCharacteristicTypeRef();
    }

    public JDomCharacteristicType(Element element) {
        this.setDescription("");
        if (element != null) {
            String id = element.getAttributeValue("id");
            String usageId = element.getAttributeValue("usage_id");
            Element child = element.getChild("db_office_id");
            DbOfficeId officeId = DbOfficeId.parse(child);
            String strOfficeId = null;
            if (officeId != null) {
                strOfficeId = officeId.getOfficeId();
            }
            this._ref = new JDomCharacteristicTypeRef(strOfficeId, usageId, id);
            Element listChild = element.getChild("characteristic_list");
            List children = listChild.getChildren("characteristic");
            for (int ii = 0; ii < children.size(); ++ii) {
                Element characteristicChild = (Element)children.get(ii);
                JDomCharacteristic characteristic = new JDomCharacteristic(characteristicChild);
                this._characteristicMap.put(characteristic.getCharacteristicId(), characteristic);
            }
        }
    }

    public JDomCharacteristicType(ICharacteristicType characteristicType) throws JDomDataObjectException {
        this(JDomDataObjectFactory.getRootElement(characteristicType.toXmlString()));
    }

    @Override
    public ICharacteristicTypeRef getCharacteristicTypeRef() {
        return this._ref;
    }

    public void setCharacteristicRef(ICharacteristicTypeRef ref) throws JDomDataObjectException {
        this._ref = ref instanceof JDomCharacteristicTypeRef ? (JDomCharacteristicTypeRef)ref : new JDomCharacteristicTypeRef(ref);
    }

    @Override
    public void buildElement(Element element) {
        if (element == null) {
            return;
        }
        if (this._ref != null) {
            String id = this._ref.getCharacteristicTypeId();
            if (id != null) {
                element.setAttribute("id", id);
            } else {
                element.removeAttribute("id");
            }
            String usageId = this._ref.getUsageId();
            if (usageId != null) {
                element.setAttribute("usage_id", usageId);
            } else {
                element.removeAttribute("usage_id");
            }
            Element child = BaseXMLUtilities.getOrCreateChild(element, "db_office_id");
            String officeId = this._ref.getOfficeId();
            if (officeId != null) {
                DbOfficeId dbOfficeId = new DbOfficeId(officeId);
                dbOfficeId.buildElement(child);
            } else {
                child.removeContent();
            }
            Element listChildren = BaseXMLUtilities.getOrCreateChild(element, "characteristic_list");
            if (this._characteristicMap.isEmpty()) {
                listChildren.removeContent();
            } else {
                Set<Map.Entry<String, JDomCharacteristic>> entrySet = this._characteristicMap.entrySet();
                for (Map.Entry<String, JDomCharacteristic> entry : entrySet) {
                    JDomCharacteristic jdom = entry.getValue();
                    Element charateristicElement = BaseXMLUtilities.getOrCreateChild(listChildren, "characteristic");
                    jdom.buildElement(charateristicElement);
                }
            }
        }
    }

    @Override
    public List<ICwmsProperty> getPropertyList() {
        ArrayList<ICwmsProperty> list = new ArrayList<ICwmsProperty>();
        Set<Map.Entry<String, JDomCharacteristic>> entrySet = this._characteristicMap.entrySet();
        for (Map.Entry<String, JDomCharacteristic> entry : entrySet) {
            JDomCharacteristic value = entry.getValue();
            DefaultCwmsProperty p = new DefaultCwmsProperty(value);
            String category = this._ref.getPropertyCategory();
            p.setPropertyCategory(category);
            p.setOfficeId(this._ref.getOfficeId());
            list.add(p);
        }
        return list;
    }

    @Override
    public List<ICharacteristic> getList() {
        ArrayList<ICharacteristic> list = new ArrayList<ICharacteristic>();
        list.addAll(this._characteristicMap.values());
        return list;
    }

    @Override
    public SortedMap<String, JDomCharacteristic> getSortedMap() {
        return this._characteristicMap;
    }

    @Override
    public String toString() {
        return this._ref.toString();
    }

    @Override
    public void addCharacteristic(ICharacteristic characteristic) {
        JDomCharacteristic jdom = null;
        jdom = characteristic instanceof JDomCharacteristic ? (JDomCharacteristic)characteristic : new JDomCharacteristic(characteristic);
        this._characteristicMap.put(jdom.getCharacteristicId(), jdom);
    }

    public void setPropertyList(String officeId, String propertyCategory, List<Map<String, String>> properties) {
        if (!propertyCategory.contains("characteristic_type")) {
            return;
        }
        this.getCharacteristicTypeRef().setOfficeId(officeId);
        String[] split = propertyCategory.split("\\.", 4);
        if (split.length != 4) {
            return;
        }
        String usageId = split[1];
        String typeId = split[3];
        this.getCharacteristicTypeRef().setUsageId(usageId);
        this.getCharacteristicTypeRef().setCharacteristicTypeId(typeId);
        for (Map<String, String> map : properties) {
            String dbOfficeId = map.get("officeId");
            String category = map.get("category");
            if (!officeId.equalsIgnoreCase(dbOfficeId) || !propertyCategory.equalsIgnoreCase(category)) continue;
            String id = map.get("id");
            String value = map.get("value");
            String comment = map.get("comment");
            JDomCharacteristic characteristic = new JDomCharacteristic(id, value);
            characteristic.setPropertyComment(comment);
            this._characteristicMap.put(characteristic.getCharacteristicId(), characteristic);
        }
    }

    @Override
    public String getDescription() {
        return this.getStringValue("description");
    }

    @Override
    public void setDescription(String description) {
        this.putStringValue("description", description);
    }

    private JDomCharacteristic getJDomCharacteristic(String characteristicId) {
        JDomCharacteristic jdom = (JDomCharacteristic)this._characteristicMap.get(characteristicId);
        if (jdom == null) {
            jdom = new JDomCharacteristic();
            jdom.setCharacteristicId(characteristicId);
            this._characteristicMap.put(characteristicId, jdom);
        }
        return jdom;
    }

    @Override
    public void putParamValue(String characteristicId, ParamDouble pd) {
        JDomCharacteristic jdom = this.getJDomCharacteristic(characteristicId);
        jdom.setParamValue(pd);
    }

    @Override
    public void putStringValue(String characteristicId, String text) {
        JDomCharacteristic jdom = this.getJDomCharacteristic(characteristicId);
        jdom.setStringValue(text);
    }

    @Override
    public void getParamValue(String characteristicId, ParamDouble pd) {
        JDomCharacteristic jdom = this.getJDomCharacteristic(characteristicId);
        jdom.getParamValue(pd);
    }

    @Override
    public String getStringValue(String characteristicId) {
        JDomCharacteristic jdom = this.getJDomCharacteristic(characteristicId);
        return jdom.getStringValue();
    }
}

