/*
 * Decompiled with CFR 0.152.
 */
package hec.data.characteristic;

import hec.data.AbstractJDomDataObject;
import hec.data.DbOfficeId;
import hec.data.JDomDataObjectException;
import hec.data.JDomDataObjectFactory;
import hec.data.characteristic.ICharacteristicTypeRef;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.CharacteristicRefTUser")
public class JDomCharacteristicTypeRef
extends AbstractJDomDataObject
implements ICharacteristicTypeRef {
    private String _officeId;
    private String _usageId;

    public JDomCharacteristicTypeRef() {
    }

    public JDomCharacteristicTypeRef(String officeId, String usageId, String characteristicTypeId) {
        this._officeId = officeId;
        this._usageId = usageId;
        this.setName(characteristicTypeId);
    }

    public JDomCharacteristicTypeRef(Element element) {
        if (element != null) {
            this.setName(element.getAttributeValue("id"));
            this.setUsageId(element.getAttributeValue("usage_id"));
            DbOfficeId dbOfficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            if (dbOfficeId != null) {
                this._officeId = dbOfficeId.getOfficeId();
            }
        }
    }

    public JDomCharacteristicTypeRef(ICharacteristicTypeRef ref) throws JDomDataObjectException {
        this(JDomDataObjectFactory.getRootElement(ref.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        String id = this.getCharacteristicTypeId();
        if (id != null) {
            element.setAttribute("id", id);
        } else {
            element.removeAttribute("id");
        }
        String usageId = this.getUsageId();
        if (usageId != null) {
            element.setAttribute("usage_id", usageId);
        } else {
            element.removeAttribute("usage_id");
        }
        Element element2 = XMLUtilities.getOrCreateChild(element, "db_office_id");
        DbOfficeId dbOfficeId = new DbOfficeId(this._officeId);
        dbOfficeId.buildElement(element2);
    }

    @Override
    @EntityBeanMap(attributeName="officeId")
    public String getOfficeId() {
        return this._officeId;
    }

    @Override
    public void setOfficeId(String id) {
        this._officeId = id;
    }

    @Override
    @EntityBeanMap(attributeName="characteristicId")
    public String getCharacteristicTypeId() {
        return this.getName();
    }

    @Override
    public void setCharacteristicTypeId(String id) {
        this.setName(id);
    }

    @Override
    public String getUsageId() {
        return this._usageId;
    }

    @Override
    public void setUsageId(String s) {
        this._usageId = s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._officeId == null ? 0 : this._officeId.hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getUsageId() == null ? 0 : this.getUsageId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomCharacteristicTypeRef other = (JDomCharacteristicTypeRef)obj;
        if (this._officeId == null ? other._officeId != null : !this._officeId.equals(other._officeId)) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getUsageId() == null ? other.getUsageId() != null : !this.getUsageId().equals(other.getUsageId()));
    }

    @Override
    public int compareTo(Object otherObj) {
        int c2;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == otherObj) {
            return 0;
        }
        if (otherObj == null) {
            return 1;
        }
        if (this.getClass() != otherObj.getClass()) {
            return super.compareTo(otherObj);
        }
        JDomCharacteristicTypeRef other = (JDomCharacteristicTypeRef)otherObj;
        if (this._officeId == null) {
            if (other._officeId != null) {
                return -1;
            }
        } else if (other._officeId != null && (c2 = this._officeId.compareTo(other._officeId)) != 0) {
            return c2;
        }
        if (this._usageId == null) {
            if (other._usageId != null) {
                return -1;
            }
        } else if (other._usageId != null && (c2 = this._usageId.compareTo(other._usageId)) != 0) {
            return c2;
        }
        if (this.getName() == null) {
            if (other.getName() != null) {
                return -1;
            }
        } else if (other.getName() != null && (c2 = this.getName().compareTo(other.getName())) != 0) {
            return c2;
        }
        return 0;
    }

    @Override
    public String getPropertyCategory() {
        return JDomCharacteristicTypeRef.getDefinitionPropertyCategory(this.getUsageId()) + "." + this.getCharacteristicTypeId();
    }

    public static String getDefinitionPropertyCategory(String usageId) {
        return "characteristic_type." + usageId + ".definition";
    }

    public static String getAssignmentPropertyCategory(String usageId) {
        return "characteristic_type." + usageId + ".assignment";
    }
}

