/*
 * Decompiled with CFR 0.152.
 */
package hec.data.embankment;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.embankment.IEmbankment;
import hec.data.location.Location;
import hec.data.location.LocationTemplate;
import hec.data.lookup.ILookupType;
import hec.data.lookup.JDomLookupTypeImpl;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.EmbankmentObjTUser")
public class JDomEmbankmentImpl
extends AbstractJDomDataObject
implements IEmbankment {
    private JDomLookupTypeImpl _downstreamProtType;
    private double _downstreamSideslope = Double.NEGATIVE_INFINITY;
    private LocationTemplate _projectLocation;
    private Location _embankmentLocation;
    private double _heightMax = Double.NEGATIVE_INFINITY;
    private double _structureLength = Double.NEGATIVE_INFINITY;
    private double _topWidth = Double.NEGATIVE_INFINITY;
    private JDomLookupTypeImpl _structureType;
    private double _upstreamSideslope = Double.NEGATIVE_INFINITY;
    private JDomLookupTypeImpl _upstreamProtType;

    public JDomEmbankmentImpl() {
    }

    public JDomEmbankmentImpl(Element element) {
        if (element != null) {
            JDomLookupTypeImpl ept1;
            JDomLookupTypeImpl est;
            Location embLoc;
            LocationTemplate projLoc;
            JDomLookupTypeImpl ept;
            Element subElement = element.getChild("downstream_prot_type");
            this._downstreamProtType = ept = new JDomLookupTypeImpl(subElement);
            Element subElement2 = element.getChild("embankment_project_loc");
            this._projectLocation = projLoc = LocationTemplate.parse(subElement2);
            Element elem = element.getChild("embankment_loc");
            this._embankmentLocation = embLoc = Location.parseElement(elem);
            if (this._embankmentLocation != null) {
                this.setName(this._embankmentLocation.getLocationId());
            }
            Element subElement5 = element.getChild("structure_type");
            this._structureType = est = new JDomLookupTypeImpl(subElement5);
            Element subElement7 = element.getChild("upstream_prot_type");
            this._upstreamProtType = ept1 = new JDomLookupTypeImpl(subElement7);
            ParamDouble paramDouble = new ParamDouble();
            this._heightMax = JDomEmbankmentImpl.getXmlValue(paramDouble, element, "height_max", Parameter.PARAMID_LENGTH);
            this._structureLength = JDomEmbankmentImpl.getXmlValue(paramDouble, element, "structure_length", Parameter.PARAMID_LENGTH);
            this._downstreamSideslope = JDomEmbankmentImpl.getXmlValue(paramDouble, element, "downstream_sideslope", Parameter.PARAMID_PERCENT);
            this._topWidth = JDomEmbankmentImpl.getXmlValue(paramDouble, element, "top_width", Parameter.PARAMID_WIDTH);
            this._upstreamSideslope = JDomEmbankmentImpl.getXmlValue(paramDouble, element, "upstream_sideslope", Parameter.PARAMID_PERCENT);
        }
    }

    public JDomEmbankmentImpl(LocationTemplate projectLocationRef, Location embankmentLocation, ILookupType structureType) {
        this._projectLocation = projectLocationRef;
        this._embankmentLocation = embankmentLocation;
        if (this._embankmentLocation != null) {
            this.setName(this._embankmentLocation.getLocationId());
        }
        this._structureType = new JDomLookupTypeImpl(structureType);
    }

    public JDomEmbankmentImpl(IEmbankment iembankment) {
        this(JDomDataObjectFactory.getRootElement(iembankment.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        Element structureType = XMLUtilities.getOrCreateChild(element, "structure_type");
        if (this.getStructureType() != null) {
            this.getStructureType().buildElement(structureType);
        }
        Element upstreamProtType = XMLUtilities.getOrCreateChild(element, "upstream_prot_type");
        if (this.getUpstreamProtType() != null) {
            this.getUpstreamProtType().buildElement(upstreamProtType);
        }
        Element downstreamProtType = XMLUtilities.getOrCreateChild(element, "downstream_prot_type");
        if (this.getDownstreamProtType() != null) {
            this.getDownstreamProtType().buildElement(downstreamProtType);
        }
        Element embankProjectLoc = XMLUtilities.getOrCreateChild(element, "embankment_project_loc");
        if (this.getParentLocationRef() != null) {
            this.getParentLocationRef().buildElement(embankProjectLoc);
        }
        Element embankLoc = XMLUtilities.getOrCreateChild(element, "embankment_loc");
        if (this.getLocation() != null) {
            this.getLocation().buildElement(embankLoc);
        }
        ParamDouble paramDouble = new ParamDouble();
        JDomEmbankmentImpl.setXmlValue(paramDouble, element, "structure_length", this.getStructureLength(), Parameter.PARAMID_LENGTH);
        JDomEmbankmentImpl.setXmlValue(paramDouble, element, "upstream_sideslope", this.getUpstreamSideslope(), Parameter.PARAMID_PERCENT);
        JDomEmbankmentImpl.setXmlValue(paramDouble, element, "downstream_sideslope", this.getDownstreamSideslope(), Parameter.PARAMID_PERCENT);
        JDomEmbankmentImpl.setXmlValue(paramDouble, element, "height_max", this.getHeightMax(), Parameter.PARAMID_LENGTH);
        JDomEmbankmentImpl.setXmlValue(paramDouble, element, "top_width", this.getTopWidth(), Parameter.PARAMID_WIDTH);
    }

    @Override
    @EntityBean(attributeName="ProjectLocationRef")
    public LocationTemplate getParentLocationRef() {
        return this._projectLocation;
    }

    @Override
    public void setParentLocationRef(LocationTemplate projectLoc) {
        this._projectLocation = projectLoc;
    }

    @Override
    @EntityBean(attributeName="EmbankmentLocation")
    public Location getLocation() {
        return this._embankmentLocation;
    }

    @Override
    public void setLocation(Location location) {
        this._embankmentLocation = location;
        if (this._embankmentLocation != null) {
            this.setName(this._embankmentLocation.getLocationId());
        }
    }

    @Override
    @EntityBean(attributeName="StructureType")
    public JDomLookupTypeImpl getStructureType() {
        return this._structureType;
    }

    @Override
    @EntityBeanMap(attributeName="UnitsId")
    public String getLengthUnits() {
        return Parameter.getUnitsStringForSystem(Parameter.PARAMID_LENGTH, 2);
    }

    public void setLengthUnits(String units) {
    }

    @Override
    @EntityBeanMap(attributeName="heightMax")
    public double getHeightMax() {
        return this._heightMax;
    }

    @Override
    public void setHeightMax(double heightMax) {
        this._heightMax = heightMax;
    }

    @Override
    @EntityBeanMap(attributeName="structureLength")
    public double getStructureLength() {
        return this._structureLength;
    }

    @Override
    @EntityBeanMap(attributeName="topWidth")
    public double getTopWidth() {
        return this._topWidth;
    }

    @Override
    @EntityBean(attributeName="UpstreamProtType")
    public JDomLookupTypeImpl getUpstreamProtType() {
        return this._upstreamProtType;
    }

    @Override
    @EntityBeanMap(attributeName="UpstreamSideslope")
    public double getUpstreamSideslope() {
        return this._upstreamSideslope;
    }

    @Override
    public void setDownstreamProtType(ILookupType downstreamProtectionType) {
        this._downstreamProtType = downstreamProtectionType == null ? null : new JDomLookupTypeImpl(downstreamProtectionType);
    }

    @Override
    public void setDownstreamSideslope(double downstreamSideslope) {
        this._downstreamSideslope = downstreamSideslope;
    }

    @Override
    public void setStructureLength(double structureLength) {
        this._structureLength = structureLength;
    }

    @Override
    public void setStructureType(ILookupType structureType) {
        this._structureType = structureType == null ? null : new JDomLookupTypeImpl(structureType);
    }

    @Override
    public void setTopWidth(double topWidth) {
        this._topWidth = topWidth;
    }

    @Override
    public void setUpstreamProtType(ILookupType upstreamProtType) {
        this._upstreamProtType = upstreamProtType == null ? null : new JDomLookupTypeImpl(upstreamProtType);
    }

    @Override
    public void setUpstreamSideslope(double upstreamSideslope) {
        this._upstreamSideslope = upstreamSideslope;
    }

    @Override
    @EntityBean(attributeName="downstreamProtType")
    public JDomLookupTypeImpl getDownstreamProtType() {
        return this._downstreamProtType;
    }

    @Override
    @EntityBeanMap(attributeName="DownstreamSideslope")
    public double getDownstreamSideslope() {
        return this._downstreamSideslope;
    }

    @Override
    public String toString() {
        Location embankmentLocation = this.getLocation();
        if (embankmentLocation == null) {
            return super.toString();
        }
        return embankmentLocation.getLocationId();
    }

    @Override
    public void getDownstreamSideslope(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_PERCENT);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._downstreamSideslope);
    }

    @Override
    public void setDownstreamSideslope(ParamDouble paramDouble) {
        this._downstreamSideslope = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getHeightMax(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_LENGTH);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._heightMax);
    }

    @Override
    public void setHeightMax(ParamDouble paramDouble) {
        this._heightMax = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getStructureLength(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_LENGTH);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._structureLength);
    }

    @Override
    public void setStructureLength(ParamDouble paramDouble) {
        this._structureLength = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getTopWidth(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_WIDTH);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._topWidth);
    }

    @Override
    public void setTopWidth(ParamDouble paramDouble) {
        this._topWidth = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getUpstreamSideslope(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_PERCENT);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._upstreamSideslope);
    }

    @Override
    public void setUpstreamSideslope(ParamDouble paramDouble) {
        this._upstreamSideslope = paramDouble.convertToUnitSystem(2);
    }
}

