/*
 * Decompiled with CFR 0.152.
 */
package hec.data.fragilitycurve;

import hec.data.Parameter;
import hec.data.fragilitycurve.StructureBreachMethods;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecPairedData;
import hec.io.DSSIdentifier;
import hec.io.PairedDataContainer;
import hec.lang.annotation.Scriptable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FragilityCurvePairedDataContainer {
    private static final String DURATION = "duration in hours";
    private PairedDataContainer _pdc = new PairedDataContainer();
    private boolean _pdcSuccessfullyParsed;
    private Double _durationInHours;
    private String _failureModeName;
    private StructureBreachMethods _breachMethod;

    public FragilityCurvePairedDataContainer() {
    }

    public FragilityCurvePairedDataContainer(FragilityCurvePairedDataContainer fragilityCurveOutputLocation) {
        fragilityCurveOutputLocation._pdc.clone(this._pdc);
        this._failureModeName = fragilityCurveOutputLocation._failureModeName;
        this._breachMethod = fragilityCurveOutputLocation._breachMethod;
        this._durationInHours = fragilityCurveOutputLocation._durationInHours;
    }

    @Scriptable
    public static FragilityCurvePairedDataContainer getFragilityCurvePairedDataContainer(DSSIdentifier dssId) {
        PairedDataContainer pdc = FragilityCurvePairedDataContainer.readPairedDataContainer(dssId);
        return FragilityCurvePairedDataContainer.getFragilityCurvePairedDataContainer(pdc);
    }

    @Scriptable
    public static FragilityCurvePairedDataContainer getFragilityCurvePairedDataContainer(String dssFile, String dssPath) {
        DSSIdentifier dssId = new DSSIdentifier(dssFile, dssPath);
        PairedDataContainer pdc = FragilityCurvePairedDataContainer.readPairedDataContainer(dssId);
        return FragilityCurvePairedDataContainer.getFragilityCurvePairedDataContainer(pdc);
    }

    @Scriptable
    public static FragilityCurvePairedDataContainer getFragilityCurvePairedDataContainer(PairedDataContainer pdc) {
        if (pdc == null) {
            return null;
        }
        FragilityCurvePairedDataContainer retval = new FragilityCurvePairedDataContainer();
        retval.setPairedDataContainer(pdc);
        DSSIdentifier dssId = new DSSIdentifier(pdc.fileName, pdc.fullName);
        DSSPathname pathname = new DSSPathname(pdc.fullName);
        retval.initialize(pdc.location, dssId, pathname, 1);
        if (retval.successfullyReadPDC()) {
            return retval;
        }
        return null;
    }

    private static PairedDataContainer readPairedDataContainer(DSSIdentifier dssId) {
        PairedDataContainer pdc = new PairedDataContainer();
        HecPairedData hpd = new HecPairedData(dssId.getFileName());
        pdc.fullName = dssId.getDSSPath();
        pdc.fileName = dssId.getFileName();
        int rv = hpd.read(pdc);
        if (rv != 0) {
            Logger.getLogger(FragilityCurvePairedDataContainer.class.getName()).log(Level.WARNING, "Failed to read PairedDataContainer " + dssId + " Rv=" + rv);
        }
        return pdc;
    }

    public void setPairedDataContainer(PairedDataContainer pdc) {
        this._pdc = pdc;
    }

    public void initialize(String locName, DSSIdentifier dssId, DSSPathname pathname, int unitSystem) {
        this._pdcSuccessfullyParsed = true;
        if (this._pdc == null || this._pdc.numberOrdinates == 0 || this._pdc.numberCurves == 0) {
            this.initializePairedDataContainer(locName, dssId.getFileName(), pathname, unitSystem);
            this._pdcSuccessfullyParsed = false;
        } else if (this._pdc.numberCurves >= 1) {
            this._durationInHours = null;
            double elevation = this._pdc.yOrdinates[0][0];
            this._pdc.yOrdinates = new double[2][1];
            this._pdc.yOrdinates[0][0] = elevation;
            if (this._pdc.numberCurves == 2) {
                this._durationInHours = this._pdc.yOrdinates[1][0];
                if (this._durationInHours < 0.0) {
                    this._durationInHours = null;
                }
            }
            if (this._pdc.labels != null && this._pdc.labels.length >= 1) {
                String[] info = this._pdc.labels[0].split(":");
                if (info.length == 2) {
                    this._failureModeName = info[0];
                    try {
                        this._breachMethod = StructureBreachMethods.valueOf(info[1]);
                        this._pdcSuccessfullyParsed &= true;
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getLogger(FragilityCurvePairedDataContainer.class.getName()).log(Level.WARNING, "Unable to parse breach method", e);
                        this._pdcSuccessfullyParsed = false;
                    }
                } else {
                    this._pdcSuccessfullyParsed = false;
                }
            } else {
                Logger.getLogger(FragilityCurvePairedDataContainer.class.getName()).log(Level.WARNING, "No Labels found in the PDC to determine the Breach Method");
                this._pdcSuccessfullyParsed = false;
            }
        } else {
            this._pdcSuccessfullyParsed = false;
        }
    }

    private void initializePairedDataContainer(String locName, String filename, DSSPathname pathname, int unitSystem) {
        this._pdc = new PairedDataContainer();
        this._pdc.fileName = filename;
        this._pdc.fullName = pathname.getPathname();
        this._pdc.location = pathname.bPart();
        this._pdc.version = pathname.fPart();
        this._pdc.xparameter = "Probability";
        this._pdc.xunits = "";
        this._pdc.yparameter = "elev";
        this._pdc.yunits = Parameter.getUnitsStringForSystem(Parameter.PARAMID_STAGE, unitSystem);
        this._pdc.ytype = "elev";
        this._pdc.numberCurves = 2;
        this._pdc.numberOrdinates = 1;
        this._pdc.labels = new String[]{locName, DURATION};
        this._pdc.labelsUsed = true;
        this._pdc.xOrdinates = new double[1];
        this._pdc.yOrdinates = new double[2][1];
        Arrays.fill(this._pdc.xOrdinates, Double.NEGATIVE_INFINITY);
        this._pdc.yOrdinates[1][0] = -1.0;
    }

    public PairedDataContainer getPairedDataContainer() {
        return this._pdc;
    }

    public void setFilename(String dssFilename) {
        this._pdc.fileName = dssFilename;
    }

    public void setSampledProbabilityAndElevation(double prob, double elevation) {
        this._pdc.xOrdinates[0] = prob;
        this._pdc.yOrdinates[0][0] = elevation;
    }

    public void setSampledDuration(Double durationInHours) {
        this._durationInHours = durationInHours;
        this.updateZOrdinateForDuration();
    }

    private void updateZOrdinateForDuration() {
        this._pdc.yOrdinates[1][0] = this._durationInHours == null ? -1.0 : this._durationInHours;
    }

    @Scriptable
    public Double getDurationInHours() {
        if (this.successfullyReadPDC()) {
            return this._durationInHours;
        }
        return null;
    }

    public void setBreachMethod(StructureBreachMethods breachMethod) {
        this._breachMethod = breachMethod;
    }

    @Scriptable
    public StructureBreachMethods getBreachMethod() {
        if (this.successfullyReadPDC()) {
            return this._breachMethod;
        }
        return null;
    }

    @Scriptable
    public String getFailureModeName() {
        if (this.successfullyReadPDC()) {
            return this._failureModeName;
        }
        return null;
    }

    @Scriptable
    public void setFailureModeName(String failureModeName) {
        this._failureModeName = failureModeName;
    }

    public String getPathname() {
        return this.getFullname();
    }

    public void updatePDCFields(String filename) {
        this._pdc.numberOrdinates = 1;
        this._pdc.numberCurves = 2;
        this.updateZOrdinateForDuration();
        this._pdc.labels = new String[]{this._failureModeName + ":" + this._breachMethod.name(), DURATION};
        this._pdc.fileName = filename;
    }

    public String getFilename() {
        return this._pdc.fileName;
    }

    public String getFullname() {
        return this._pdc.fullName;
    }

    @Scriptable
    public double getBreachProbability() {
        if (this.successfullyReadPDC()) {
            return this._pdc.xOrdinates[0];
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Scriptable
    public double getBreachElevation() {
        if (this.successfullyReadPDC()) {
            return this._pdc.yOrdinates[0][0];
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean successfullyReadPDC() {
        return this._pdcSuccessfullyParsed;
    }

    public void setFullname(String pathname) {
        this._pdc.fullName = pathname;
    }

    public void setVersion(String fPart) {
        this._pdc.version = fPart;
    }
}

