/*
 * Decompiled with CFR 0.152.
 */
package hec.data.gates;

import hec.data.ParamDouble;
import hec.data.ParamDoubleSupport;
import hec.data.gates.IGateChange;
import hec.data.gates.IGateChangeRef;
import hec.data.gates.IGateSetting;
import hec.data.location.LocationTemplate;
import hec.data.lookup.ILookupType;
import hec.data.operations.PhysicalStructureOperationalChange;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jdom.Element;

public class JDomGateChange
extends PhysicalStructureOperationalChange<IGateChangeRef>
implements IGateChange {
    int _poolTailDifferentialOrder = 1;
    int _poolReferenceDifferentialOrder = 1;
    private NavigableMap<LocationTemplate, IGateSetting> _gateSettings = new TreeMap<LocationTemplate, IGateSetting>(LocationTemplate.LocationComparator);
    private double _referenceElevation;

    public JDomGateChange() {
    }

    public JDomGateChange(IGateChangeRef gateChangeRef, double poolElevation, ILookupType dischargeComputationLookup, ILookupType releaseReasonLookup, boolean isProtected) {
        super(gateChangeRef, dischargeComputationLookup, releaseReasonLookup, isProtected);
        this.setPoolElevation(poolElevation);
    }

    public JDomGateChange(IGateChangeRef gateChangeRef) {
        super(gateChangeRef);
    }

    @Override
    public void buildElement(Element element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NavigableMap<LocationTemplate, IGateSetting> getOperationalSettings() {
        return this._gateSettings;
    }

    @Override
    public void setOperationalSettings(NavigableMap<LocationTemplate, IGateSetting> gateSettings) {
        this._gateSettings.clear();
        this._gateSettings.putAll(gateSettings);
    }

    @Override
    public int size() {
        return this._gateSettings.size();
    }

    @Override
    public double getPoolTailwaterElevationDifference() {
        if (this._poolTailDifferentialOrder == 1) {
            return this.getPoolElevation() - this.getTailwaterElevation();
        }
        return this.getTailwaterElevation() - this.getPoolElevation();
    }

    @Override
    public void getPoolTailwaterElevationDifference(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this.getPoolTailwaterElevationDifference());
    }

    @Override
    public double getPoolReferenceElevationDifference() {
        return this.getPoolElevation() - this.getTailwaterElevation();
    }

    @Override
    public void getPoolReferenceElevationDifference(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this.getPoolTailwaterElevationDifference());
    }

    @Override
    public void setHeadwaterTailwaterDifferentialOrder(int order) {
        this._poolTailDifferentialOrder = order;
    }

    @Override
    public void setHeadwaterReferenceDifferentialOrder(int order) {
        this._poolReferenceDifferentialOrder = order;
    }

    @Override
    public double getReferenceElevation() {
        return this._referenceElevation;
    }

    @Override
    public void setReferenceElevation(double d) {
        this._referenceElevation = d;
    }

    @Override
    public void getReferenceElevation(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this._referenceElevation);
    }

    @Override
    public void setReferenceElevation(ParamDouble pd) {
        this._referenceElevation = pd.convertToUnitSystem(2);
    }

    @Override
    public double getTailwaterPoolElevationDifference() {
        return this.getTailwaterElevation() - this.getPoolElevation();
    }

    @Override
    public void getTailwaterPoolElevationDifference(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this.getTailwaterPoolElevationDifference());
    }

    @Override
    public double getReferencePoolElevationDifference() {
        return this.getReferenceElevation() - this.getPoolElevation();
    }

    @Override
    public void getReferencePoolElevationDifference(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this.getReferencePoolElevationDifference());
    }
}

