/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

public enum IndicatorConditionOperator {
    EQ("EQ", "="),
    NE("NE", "\u00e2\u2030\u00a0"),
    LT("LT", "<"),
    LE("LT", "\u00e2\u2030\u00a4"),
    GT("GT", ">"),
    GE("GE", "\u00e2\u2030\u00a5");

    private final String _name;
    private final String _label;

    private IndicatorConditionOperator(String name, String label) {
        this._name = name;
        this._label = label;
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        return this._label;
    }

    public String toString() {
        return this._label;
    }

    public static IndicatorConditionOperator lookup(String operatorName) {
        if (operatorName == null) {
            return null;
        }
        for (IndicatorConditionOperator conditionOperator : IndicatorConditionOperator.values()) {
            if (!conditionOperator.getName().toUpperCase().equals(operatorName.toUpperCase())) continue;
            return conditionOperator;
        }
        return null;
    }
}

