/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.AbstractJDomDataObject;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Duration;
import hec.data.JDomDataObjectFactory;
import hec.data.Parameter;
import hec.data.ParameterType;
import hec.data.level.IAttributeParameterTypedValue;
import hec.data.level.JDomParameterTypedValueImpl;
import hec.util.XMLUtilities;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class JDomAttributeParameterTypedValue
extends AbstractJDomDataObject
implements IAttributeParameterTypedValue {
    public static final String DELIM = ".";
    private String _value = null;
    private Parameter _parameter;
    private ParameterType _parameterType;
    private Duration _duration;
    private String _attributeUnit;

    public JDomAttributeParameterTypedValue() {
    }

    public JDomAttributeParameterTypedValue(Element element) {
        if (element != null) {
            Element child = element.getChild("parameter");
            if (child != null) {
                try {
                    this._parameter = new Parameter(child.getAttributeValue("id"));
                }
                catch (DataSetIllegalArgumentException ex) {
                    Logger.getLogger(JDomParameterTypedValueImpl.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            if ((child = element.getChild("parameter_type")) != null) {
                try {
                    this._parameterType = new ParameterType(child.getAttributeValue("id"));
                }
                catch (DataSetIllegalArgumentException ex) {
                    Logger.getLogger(JDomParameterTypedValueImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if ((child = element.getChild("duration")) != null) {
                try {
                    this._duration = new Duration(child.getAttributeValue("id"));
                }
                catch (DataSetIllegalArgumentException ex) {
                    Logger.getLogger(JDomParameterTypedValueImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if ((child = element.getChild("value")) != null) {
                this._value = child.getText();
                this._attributeUnit = child.getAttributeValue("unit");
            }
            this.setComment(element.getChildText("comment"));
        }
    }

    void buildElement(Element element, boolean fullDescription) {
        if (element != null) {
            Element child;
            if (fullDescription) {
                child = XMLUtilities.getOrCreateChild(element, "parameter");
                if (this._parameter != null) {
                    child.setAttribute("id", this._parameter.toString());
                } else {
                    child.removeContent();
                }
                child = XMLUtilities.getOrCreateChild(element, "parameter_type");
                if (this._parameterType != null) {
                    child.setAttribute("id", this._parameterType.toString());
                } else {
                    child.removeContent();
                }
                child = XMLUtilities.getOrCreateChild(element, "duration");
                if (this._duration != null) {
                    child.setAttribute("id", this._duration.toString());
                } else {
                    child.removeContent();
                }
                child = XMLUtilities.getOrCreateChild(element, "comment");
                String comment = this.getComment();
                if (comment != null && !comment.isEmpty()) {
                    child.setText(comment);
                } else {
                    child.removeContent();
                }
            } else {
                element.removeChild("parameter");
                element.removeChild("parameter_type");
                element.removeChild("comment");
                element.removeChild("duration");
            }
            if (this._value != null) {
                child = XMLUtilities.getOrCreateChild(element, "value");
                child.setText(this._value);
                if (this._attributeUnit != null && !this._attributeUnit.isEmpty()) {
                    element.getChild("value").setAttribute("unit", this._attributeUnit);
                } else {
                    element.getChild("value").removeAttribute("unit");
                }
            }
        }
    }

    @Override
    public void buildElement(Element element) {
        this.buildElement(element, true);
    }

    public JDomAttributeParameterTypedValue(IAttributeParameterTypedValue value) {
        this(JDomDataObjectFactory.getRootElement(value.toXmlString()));
    }

    public JDomAttributeParameterTypedValue(Parameter attrParameter, ParameterType attrParameterType, Duration attrDuration, String attributeValue, String attributeUnits) {
        this._parameter = attrParameter;
        this._parameterType = attrParameterType;
        this._duration = attrDuration;
        this._value = attributeValue;
        this._attributeUnit = attributeUnits;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public BigDecimal getValueBigDecimal() {
        return new BigDecimal(this._value);
    }

    @Override
    public void setValue(String valueInAttrUnits) {
        this._value = valueInAttrUnits;
    }

    @Override
    public String getUnits() {
        return this._attributeUnit;
    }

    @Override
    public void setUnits(String units) {
        this._attributeUnit = units;
    }

    @Override
    public Parameter getParameter() {
        return this._parameter;
    }

    @Override
    public void setParameter(Parameter param) {
        this._parameter = param;
    }

    @Override
    public ParameterType getParameterType() {
        return this._parameterType;
    }

    @Override
    public void setParameterType(ParameterType type) {
        this._parameterType = type;
    }

    @Override
    public Duration getDuration() {
        return this._duration;
    }

    @Override
    public void setDuration(Duration duration) {
        this._duration = duration;
    }

    @Override
    public String getComment() {
        return this.getDescription();
    }

    @Override
    public void setComment(String comment) {
        this.setDescription(comment);
    }

    @Override
    public String getFullAttributeId() {
        StringBuilder sb = new StringBuilder();
        if (this._parameter != null && this._parameterType != null && this._duration != null) {
            sb.append(this._parameter.toString()).append(DELIM).append(this._parameterType.toString()).append(DELIM).append(this._duration.toString()).append(DELIM).append(this._value).append(",").append(this._attributeUnit);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getAttributeId();
    }

    @Override
    public String getAttributeId() {
        StringBuilder sb = new StringBuilder();
        if (this._parameter != null && this._parameterType != null && this._duration != null) {
            sb.append(this._parameter.toString()).append(DELIM).append(this._parameterType.toString()).append(DELIM).append(this._duration.toString());
        }
        return sb.toString();
    }
}

