/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.AbstractJDomDataObject;
import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Duration;
import hec.data.JDomDataObjectFactory;
import hec.data.Parameter;
import hec.data.ParameterType;
import hec.data.level.IAttributeParameterTypedValue;
import hec.data.level.ILocationLevel;
import hec.data.level.ILocationLevelRef;
import hec.data.level.IParameterTypedValue;
import hec.data.level.ISeasonalInterval;
import hec.data.level.ISeasonalValues;
import hec.data.level.ISpecifiedLevel;
import hec.data.level.JDomAttributeParameterTypedValue;
import hec.data.level.JDomLocationLevelRef;
import hec.data.level.JDomParameterTypedValueImpl;
import hec.data.level.JDomSeasonalIntervalImpl;
import hec.data.level.JDomSeasonalValuesImpl;
import hec.data.location.LocationTemplate;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import java.math.BigDecimal;
import java.util.Date;
import org.jdom.Attribute;
import org.jdom.Element;
import rma.util.RMAConst;

@EntityBeanType(beanType="usace.cwms.db.oracle.LocationLevelT")
public class JDomLocationLevelImpl
extends AbstractJDomDataObject
implements ILocationLevel {
    public static final String DELIM = ".";
    static final String INTERPOLATE = "interpolate";
    private JDomParameterTypedValueImpl _constantValue = null;
    private Date _effectiveDate;
    private Date _seasonalStartDate;
    private Date _seasonalEndDate;
    private JDomSeasonalValuesImpl _seasonalValues = null;
    private JDomLocationLevelRef _locationLevelRef;
    private String _levelComment;
    private String _seasonalTimeSeriesIdentifier;
    private Boolean _interpolateSeasonal;
    private String _levelUnits;

    public JDomLocationLevelImpl() {
    }

    public JDomLocationLevelImpl(LocationTemplate locationRef, ISpecifiedLevel specifiedLevel, IParameterTypedValue value, IAttributeParameterTypedValue attribute, Date date, String levelUnits) {
        this._levelUnits = levelUnits;
        this._locationLevelRef = new JDomLocationLevelRef();
        this._locationLevelRef.setLocationRef(locationRef);
        this._locationLevelRef.setSpecifiedLevel(specifiedLevel);
        this._locationLevelRef.setAttribute(attribute);
        this._levelComment = value.getComment();
        this._constantValue = value instanceof JDomParameterTypedValueImpl ? (JDomParameterTypedValueImpl)value : new JDomParameterTypedValueImpl(value);
        this._locationLevelRef.setPrototypeLevel(new JDomParameterTypedValueImpl(this._constantValue));
        this._effectiveDate = date;
    }

    public JDomLocationLevelImpl(ILocationLevel locationLevel) {
        this(JDomDataObjectFactory.getRootElement(locationLevel.toXmlString()));
    }

    public JDomLocationLevelImpl(String officeId, String locLevelId, Date effectiveDate, String levelUnits, String attributeId, String attributeValue, String attributeUnits) throws DataSetException {
        this._levelUnits = levelUnits;
        this._effectiveDate = effectiveDate;
        this._locationLevelRef = new JDomLocationLevelRef(officeId, locLevelId, attributeId, attributeValue, attributeUnits);
        this._constantValue = new JDomParameterTypedValueImpl(this._locationLevelRef.getPrototypeLevel());
    }

    public JDomLocationLevelImpl(Element element) {
        if (element != null) {
            Element child = element.getChild("location_level_ref");
            Attribute attribute = child.getAttribute(INTERPOLATE);
            if (attribute != null) {
                XMLUtilities.getAttributeValueAsBoolean(child, INTERPOLATE, this._interpolateSeasonal == null ? false : this._interpolateSeasonal);
            }
            this._locationLevelRef = new JDomLocationLevelRef(child);
            this._constantValue = new JDomParameterTypedValueImpl(element.getChild("level"));
            this._effectiveDate = JDomLocationLevelImpl.getXmlDate(element, "date", "ddMMMyyyy HH:mmZ");
            child = element.getChild("seasonal_values");
            if (child != null) {
                this._seasonalValues = new JDomSeasonalValuesImpl(child, this._locationLevelRef.getPrototypeLevel());
            }
            if ((child = element.getChild("seasonal_time_series_id")) != null) {
                this._seasonalTimeSeriesIdentifier = child.getText();
            }
            if ((child = element.getChild("comment")) != null) {
                this._levelComment = child.getText();
            }
            if ((child = element.getChild("level_units_id")) != null) {
                this._levelUnits = child.getText();
            }
        }
    }

    @Override
    public void buildElement(Element element) {
        if (element != null) {
            Element child = XMLUtilities.getOrCreateChild(element, "location_level_ref");
            if (this._interpolateSeasonal != null) {
                child.setAttribute(INTERPOLATE, this.getInterpolateString());
            }
            if (this._locationLevelRef != null) {
                this._locationLevelRef.buildElement(child);
            }
            if (this._effectiveDate != null) {
                JDomLocationLevelImpl.setXmlDate(element, "date", "ddMMMyyyy HH:mmZ", this._effectiveDate);
            } else {
                element.removeChild("date");
            }
            if (this._seasonalStartDate != null) {
                JDomLocationLevelImpl.setXmlDate(element, "seasonal_start_date", "ddMMMyyyy HH:mmZ", this._seasonalStartDate);
            } else {
                element.removeChild("seasonal_start_date");
            }
            if (this._seasonalEndDate != null) {
                JDomLocationLevelImpl.setXmlDate(element, "seasonal_end_date", "ddMMMyyyy HH:mmZ", this._seasonalEndDate);
            } else {
                element.removeChild("seasonal_end_date");
            }
            if (this._constantValue != null) {
                child = XMLUtilities.getOrCreateChild(element, "level");
                this._constantValue.buildElement(child);
            } else {
                element.removeChild("level");
            }
            if (this._seasonalValues != null) {
                child = XMLUtilities.getOrCreateChild(element, "seasonal_values");
                this._seasonalValues.buildElement(child);
            } else {
                element.removeChild("seasonal_values");
            }
            if (this._seasonalTimeSeriesIdentifier != null && !this._seasonalTimeSeriesIdentifier.isEmpty()) {
                child = XMLUtilities.getOrCreateChild(element, "seasonal_time_series_id");
                child.setText(this._seasonalTimeSeriesIdentifier);
            } else {
                element.removeChild("seasonal_time_series_id");
            }
            if (this._levelComment != null && !this._levelComment.isEmpty()) {
                child = XMLUtilities.getOrCreateChild(element, "comment");
                child.setText(this._levelComment);
            } else {
                element.removeChild("comment");
            }
            if (this._levelUnits != null && !this._levelUnits.isEmpty()) {
                child = XMLUtilities.getOrCreateChild(element, "level_units_id");
                child.setText(this._levelUnits);
            } else {
                element.removeChild("level_units_id");
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._locationLevelRef == null ? 0 : this._locationLevelRef.hashCode());
        result = 31 * result + (this._effectiveDate == null ? 0 : this._effectiveDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomLocationLevelImpl other = (JDomLocationLevelImpl)obj;
        if (this._locationLevelRef == null ? other._locationLevelRef != null : !this._locationLevelRef.equals(other._locationLevelRef)) {
            return false;
        }
        return !(this._effectiveDate == null ? other._effectiveDate != null : !this._effectiveDate.equals(other._effectiveDate));
    }

    @Override
    public ILocationLevelRef getLocationLevelRef() {
        return this._locationLevelRef;
    }

    @Override
    public void setLocationLevelRef(ILocationLevelRef iLocationLevelRef) {
        this._locationLevelRef = iLocationLevelRef instanceof JDomLocationLevelRef ? (JDomLocationLevelRef)iLocationLevelRef : new JDomLocationLevelRef(iLocationLevelRef);
    }

    @Override
    public void setSpecifiedLevel(ISpecifiedLevel level) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setSpecifiedLevel(level);
    }

    @Override
    public ISpecifiedLevel getSpecifiedLevel() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getSpecifiedLevel();
    }

    @Override
    public IParameterTypedValue getConstantLevel() {
        return this._constantValue;
    }

    @Override
    public Date getDate() {
        return this._effectiveDate;
    }

    @Override
    public ISeasonalValues getSeasonalValues() {
        return this._seasonalValues;
    }

    @Override
    public LocationTemplate getLocationRef() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getLocationRef();
    }

    @Override
    public void setLocationRef(LocationTemplate locRef) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setLocationRef(locRef);
    }

    @Override
    public void setDate(Date date) {
        this._effectiveDate = date;
    }

    @Override
    public void setConstantLevel(IParameterTypedValue level) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        if (level instanceof JDomParameterTypedValueImpl) {
            this._constantValue = (JDomParameterTypedValueImpl)level;
            this._locationLevelRef.setPrototypeLevel(new JDomParameterTypedValueImpl(level));
            this._seasonalValues = null;
            this._seasonalTimeSeriesIdentifier = null;
        } else if (level != null) {
            this._constantValue = new JDomParameterTypedValueImpl(level);
            this._locationLevelRef.setPrototypeLevel(new JDomParameterTypedValueImpl(level));
            this._seasonalValues = null;
            this._seasonalTimeSeriesIdentifier = null;
        } else {
            this._constantValue = null;
            this._locationLevelRef.setPrototypeLevel(null);
        }
    }

    @Override
    public String toString() {
        if (this._locationLevelRef == null) {
            return "";
        }
        return this._locationLevelRef.toString();
    }

    @Override
    @EntityBeanMap(attributeName="OfficeId")
    public String getOfficeId() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getOfficeId();
    }

    public void setOfficeId(String officeId) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setOfficeId(officeId);
    }

    @EntityBeanMap(attributeName="LocationId")
    public String getLocationId() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getLocationId();
    }

    public void setLocationId(String locationId) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setLocationId(locationId);
    }

    private IAttributeParameterTypedValue getAttribute() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getAttribute();
    }

    @EntityBeanMap(attributeName="AttributeComment")
    public String getAttributeComment() {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null) {
            return null;
        }
        return attribute.getComment();
    }

    public void setAttributeComment(String attributeComment) {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null && (attributeComment == null || attributeComment.isEmpty())) {
            return;
        }
        if (attribute == null) {
            attribute = new JDomAttributeParameterTypedValue();
        }
        attribute.setComment(attributeComment);
    }

    @EntityBeanMap(attributeName="AttributeDurationId")
    public String getAttributeDurationId() {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null) {
            return null;
        }
        Duration duration = attribute.getDuration();
        if (duration == null) {
            return null;
        }
        return duration.toString();
    }

    public void setAttributeDurationId(String attributeDurationId) throws DataSetIllegalArgumentException {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null && (attributeDurationId == null || attributeDurationId.isEmpty())) {
            return;
        }
        if (attribute == null) {
            attribute = new JDomAttributeParameterTypedValue();
        }
        if (attributeDurationId != null) {
            attribute.setDuration(new Duration(attributeDurationId));
        } else {
            attribute.setDuration(null);
        }
    }

    @EntityBeanMap(attributeName="AttributeParameterId")
    public String getAttributeParameterId() {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null) {
            return null;
        }
        Parameter parameter = attribute.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.toString();
    }

    public void setAttributeParameterId(String attributeParameterId) throws DataSetIllegalArgumentException {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null && (attributeParameterId == null || attributeParameterId.isEmpty())) {
            return;
        }
        if (attribute == null) {
            attribute = new JDomAttributeParameterTypedValue();
        }
        if (attributeParameterId != null) {
            attribute.setParameter(new Parameter(attributeParameterId));
        } else {
            attribute.setParameter(null);
        }
    }

    @EntityBeanMap(attributeName="AttributeParameterTypeId")
    public String getAttributeParameterTypeId() {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null) {
            return null;
        }
        ParameterType parameterType = attribute.getParameterType();
        if (parameterType == null) {
            return null;
        }
        return parameterType.toString();
    }

    public void setAttributeParameterTypeId(String attributeParameterTypeId) throws DataSetIllegalArgumentException {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null && (attributeParameterTypeId == null || attributeParameterTypeId.isEmpty())) {
            return;
        }
        if (attribute == null) {
            attribute = new JDomAttributeParameterTypedValue();
        }
        if (attributeParameterTypeId != null) {
            attribute.setParameterType(new ParameterType(attributeParameterTypeId));
        } else {
            attribute.setParameterType(null);
        }
    }

    @EntityBeanMap(attributeName="AttributeUnitsId")
    public String getAttributeUnitsId() {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null) {
            return null;
        }
        return attribute.getUnits();
    }

    public void setAttributeUnitsId(String attributeUnitsId) {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null && (attributeUnitsId == null || attributeUnitsId.isEmpty())) {
            return;
        }
        if (attribute == null) {
            attribute = new JDomAttributeParameterTypedValue();
        }
        attribute.setUnits(attributeUnitsId);
    }

    @EntityBeanMap(attributeName="AttributeValue")
    public BigDecimal getAttributeValue() {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null) {
            return null;
        }
        return attribute.getValueBigDecimal();
    }

    public void setAttributeValue(BigDecimal attributeValue) {
        IAttributeParameterTypedValue attribute = this.getAttribute();
        if (attribute == null && attributeValue == null) {
            return;
        }
        if (attribute == null) {
            attribute = new JDomAttributeParameterTypedValue();
        }
        attribute.setValue(attributeValue.toPlainString());
    }

    @EntityBeanMap(attributeName="DurationId")
    public String getDurationId() {
        if (this._locationLevelRef == null) {
            return null;
        }
        Duration duration = this._locationLevelRef.getDuration();
        if (duration == null) {
            return null;
        }
        return duration.toString();
    }

    public void setDurationId(String durationId) throws DataSetIllegalArgumentException {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setDurationId(durationId);
        if (this._constantValue == null && (durationId == null || durationId.isEmpty())) {
            return;
        }
        if (this._constantValue == null) {
            this._constantValue = new JDomParameterTypedValueImpl();
        }
        if (durationId != null) {
            this._constantValue.setDuration(new Duration(durationId));
        } else {
            this._constantValue.setDuration(null);
        }
    }

    public Object getIndicators() {
        return null;
    }

    public void setIndicators(Object indicators) {
    }

    @EntityBeanMap(attributeName="Interpolate")
    public String getInterpolateString() {
        if (this._interpolateSeasonal == null) {
            return null;
        }
        return this._interpolateSeasonal != false ? "T" : "F";
    }

    public void setInterpolateString(String interpolate) {
        this._interpolateSeasonal = interpolate != null ? (interpolate.toUpperCase().equals("T") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : null;
    }

    @EntityBeanMap(attributeName="IntervalMinutes")
    public int getIntervalMinutes() {
        if (this._seasonalValues == null) {
            return Integer.MIN_VALUE;
        }
        ISeasonalInterval offset = this._seasonalValues.getOffset();
        if (offset == null) {
            return Integer.MIN_VALUE;
        }
        if (offset.intervalHasCalendarParts()) {
            return Integer.MIN_VALUE;
        }
        return offset.getTotalMinutes();
    }

    public void setIntervalMinutes(int intervalMinutes) {
        if (this._seasonalValues == null && !RMAConst.isValidValue(intervalMinutes)) {
            return;
        }
        if (this._seasonalValues == null) {
            this._seasonalValues = new JDomSeasonalValuesImpl();
        }
        JDomSeasonalIntervalImpl jDomIntervalImpl = new JDomSeasonalIntervalImpl();
        if (RMAConst.isValidValue(intervalMinutes)) {
            jDomIntervalImpl.setTotalMinutes(intervalMinutes);
        }
        this._seasonalValues.setOffset(jDomIntervalImpl);
    }

    @EntityBeanMap(attributeName="IntervalMonths")
    public int getIntervalMonths() {
        if (this._seasonalValues == null) {
            return Integer.MIN_VALUE;
        }
        ISeasonalInterval offset = this._seasonalValues.getOffset();
        if (offset == null) {
            return Integer.MIN_VALUE;
        }
        if (offset.intervalHasTimeParts()) {
            return Integer.MIN_VALUE;
        }
        return offset.getTotalMonths();
    }

    public void setIntervalMonths(int intervalMonths) {
        if (this._seasonalValues == null && !RMAConst.isValidValue(intervalMonths)) {
            return;
        }
        if (this._seasonalValues == null) {
            this._seasonalValues = new JDomSeasonalValuesImpl();
        }
        JDomSeasonalIntervalImpl jDomIntervalImpl = new JDomSeasonalIntervalImpl();
        if (RMAConst.isValidValue(intervalMonths)) {
            jDomIntervalImpl.setTotalMonths(intervalMonths);
        }
        this._seasonalValues.setOffset(jDomIntervalImpl);
    }

    @EntityBeanMap(attributeName="IntervalOrigin")
    public Date getIntervalOrigin() {
        if (this._seasonalValues == null) {
            return null;
        }
        return this._seasonalValues.getOrigin();
    }

    public void setIntervalOrigin(Date intervalOrigin) {
        if (this._seasonalValues == null && intervalOrigin == null) {
            return;
        }
        if (this._seasonalValues == null) {
            this._seasonalValues = new JDomSeasonalValuesImpl();
        }
        this._seasonalValues.setOrigin(intervalOrigin);
    }

    @Override
    @EntityBeanMap(attributeName="LevelComment")
    public String getLevelComment() {
        return this._levelComment;
    }

    @Override
    public void setLevelComment(String levelComment) {
        this._levelComment = levelComment;
    }

    @EntityBeanMap(attributeName="LevelDate")
    public Date getLevelDate() {
        return this._effectiveDate;
    }

    public void setLevelDate(Date levelDate) {
        this._effectiveDate = levelDate;
    }

    @EntityBeanMap(attributeName="LevelUnitsId")
    public String getLevelUnitsId() {
        return this._levelUnits;
    }

    public void setLevelUnitsId(String levelUnitsId) {
        this._levelUnits = levelUnitsId;
    }

    @EntityBeanMap(attributeName="LevelValue")
    public double getSiParameterUnitsConstantValue() {
        if (this._constantValue == null || this._constantValue.getSiParameterUnitsValue() == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._constantValue.getSiParameterUnitsValue();
    }

    public void setSiParameterUnitsConstantValue(double levelValue) {
        if (this._constantValue == null && !RMAConst.isValidValue(levelValue)) {
            return;
        }
        if (this._constantValue == null) {
            this._constantValue = new JDomParameterTypedValueImpl();
        }
        this._constantValue.setSiParameterUnitsValue(levelValue);
    }

    @EntityBeanMap(attributeName="ParameterId")
    public String getParameterId() {
        if (this._locationLevelRef == null) {
            return null;
        }
        Parameter parameter = this._locationLevelRef.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.toString();
    }

    public void setParameterId(String parameterId) throws DataSetIllegalArgumentException {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setParameterId(parameterId);
        if (this._constantValue == null && (parameterId == null || parameterId.isEmpty())) {
            return;
        }
        if (this._constantValue == null) {
            this._constantValue = new JDomParameterTypedValueImpl();
        }
        Parameter parameter = parameterId != null ? new Parameter(parameterId) : null;
        this._constantValue.setParameter(parameter);
    }

    @EntityBeanMap(attributeName="ParameterTypeId")
    public String getParameterTypeId() {
        if (this._locationLevelRef == null) {
            return null;
        }
        ParameterType parameterType = this._locationLevelRef.getParameterType();
        if (parameterType == null) {
            return null;
        }
        return parameterType.toString();
    }

    public void setParameterTypeId(String parameterTypeId) throws DataSetIllegalArgumentException {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setParameterTypeId(parameterTypeId);
        if (this._constantValue == null && (parameterTypeId == null || parameterTypeId.isEmpty())) {
            return;
        }
        if (this._constantValue == null) {
            this._constantValue = new JDomParameterTypedValueImpl();
        }
        ParameterType parameterType = parameterTypeId != null ? new ParameterType(parameterTypeId) : null;
        this._constantValue.setParameterType(parameterType);
    }

    public JDomSeasonalValuesImpl getSeasonalValuesObject() {
        return this._seasonalValues;
    }

    @Override
    public void setSeasonalValues(ISeasonalValues seasonalValues) {
        JDomSeasonalValuesImpl jDomSeasonalValuesImpl = seasonalValues instanceof JDomSeasonalValuesImpl ? (JDomSeasonalValuesImpl)seasonalValues : new JDomSeasonalValuesImpl(seasonalValues);
        this.setSeasonalValuesObject(jDomSeasonalValuesImpl);
    }

    public void setSeasonalValuesObject(JDomSeasonalValuesImpl seasonalValues) {
        this._seasonalValues = seasonalValues;
        if (seasonalValues != null) {
            this._constantValue = null;
            this._seasonalTimeSeriesIdentifier = null;
        }
    }

    @EntityBeanMap(attributeName="SpecifiedLevelId")
    public String getSpecifiedLevelId() {
        if (this._locationLevelRef == null) {
            return null;
        }
        ISpecifiedLevel iSpecifiedLevel = this._locationLevelRef.getSpecifiedLevel();
        return iSpecifiedLevel.getId();
    }

    public void setSpecifiedLevelId(String specifiedLevelId) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setSpecifiedLevelId(specifiedLevelId);
    }

    @Override
    @EntityBeanMap(attributeName="Tsid")
    public String getSeasonalTimeSeriesId() {
        return this._seasonalTimeSeriesIdentifier;
    }

    @Override
    public void setSeasonalTimeSeriesId(String timeSeriesId) {
        this._seasonalTimeSeriesIdentifier = timeSeriesId;
        if (timeSeriesId != null) {
            this._constantValue = null;
            this._seasonalValues = null;
        }
    }

    @Override
    public boolean isSeasonalRepeating() {
        return this._seasonalValues != null;
    }

    @Override
    public boolean isSeasonalTimeSeries() {
        return this._seasonalTimeSeriesIdentifier != null;
    }

    @Override
    public boolean isConstantValue() {
        return this._constantValue != null;
    }

    @Override
    public Parameter getParameter() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getParameter();
    }

    @Override
    public void setParameter(Parameter parameter) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setParameter(parameter);
    }

    @Override
    public ParameterType getParameterType() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getParameterType();
    }

    @Override
    public void setParameterType(ParameterType parameterType) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setParameterType(parameterType);
    }

    @Override
    public Duration getDuration() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getDuration();
    }

    @Override
    public void setDuration(Duration duration) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setDuration(duration);
    }

    @Override
    public IParameterTypedValue getPrototypeLevel() {
        if (this._locationLevelRef == null) {
            return null;
        }
        return this._locationLevelRef.getPrototypeLevel();
    }

    @Override
    public void setPrototypeLevel(IParameterTypedValue level) {
        if (this._locationLevelRef == null) {
            this._locationLevelRef = new JDomLocationLevelRef();
        }
        this._locationLevelRef.setPrototypeLevel(level);
    }

    @Override
    public void clearSeasonalValues() {
        this._seasonalValues = null;
    }

    @Override
    public void setSeasonalStartDate(Date date) {
        this._seasonalStartDate = date;
    }

    @Override
    public void setSeasonalEndDate(Date date) {
        this._seasonalEndDate = date;
    }

    @Override
    public Date getSeasonalStartDate() {
        return this._seasonalStartDate;
    }

    @Override
    public Date getSeasonalEndDate() {
        return this._seasonalEndDate;
    }

    @Override
    public Boolean getInterpolateSeasonal() {
        return this._interpolateSeasonal;
    }

    @Override
    public void setInterpolateSeasonal(Boolean interpolate) {
        this._interpolateSeasonal = interpolate;
    }

    @Override
    public String getUnits() {
        return this._levelUnits;
    }

    @Override
    public void setUnits(String units) {
        this._levelUnits = units;
    }
}

