/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.AbstractJDomDataObject;
import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.DbOfficeId;
import hec.data.Duration;
import hec.data.JDomDataObjectFactory;
import hec.data.Parameter;
import hec.data.ParameterType;
import hec.data.level.IAttributeParameterTypedValue;
import hec.data.level.ILocationLevelRef;
import hec.data.level.IParameterTypedValue;
import hec.data.level.ISpecifiedLevel;
import hec.data.level.JDomAttributeParameterTypedValue;
import hec.data.level.JDomParameterTypedValueImpl;
import hec.data.level.JDomSpecifiedLevelImpl;
import hec.data.location.LocationTemplate;
import hec.util.XMLUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;

public class JDomLocationLevelRef
extends AbstractJDomDataObject
implements ILocationLevelRef {
    public static final String DELIM = ".";
    private JDomSpecifiedLevelImpl _specifiedLevel;
    private LocationTemplate _locRef;
    private JDomParameterTypedValueImpl _parameterTypedValue;
    private JDomAttributeParameterTypedValue _attribute = null;
    public final String levelIdParsingRegexp = "([^\\.]*)\\.([^\\.]*)\\.([^\\.]*)\\.([^\\.]*)\\.([^\\.\\;]*)";
    public final Pattern levelIdParsingPattern = Pattern.compile("([^\\.]*)\\.([^\\.]*)\\.([^\\.]*)\\.([^\\.]*)\\.([^\\.\\;]*)");
    public final String attributeIdParsingRegexp = "(.*)\\.(.*)\\.(.*)";
    public final Pattern attributeIdParsingPattern = Pattern.compile("(.*)\\.(.*)\\.(.*)");
    public final String fullLevelAttributeParsingRegexp = "(([^.]+)\\.([^.]+)\\.([^.]+)\\.([^.]+)\\.([^.;]+))(;(([^.]+)\\.([^.]+)\\.([^.]+)\\.([-]?\\d+(?:[,]\\d+)*(?:[.]\\d*)?)),(.*))?";
    public final Pattern fullLevelAttributeParsingPattern = Pattern.compile("(([^.]+)\\.([^.]+)\\.([^.]+)\\.([^.]+)\\.([^.;]+))(;(([^.]+)\\.([^.]+)\\.([^.]+)\\.([-]?\\d+(?:[,]\\d+)*(?:[.]\\d*)?)),(.*))?");

    public JDomLocationLevelRef() {
    }

    public JDomLocationLevelRef(Element element) {
        if (element == null) {
            return;
        }
        Element child = element.getChild("specified_level");
        if (child != null) {
            this._specifiedLevel = new JDomSpecifiedLevelImpl(child);
        }
        if ((child = element.getChild("loc_ref")) != null) {
            this._locRef = LocationTemplate.parse(child);
        }
        if ((child = element.getChild("parameter")) != null) {
            try {
                String param = child.getAttributeValue("id");
                if (this._parameterTypedValue == null) {
                    this._parameterTypedValue = new JDomParameterTypedValueImpl();
                }
                this._parameterTypedValue.setParameter(new Parameter(param));
            }
            catch (DataSetIllegalArgumentException ex) {
                Logger.getLogger(JDomLocationLevelRef.class.getName()).log(Level.FINE, null, ex);
            }
        }
        if ((child = element.getChild("parameter_type")) != null) {
            try {
                String paramType = child.getAttributeValue("id");
                if (this._parameterTypedValue == null) {
                    this._parameterTypedValue = new JDomParameterTypedValueImpl();
                }
                this._parameterTypedValue.setParameterType(new ParameterType(paramType));
            }
            catch (DataSetIllegalArgumentException ex) {
                Logger.getLogger(JDomLocationLevelRef.class.getName()).log(Level.FINE, null, ex);
            }
        }
        if ((child = element.getChild("duration")) != null) {
            try {
                String duration = child.getAttributeValue("id");
                if (this._parameterTypedValue == null) {
                    this._parameterTypedValue = new JDomParameterTypedValueImpl();
                }
                this._parameterTypedValue.setDuration(new Duration(duration));
            }
            catch (DataSetIllegalArgumentException ex) {
                Logger.getLogger(JDomLocationLevelRef.class.getName()).log(Level.FINE, null, ex);
            }
        }
        if ((child = element.getChild("attribute")) != null) {
            JDomAttributeParameterTypedValue attribute = new JDomAttributeParameterTypedValue(child);
            this.setAttribute(attribute);
        }
    }

    public JDomLocationLevelRef(ILocationLevelRef iLocationLevelRef) {
        this(JDomDataObjectFactory.getRootElement(iLocationLevelRef.toXmlString()));
    }

    public JDomLocationLevelRef(String officeId, String completeLocLevelIdWithAttribute) throws DataSetException {
        Matcher matcher = this.levelIdParsingPattern.matcher(completeLocLevelIdWithAttribute);
        if (!matcher.matches() || matcher.groupCount() < 5) {
            throw new DataSetException("Illegal location level identifier: " + completeLocLevelIdWithAttribute);
        }
        String s0 = matcher.group(0);
        String loc = matcher.group(1);
        String sparameter = matcher.group(2);
        String sparameterType = matcher.group(3);
        String sduration = matcher.group(4);
        String specLevelId = matcher.group(5);
        if (loc == null || loc.isEmpty() || sparameter == null || sparameter.isEmpty() || sparameterType == null || sparameterType.isEmpty() || sduration == null || sduration.isEmpty() || specLevelId == null || specLevelId.isEmpty()) {
            throw new DataSetException("Illegal location level identifier: " + completeLocLevelIdWithAttribute);
        }
        this.setLocationRef(new LocationTemplate(officeId, loc));
        Parameter parameter = new Parameter(sparameter);
        ParameterType parameterType = new ParameterType(sparameterType);
        Duration duration = new Duration(sduration);
        this.setPrototypeLevel(new JDomParameterTypedValueImpl(parameter, parameterType, duration));
        this.setSpecifiedLevel(new JDomSpecifiedLevelImpl(new DbOfficeId(officeId), specLevelId));
        if (matcher.groupCount() == 13) {
            String sattrParam = matcher.group(8);
            String sattrParamType = matcher.group(9);
            String sattrDuration = matcher.group(10);
            String attributeValue = matcher.group(11);
            String attributeUnits = matcher.group(12);
            Parameter attrParameter = new Parameter(sattrParam);
            ParameterType attrParameterType = new ParameterType(sattrParamType);
            Duration attrDuration = new Duration(sattrDuration);
            this._attribute = new JDomAttributeParameterTypedValue(attrParameter, attrParameterType, attrDuration, attributeValue, attributeUnits);
        }
    }

    public JDomLocationLevelRef(String officeId, String locLevelId, String attributeId, String attributeValue, String attributeUnits) throws DataSetException {
        Matcher matcher = this.levelIdParsingPattern.matcher(locLevelId);
        if (!matcher.matches() || matcher.groupCount() != 5) {
            throw new DataSetException("Illegal location level identifier: " + locLevelId);
        }
        String loc = matcher.group(1);
        this.setLocationRef(new LocationTemplate(officeId, loc));
        String sparameter = matcher.group(2);
        String sparameterType = matcher.group(3);
        String sduration = matcher.group(4);
        Parameter parameter = new Parameter(sparameter);
        ParameterType parameterType = new ParameterType(sparameterType);
        Duration duration = new Duration(sduration);
        this.setPrototypeLevel(new JDomParameterTypedValueImpl(parameter, parameterType, duration));
        String specLevelId = matcher.group(5);
        this.setSpecifiedLevel(new JDomSpecifiedLevelImpl(new DbOfficeId(officeId), specLevelId));
        if (attributeId != null && attributeValue != null && attributeUnits != null) {
            matcher = this.attributeIdParsingPattern.matcher(attributeId);
            if (!matcher.matches() || matcher.groupCount() != 3) {
                throw new DataSetException("Illegal location level attribute identifier: " + attributeId);
            }
            String sattrParam = matcher.group(1);
            String sattrParamType = matcher.group(2);
            String sattrDuration = matcher.group(3);
            Parameter attrParameter = new Parameter(sattrParam);
            ParameterType attrParameterType = new ParameterType(sattrParamType);
            Duration attrDuration = new Duration(sattrDuration);
            this._attribute = new JDomAttributeParameterTypedValue(attrParameter, attrParameterType, attrDuration, attributeValue, attributeUnits);
        }
    }

    @Override
    public void buildElement(Element element) {
        Element child;
        if (element == null) {
            return;
        }
        if (this._specifiedLevel != null) {
            child = XMLUtilities.getOrCreateChild(element, "specified_level");
            this._specifiedLevel.buildElement(child);
        } else {
            element.removeChild("specified_level");
        }
        if (this._locRef != null) {
            child = XMLUtilities.getOrCreateChild(element, "loc_ref");
            this._locRef.buildElement(child);
        } else {
            element.removeChild("loc_ref");
        }
        if (this._parameterTypedValue != null && this._parameterTypedValue.getParameter() != null) {
            child = XMLUtilities.getOrCreateChild(element, "parameter");
            child.setAttribute("id", this._parameterTypedValue.getParameter().getParameter());
        } else {
            element.removeChild("parameter");
        }
        if (this._parameterTypedValue != null && this._parameterTypedValue.getParameterType() != null) {
            child = XMLUtilities.getOrCreateChild(element, "parameter_type");
            child.setAttribute("id", this._parameterTypedValue.getParameterType().getParameterType());
        }
        if (this._parameterTypedValue != null && this._parameterTypedValue.getDuration() != null) {
            child = XMLUtilities.getOrCreateChild(element, "duration");
            child.setAttribute("id", this._parameterTypedValue.getDuration().toString());
        } else {
            element.removeChild("duration");
        }
        if (this.getAttributeObject() != null) {
            child = XMLUtilities.getOrCreateChild(element, "attribute");
            this.getAttributeObject().buildElement(child);
        } else {
            element.removeChild("attribute");
        }
    }

    @Override
    public final void setSpecifiedLevel(ISpecifiedLevel level) {
        if (level != null) {
            this._specifiedLevel = level instanceof JDomSpecifiedLevelImpl ? (JDomSpecifiedLevelImpl)level : new JDomSpecifiedLevelImpl(level);
        }
    }

    @Override
    public ISpecifiedLevel getSpecifiedLevel() {
        return this._specifiedLevel;
    }

    @Override
    public LocationTemplate getLocationRef() {
        return this._locRef;
    }

    @Override
    public final void setLocationRef(LocationTemplate locRef) {
        this._locRef = locRef;
    }

    @Override
    public Parameter getParameter() {
        if (this._parameterTypedValue == null) {
            return null;
        }
        return this._parameterTypedValue.getParameter();
    }

    @Override
    public void setParameter(Parameter parameter) {
        if (this._parameterTypedValue == null) {
            this._parameterTypedValue = new JDomParameterTypedValueImpl();
        }
        this._parameterTypedValue.setParameter(parameter);
    }

    @Override
    public ParameterType getParameterType() {
        if (this._parameterTypedValue == null) {
            return null;
        }
        return this._parameterTypedValue.getParameterType();
    }

    @Override
    public void setParameterType(ParameterType parameterType) {
        if (this._parameterTypedValue == null) {
            this._parameterTypedValue = new JDomParameterTypedValueImpl();
        }
        this._parameterTypedValue.setParameterType(parameterType);
    }

    @Override
    public Duration getDuration() {
        if (this._parameterTypedValue == null) {
            return null;
        }
        return this._parameterTypedValue.getDuration();
    }

    @Override
    public void setDuration(Duration duration) {
        if (this._parameterTypedValue == null) {
            this._parameterTypedValue = new JDomParameterTypedValueImpl();
        }
        this._parameterTypedValue.setDuration(duration);
    }

    @Override
    public IParameterTypedValue getPrototypeLevel() {
        return this._parameterTypedValue;
    }

    @Override
    public final void setPrototypeLevel(IParameterTypedValue prototypeParameterTypedValue) {
        if (prototypeParameterTypedValue != null) {
            this._parameterTypedValue = prototypeParameterTypedValue instanceof JDomParameterTypedValueImpl ? (JDomParameterTypedValueImpl)prototypeParameterTypedValue : new JDomParameterTypedValueImpl(prototypeParameterTypedValue);
        }
    }

    JDomSpecifiedLevelImpl getSpecifiedLevelObject() {
        return this._specifiedLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._locRef == null ? 0 : this._locRef.hashCode());
        result = 31 * result + (this._specifiedLevel == null ? 0 : this._specifiedLevel.hashCode());
        result = 31 * result + (this._parameterTypedValue == null || this._parameterTypedValue.getParameter() == null ? 0 : this._parameterTypedValue.getParameter().toString().hashCode());
        result = 31 * result + (this._parameterTypedValue == null || this._parameterTypedValue.getParameterType() == null ? 0 : this._parameterTypedValue.getParameterType().toString().hashCode());
        result = 31 * result + (this._parameterTypedValue == null || this._parameterTypedValue.getDuration() == null ? 0 : this._parameterTypedValue.getDuration().toString().hashCode());
        result = 31 * result + (this._attribute == null || this._attribute.getParameter() == null ? 0 : this._attribute.getParameter().toString().hashCode());
        result = 31 * result + (this._attribute == null || this._attribute.getParameterType() == null ? 0 : this._attribute.getParameterType().toString().hashCode());
        result = 31 * result + (this._attribute == null || this._attribute.getDuration() == null ? 0 : this._attribute.getDuration().toString().hashCode());
        result = 31 * result + (this._attribute == null || this._attribute.getValue() == null ? 0 : this._attribute.getValue().hashCode());
        result = 31 * result + (this._attribute == null || this._attribute.getUnits() == null ? 0 : this._attribute.getUnits().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomLocationLevelRef other = (JDomLocationLevelRef)obj;
        if (this._locRef == null ? other._locRef != null : !this._locRef.equals((Object)other._locRef)) {
            return false;
        }
        if (this._specifiedLevel == null ? other._specifiedLevel != null : !this._specifiedLevel.equals(other._specifiedLevel)) {
            return false;
        }
        if (this._parameterTypedValue == null) {
            if (other._parameterTypedValue != null) {
                return false;
            }
        } else {
            Parameter parameter = this._parameterTypedValue.getParameter();
            ParameterType parameterType = this._parameterTypedValue.getParameterType();
            Duration duration = this._parameterTypedValue.getDuration();
            Parameter otherParameter = other._parameterTypedValue.getParameter();
            ParameterType otherParameterType = other._parameterTypedValue.getParameterType();
            Duration otherDuration = other._parameterTypedValue.getDuration();
            if (parameter == null) {
                if (otherParameter != null) {
                    return false;
                }
            } else {
                if (otherParameter == null) {
                    return false;
                }
                if (!parameter.toString().equals(otherParameter.toString())) {
                    return false;
                }
            }
            if (parameterType == null) {
                if (otherParameterType != null) {
                    return false;
                }
            } else {
                if (otherParameterType == null) {
                    return false;
                }
                if (!parameterType.toString().equals(otherParameterType.toString())) {
                    return false;
                }
            }
            if (duration == null) {
                if (otherDuration != null) {
                    return false;
                }
            } else {
                if (otherDuration == null) {
                    return false;
                }
                if (!duration.toString().equals(otherDuration.toString())) {
                    return false;
                }
            }
        }
        if (this._attribute == null) {
            if (other._attribute != null) {
                return false;
            }
        } else {
            Parameter attrParam = this._attribute.getParameter();
            ParameterType attrParameterType = this._attribute.getParameterType();
            Duration attrDuuration = this._attribute.getDuration();
            Parameter otherAttrParameter = other._attribute.getParameter();
            ParameterType otherAttrParameterType = other._attribute.getParameterType();
            Duration otherAttrDuration = other._attribute.getDuration();
            String attrValue = this._attribute.getValue();
            String otherValue = other._attribute.getValue();
            String attrUnits = this._attribute.getUnits();
            String otherUnits = other._attribute.getUnits();
            if (attrParam == null ? otherAttrParameter != null : !attrParam.toString().equals(otherAttrParameter.toString())) {
                return false;
            }
            if (attrParameterType == null ? otherAttrParameterType != null : !attrParameterType.toString().equals(otherAttrParameterType.toString())) {
                return false;
            }
            if (attrDuuration == null ? otherAttrDuration != null : !attrDuuration.toString().equals(otherAttrDuration.toString())) {
                return false;
            }
            if (attrValue == null ? otherValue != null : !attrValue.equals(otherValue)) {
                return false;
            }
            if (attrUnits == null ? otherUnits != null : !attrUnits.equals(otherUnits)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getLocationLevelId();
    }

    @Override
    public String getLocationLevelId() {
        StringBuilder sb = new StringBuilder();
        if (this._locRef != null && this._parameterTypedValue != null && this._parameterTypedValue.getParameter() != null && this._parameterTypedValue.getParameterType() != null && this._parameterTypedValue.getDuration() != null && this._specifiedLevel != null) {
            sb.append(this._locRef.getLocationId()).append(DELIM).append(this._parameterTypedValue.toString()).append(DELIM).append(this._specifiedLevel.toString());
        }
        return sb.toString();
    }

    @Override
    public String getLocationLevelAttributeValueUnitsId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLocationLevelId());
        if (this._attribute != null) {
            Parameter attrParam = this._attribute.getParameter();
            ParameterType attrParamType = this._attribute.getParameterType();
            Duration attrDuration = this._attribute.getDuration();
            String attrValue = this._attribute.getValue();
            String attrUnits = this._attribute.getUnits();
            if (attrParam != null && attrParamType != null && attrDuration != null && attrValue != null && attrUnits != null) {
                sb.append(";").append(attrParam.toString()).append(DELIM).append(attrParamType.toString()).append(DELIM).append(attrDuration.toString()).append(DELIM).append(attrValue.toString()).append(",").append(attrUnits);
            }
        }
        return sb.toString();
    }

    @Override
    public String getOfficeId() {
        if (this._locRef == null) {
            return null;
        }
        return this._locRef.getOfficeId();
    }

    public void setOfficeId(String officeId) {
        if (this._locRef == null && (officeId == null || officeId.isEmpty())) {
            return;
        }
        if (this._locRef == null) {
            this._locRef = new LocationTemplate();
        }
        this._locRef.setOfficeId(officeId);
        if (this._specifiedLevel != null && this._specifiedLevel.getOfficeId() == null) {
            this._specifiedLevel.setOfficeId(officeId);
        }
    }

    public String getLocationId() {
        if (this._locRef == null) {
            return null;
        }
        return this._locRef.getLocationId();
    }

    public void setLocationId(String locationId) {
        if (this._locRef == null && (locationId == null || locationId.isEmpty())) {
            return;
        }
        if (this._locRef == null) {
            this._locRef = new LocationTemplate();
        }
        this._locRef.setLocationId(locationId);
    }

    public void setDurationId(String durationId) throws DataSetIllegalArgumentException {
        if (this._parameterTypedValue == null && (durationId == null || durationId.isEmpty())) {
            return;
        }
        if (this._parameterTypedValue == null) {
            this._parameterTypedValue = new JDomParameterTypedValueImpl();
        }
        if (durationId != null) {
            this._parameterTypedValue.setDuration(new Duration(durationId));
        } else {
            this._parameterTypedValue.setDuration(null);
        }
    }

    public void setParameterId(String parameterId) throws DataSetIllegalArgumentException {
        if (this._parameterTypedValue == null && (parameterId == null || parameterId.isEmpty())) {
            return;
        }
        if (this._parameterTypedValue == null) {
            this._parameterTypedValue = new JDomParameterTypedValueImpl();
        }
        Parameter parameter = parameterId != null ? new Parameter(parameterId) : null;
        this._parameterTypedValue.setParameter(parameter);
    }

    public void setParameterTypeId(String parameterTypeId) throws DataSetIllegalArgumentException {
        if (this._parameterTypedValue == null && (parameterTypeId == null || parameterTypeId.isEmpty())) {
            return;
        }
        if (this._parameterTypedValue == null) {
            this._parameterTypedValue = new JDomParameterTypedValueImpl();
        }
        ParameterType parameterType = parameterTypeId != null ? new ParameterType(parameterTypeId) : null;
        this._parameterTypedValue.setParameterType(parameterType);
    }

    public void setSpecifiedLevelId(String specifiedLevelId) {
        if (this._specifiedLevel == null && (specifiedLevelId == null || specifiedLevelId.isEmpty())) {
            return;
        }
        if (this._specifiedLevel == null) {
            this._specifiedLevel = new JDomSpecifiedLevelImpl();
            if (this._locRef != null) {
                this._specifiedLevel.setOfficeId(this._locRef.getOfficeId());
            }
        }
        this._specifiedLevel.setId(specifiedLevelId);
    }

    @Override
    public IAttributeParameterTypedValue getAttribute() {
        return this._attribute;
    }

    @Override
    public void setAttribute(IAttributeParameterTypedValue attribute) {
        this._attribute = attribute instanceof JDomAttributeParameterTypedValue ? (JDomAttributeParameterTypedValue)attribute : (attribute != null ? new JDomAttributeParameterTypedValue(attribute) : null);
    }

    JDomAttributeParameterTypedValue getAttributeObject() {
        return this._attribute;
    }
}

