/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.AbstractJDomDataObject;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Duration;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.ParameterType;
import hec.data.level.IParameterTypedValue;
import hec.util.XMLUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class JDomParameterTypedValueImpl
extends AbstractJDomDataObject
implements IParameterTypedValue {
    public static final String DELIM = ".";
    private Double _value = null;
    private Parameter _parameter;
    private ParameterType _parameterType;
    private Duration _duration;
    private String _xmlUnit = null;

    public JDomParameterTypedValueImpl() {
    }

    public JDomParameterTypedValueImpl(Parameter parameter, ParameterType parameterType, Duration duration) {
        this._parameter = parameter;
        this._parameterType = parameterType;
        this._duration = duration;
    }

    public JDomParameterTypedValueImpl(Element element) {
        if (element != null) {
            Element child = element.getChild("parameter");
            if (child != null) {
                try {
                    this._parameter = new Parameter(child.getAttributeValue("id"));
                }
                catch (DataSetIllegalArgumentException ex) {
                    Logger.getLogger(JDomParameterTypedValueImpl.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            if ((child = element.getChild("parameter_type")) != null) {
                try {
                    this._parameterType = new ParameterType(child.getAttributeValue("id"));
                }
                catch (DataSetIllegalArgumentException ex) {
                    Logger.getLogger(JDomParameterTypedValueImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if ((child = element.getChild("duration")) != null) {
                try {
                    this._duration = new Duration(child.getAttributeValue("id"));
                }
                catch (DataSetIllegalArgumentException ex) {
                    Logger.getLogger(JDomParameterTypedValueImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if ((child = element.getChild("value")) != null) {
                if (this._parameter != null) {
                    ParamDouble paramDouble = new ParamDouble();
                    this._value = JDomParameterTypedValueImpl.getXmlValue(paramDouble, element, "value", this._parameter.getParameterId());
                } else {
                    this._value = XMLUtilities.getContentAsDouble(child, Double.NEGATIVE_INFINITY);
                    this._xmlUnit = child.getAttributeValue("unit");
                }
            }
            this.setComment(element.getChildText("comment"));
        }
    }

    public JDomParameterTypedValueImpl(IParameterTypedValue value) {
        this(JDomDataObjectFactory.getRootElement(value.toXmlString()));
    }

    @Override
    public void buildElement(Element element) {
        this.buildElement(element, true);
    }

    @Override
    public Double getSiParameterUnitsValue() {
        return this._value;
    }

    @Override
    public Parameter getParameter() {
        return this._parameter;
    }

    @Override
    public ParameterType getParameterType() {
        return this._parameterType;
    }

    @Override
    public Duration getDuration() {
        return this._duration;
    }

    @Override
    public String getComment() {
        return this.getDescription();
    }

    @Override
    public void setValue(ParamDouble paramDouble) {
        this._value = paramDouble.convertToUnitSystem(2);
    }

    @Override
    public void getValue(ParamDouble paramDouble) {
        if (this._parameter != null) {
            paramDouble.setParameterId(this._parameter.getParameterId());
        }
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._value);
    }

    @Override
    public void setSiParameterUnitsValue(Double val) {
        this._value = val;
    }

    @Override
    public void setParameter(Parameter param) {
        this._parameter = param;
    }

    @Override
    public void setParameterType(ParameterType type) {
        this._parameterType = type;
    }

    @Override
    public void setDuration(Duration duration) {
        this._duration = duration;
    }

    @Override
    public void setComment(String comment) {
        this.setDescription(comment);
    }

    void buildElement(Element element, boolean fullDescription) {
        if (element != null) {
            if (fullDescription) {
                Element child = XMLUtilities.getOrCreateChild(element, "parameter");
                if (this._parameter != null) {
                    child.setAttribute("id", this._parameter.toString());
                } else {
                    child.removeContent();
                }
                child = XMLUtilities.getOrCreateChild(element, "parameter_type");
                if (this._parameterType != null) {
                    child.setAttribute("id", this._parameterType.toString());
                } else {
                    child.removeContent();
                }
                child = XMLUtilities.getOrCreateChild(element, "duration");
                if (this._duration != null) {
                    child.setAttribute("id", this._duration.toString());
                } else {
                    child.removeContent();
                }
                child = XMLUtilities.getOrCreateChild(element, "comment");
                String comment = this.getComment();
                if (comment != null && !comment.isEmpty()) {
                    child.setText(comment);
                } else {
                    child.removeContent();
                }
            } else {
                element.removeChild("parameter");
                element.removeChild("parameter_type");
                element.removeChild("comment");
                element.removeChild("duration");
            }
            if (this._value != null) {
                if (this._parameter != null) {
                    ParamDouble paramDouble = new ParamDouble();
                    int parameterId = this._parameter.getParameterId();
                    AbstractJDomDataObject.setXmlValue(paramDouble, element, "value", this._value, parameterId);
                } else {
                    XMLUtilities.setChildElementAsDouble(element, "value", this._value);
                    if (this._xmlUnit != null && !this._xmlUnit.isEmpty()) {
                        element.getChild("value").setAttribute("unit", this._xmlUnit);
                    } else {
                        element.getChild("value").removeAttribute("unit");
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._parameter != null && this._parameterType != null && this._duration != null) {
            sb.append(this._parameter.toString()).append(DELIM).append(this._parameterType.toString()).append(DELIM).append(this._duration.toString());
        }
        return sb.toString();
    }

    @Override
    public synchronized JDomParameterTypedValueImpl clone() throws CloneNotSupportedException {
        JDomParameterTypedValueImpl theCopy = (JDomParameterTypedValueImpl)super.clone();
        theCopy._parameter = new Parameter(this._parameter);
        theCopy._parameterType = new ParameterType(this._parameterType);
        theCopy._duration = new Duration(this._duration);
        return theCopy;
    }
}

