/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.AbstractJDomDataObject;
import hec.data.DataSetException;
import hec.data.JDomDataObjectFactory;
import hec.data.level.ISeasonalInterval;
import hec.data.level.SeasonalIntervalType;
import hec.util.XMLUtilities;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import rma.util.RMAIO;

public class JDomSeasonalIntervalImpl
extends AbstractJDomDataObject
implements ISeasonalInterval {
    private int _years = 0;
    private int _months = 0;
    private int _days = 0;
    private int _hours = 0;
    private int _minutes = 0;
    public final String calParsingRegexp = "(.*)-(.*)";
    public final Pattern calParsingPattern = Pattern.compile("(.*)-(.*)");
    public final String timeParsingRegexp = "(.*) (.*):(.*):.*";
    public final Pattern timeParsingPattern = Pattern.compile("(.*) (.*):(.*):.*");
    private static final long serialVersionUID = 1316519075332132585L;

    public JDomSeasonalIntervalImpl() {
    }

    public JDomSeasonalIntervalImpl(Element element) {
        if (element != null) {
            this._years = XMLUtilities.getChildElementAsInt(element, "years", this._years);
            this._months = XMLUtilities.getChildElementAsInt(element, "months", this._months);
            this._days = XMLUtilities.getChildElementAsInt(element, "days", this._days);
            this._hours = XMLUtilities.getChildElementAsInt(element, "hours", this._hours);
            this._minutes = XMLUtilities.getChildElementAsInt(element, "minutes", this._minutes);
        }
    }

    public JDomSeasonalIntervalImpl(ISeasonalInterval interval) {
        if (interval instanceof JDomSeasonalIntervalImpl) {
            JDomSeasonalIntervalImpl intervalImpl = (JDomSeasonalIntervalImpl)interval;
            this._years = intervalImpl._years;
            this._months = intervalImpl._months;
            this._days = intervalImpl._days;
            this._hours = intervalImpl._hours;
            this._minutes = intervalImpl._minutes;
        } else {
            Element element = JDomDataObjectFactory.getRootElement(interval.toXmlString());
            if (element != null) {
                this._years = XMLUtilities.getChildElementAsInt(element, "years", this._years);
                this._months = XMLUtilities.getChildElementAsInt(element, "months", this._months);
                this._days = XMLUtilities.getChildElementAsInt(element, "days", this._days);
                this._hours = XMLUtilities.getChildElementAsInt(element, "hours", this._hours);
                this._minutes = XMLUtilities.getChildElementAsInt(element, "minutes", this._minutes);
            }
        }
    }

    @Override
    public void buildElement(Element element) {
        if (element != null) {
            XMLUtilities.setChildElementAsInt(element, "years", this._years);
            XMLUtilities.setChildElementAsInt(element, "months", this._months);
            XMLUtilities.setChildElementAsInt(element, "days", this._days);
            XMLUtilities.setChildElementAsInt(element, "hours", this._hours);
            XMLUtilities.setChildElementAsInt(element, "minutes", this._minutes);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._years;
        result = 31 * result + this._months;
        result = 31 * result + this._days;
        result = 31 * result + this._hours;
        result = 31 * result + this._minutes;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomSeasonalIntervalImpl other = (JDomSeasonalIntervalImpl)obj;
        if (this._years != other._years) {
            return false;
        }
        if (this._months != other._months) {
            return false;
        }
        if (this._days != other._days) {
            return false;
        }
        if (this._hours != other._hours) {
            return false;
        }
        return this._minutes == other._minutes;
    }

    @Override
    public boolean intervalHasCalendarAndTimeParts() {
        return this.intervalHasCalendarParts() && this.intervalHasTimeParts();
    }

    @Override
    public boolean intervalHasCalendarParts() {
        return this._years != 0 || this._months != 0;
    }

    @Override
    public boolean intervalHasTimeParts() {
        return this._days != 0 || this._hours != 0 || this._minutes != 0;
    }

    @Override
    public int getYears() {
        return this._years;
    }

    @Override
    public int getMonths() {
        return this._months;
    }

    @Override
    public int getDays() {
        return this._days;
    }

    @Override
    public int getHours() {
        return this._hours;
    }

    @Override
    public int getMinutes() {
        return this._minutes;
    }

    @Override
    public void setYears(int years) {
        this._years = years;
    }

    @Override
    public void setMonths(int months) {
        this._months = months;
    }

    @Override
    public void setDays(int days) {
        this._days = days;
    }

    @Override
    public void setHours(int hours) {
        this._hours = hours;
    }

    @Override
    public void setMinutes(int minutes) {
        this._minutes = minutes;
    }

    void setTotalMinutes(int intervalMinutes) {
        this._days = intervalMinutes / 1440;
        int remaining = intervalMinutes % 1440;
        this._hours = remaining / 60;
        this._minutes = remaining % 60;
    }

    void setTotalMonths(int intervalMonths) {
        this._years = intervalMonths / 12;
        this._months = intervalMonths % 12;
    }

    @Override
    public int getTotalMinutes() {
        return this._minutes + this._hours * 60 + this._days * 24 * 60;
    }

    @Override
    public int getTotalMonths() {
        return this._months + this._years * 12;
    }

    public void setYearMonthString(String yearMonthString) throws DataSetException {
        if (yearMonthString == null) {
            this._years = 0;
            this._months = 0;
            return;
        }
        Matcher matcher = this.calParsingPattern.matcher(yearMonthString);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new DataSetException("Illegal calendar interval string: " + yearMonthString);
        }
        String sYears = matcher.group(1);
        String sMonths = matcher.group(2);
        this._years = RMAIO.parseInt(sYears, 0);
        this._months = RMAIO.parseInt(sMonths, 0);
    }

    public void setDaysHoursMinutesString(String daysHoursMinutesString) throws DataSetException {
        if (daysHoursMinutesString == null) {
            this._days = 0;
            this._hours = 0;
            this._minutes = 0;
            return;
        }
        Matcher matcher = this.timeParsingPattern.matcher(daysHoursMinutesString);
        if (!matcher.matches() || matcher.groupCount() != 3) {
            throw new DataSetException("Illegal time offset string: " + daysHoursMinutesString);
        }
        String sDays = matcher.group(1);
        String sHours = matcher.group(2);
        String sMinutes = matcher.group(3);
        this._days = RMAIO.parseInt(sDays, 0);
        this._hours = RMAIO.parseInt(sHours, 0);
        this._minutes = RMAIO.parseInt(sMinutes, 0);
    }

    @Override
    public SeasonalIntervalType getType() {
        if (this.intervalHasCalendarAndTimeParts()) {
            return SeasonalIntervalType.YearMonthDayMinute;
        }
        if (this.intervalHasTimeParts()) {
            return SeasonalIntervalType.DayMinute;
        }
        if (this.intervalHasCalendarParts()) {
            return SeasonalIntervalType.YearMonth;
        }
        return null;
    }

    @Override
    public void clear() {
        this._years = 0;
        this._months = 0;
        this._days = 0;
        this._hours = 0;
        this._minutes = 0;
    }

    @Override
    public synchronized JDomSeasonalIntervalImpl clone() throws CloneNotSupportedException {
        JDomSeasonalIntervalImpl theCopy = (JDomSeasonalIntervalImpl)super.clone();
        return theCopy;
    }
}

