/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.AbstractJDomDataObject;
import hec.data.DbOfficeId;
import hec.data.JDomDataObjectFactory;
import hec.data.level.ISpecifiedLevel;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.BaseXMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.cwms.db.oracle.SpecifiedLevelT")
public class JDomSpecifiedLevelImpl
extends AbstractJDomDataObject
implements ISpecifiedLevel {
    private DbOfficeId _officeId = new DbOfficeId(null, null);

    public JDomSpecifiedLevelImpl() {
    }

    public JDomSpecifiedLevelImpl(Element element) {
        if (element != null) {
            this._name = element.getAttributeValue("id");
            this._officeId = DbOfficeId.parse(element.getChild("db_office_id"));
            this._description = element.getChildText("description");
        }
    }

    public JDomSpecifiedLevelImpl(ISpecifiedLevel ilevel) {
        this(JDomDataObjectFactory.getRootElement(ilevel.toXmlString()));
    }

    public JDomSpecifiedLevelImpl(DbOfficeId officeId, String id) {
        this._name = id;
        this._officeId = officeId;
    }

    @Override
    public void buildElement(Element element) {
        if (element != null) {
            String id = this.getId();
            if (id != null) {
                element.setAttribute("id", id);
            } else {
                element.removeAttribute("id");
            }
            Element child = BaseXMLUtilities.getOrCreateChild(element, "db_office_id");
            if (this._officeId != null) {
                this._officeId.buildElement(child);
            } else {
                child.removeContent();
            }
            child = BaseXMLUtilities.getOrCreateChild(element, "description");
            String description = this.getDescription();
            if (description != null && !description.isEmpty()) {
                child.setText(description);
            } else {
                child.removeContent();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._officeId == null ? 0 : this._officeId.hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomSpecifiedLevelImpl other = (JDomSpecifiedLevelImpl)obj;
        if (this._officeId == null ? other._officeId != null : !this._officeId.equals((Object)other._officeId)) {
            return false;
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    @Override
    public void setOfficeId(String officeId) {
        this._officeId = new DbOfficeId(officeId, this._officeId.getOfficeName());
    }

    @Override
    @EntityBeanMap(attributeName="OfficeId")
    public String getOfficeId() {
        return this._officeId.getOfficeId();
    }

    @Override
    @EntityBeanMap(attributeName="LevelId")
    public String getId() {
        return this.getName();
    }

    @Override
    public void setId(String newId) {
        this.setName(newId);
    }

    @Override
    @EntityBeanMap(attributeName="Description")
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public void setDescription(String s) {
        super.setDescription(s);
    }

    @Override
    public void set(ISpecifiedLevel newSpecifiedLevel) {
        this.setDescription(newSpecifiedLevel.getDescription());
        this.setId(newSpecifiedLevel.getId());
        this.setOfficeId(newSpecifiedLevel.getOfficeId());
    }

    @Override
    public DbOfficeId getDbOfficeId() {
        return this._officeId;
    }

    @Override
    public void setDbOfficeId(DbOfficeId dbOfficeId) {
        this._officeId = dbOfficeId;
    }
}

