/*
 * Decompiled with CFR 0.152.
 */
package hec.data.level;

import hec.data.level.ILocationLevelIndicator;
import hec.data.level.ILocationLevelIndicatorCondition;
import hec.data.level.ILocationLevelRef;
import hec.data.level.JDomLocationLevelRef;
import hec.data.location.LocationTemplate;
import hec.lang.NamedType;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class LocationLevelIndicatorImpl
extends NamedType
implements ILocationLevelIndicator {
    private JDomLocationLevelRef _indicatorLocationLevelRef;
    private String _indicatorId;
    private JDomLocationLevelRef _refLocationLevelRef;
    private String _minimumDuration;
    private String _maximumAge;
    private Map<Integer, ILocationLevelIndicatorCondition> _conditionMap = new TreeMap<Integer, ILocationLevelIndicatorCondition>();

    public LocationLevelIndicatorImpl() {
    }

    public LocationLevelIndicatorImpl(ILocationLevelRef indicatorLocationLevelRef, String indicatorId, ILocationLevelRef refLocationLevelRef) {
        this._indicatorId = indicatorId;
        this.setIndicatorLocationLevelRef(indicatorLocationLevelRef);
        this.setRefLocationLevelRef(refLocationLevelRef);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this._indicatorLocationLevelRef);
        hash = 23 * hash + Objects.hashCode(this._indicatorId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationLevelIndicatorImpl other = (LocationLevelIndicatorImpl)obj;
        if (!Objects.equals(this._indicatorLocationLevelRef, other._indicatorLocationLevelRef)) {
            return false;
        }
        return Objects.equals(this._indicatorId, other._indicatorId);
    }

    @Override
    public String getOfficeId() {
        if (this._indicatorLocationLevelRef == null) {
            return null;
        }
        return this._indicatorLocationLevelRef.getOfficeId();
    }

    @Override
    public LocationTemplate getLocationRef() {
        if (this._indicatorLocationLevelRef == null) {
            return null;
        }
        return this._indicatorLocationLevelRef.getLocationRef();
    }

    @Override
    public void setLocationRef(LocationTemplate locRef) {
        if (this._indicatorLocationLevelRef == null) {
            this._indicatorLocationLevelRef = new JDomLocationLevelRef();
        }
        this._indicatorLocationLevelRef.setLocationRef(locRef);
    }

    @Override
    public ILocationLevelRef getIndicatorLocationLevelRef() {
        return this._indicatorLocationLevelRef;
    }

    @Override
    public final void setIndicatorLocationLevelRef(ILocationLevelRef iLocationLevelRef) {
        this._indicatorLocationLevelRef = iLocationLevelRef instanceof JDomLocationLevelRef ? (JDomLocationLevelRef)iLocationLevelRef : new JDomLocationLevelRef(iLocationLevelRef);
    }

    @Override
    public String getLocationLevelIndicatorId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._indicatorLocationLevelRef.getLocationLevelId());
        sb.append(".");
        sb.append(this.getIndicatorId());
        return sb.toString();
    }

    @Override
    public String getIndicatorId() {
        return this._indicatorId;
    }

    @Override
    public void setIndicatorId(String indicatorId) {
        this._indicatorId = indicatorId;
    }

    @Override
    public ILocationLevelRef getRefLocationLevelRef() {
        return this._refLocationLevelRef;
    }

    @Override
    public final void setRefLocationLevelRef(ILocationLevelRef iLocationLevelRef) {
        this._refLocationLevelRef = iLocationLevelRef instanceof JDomLocationLevelRef ? (JDomLocationLevelRef)iLocationLevelRef : (iLocationLevelRef != null ? new JDomLocationLevelRef(iLocationLevelRef) : null);
    }

    @Override
    public String getMinimumDuration() {
        return this._minimumDuration;
    }

    @Override
    public void setMinimumDuration(String minimumDuration) {
        this._minimumDuration = minimumDuration;
    }

    @Override
    public String getMaximumAge() {
        return this._maximumAge;
    }

    @Override
    public void setMaximumAge(String maxiumumAge) {
        this._maximumAge = maxiumumAge;
    }

    @Override
    public Map<Integer, ILocationLevelIndicatorCondition> getConditionMap() {
        return this._conditionMap;
    }

    @Override
    public void setConditionMap(Map<Integer, ILocationLevelIndicatorCondition> conditionMap) {
        this._conditionMap.clear();
        this._conditionMap.putAll(conditionMap);
    }

    @Override
    public String toString() {
        return this.getIndicatorId();
    }
}

