/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import java.io.Serializable;

public class Alternative
implements Serializable {
    private static final long serialVersionUID = -6486939029043030578L;
    private String agencyId;
    private String agencyName;
    private String aliasId;
    private String aliasPublicName;
    private String aliasLongName;
    private String categoryId;
    private String locationGroupId;
    public static final String UNDEFINED = null;
    public static final String CBT = "CBT";
    public static final String GOES = "GOES";
    public static final String NWS = "NWS";
    public static final String SHEF = "SHEF";
    public static final String USGS = "USGS";
    public static final String[] ALTERNATIVES = new String[]{"CBT", "GOES", "NWS", "SHEF", "USGS"};

    public Alternative() {
    }

    public Alternative(String categoryId, String locationGroupId, String aliasId) {
        this.categoryId = categoryId;
        this.locationGroupId = locationGroupId;
        this.agencyId = categoryId + "-" + locationGroupId;
        this.aliasId = aliasId;
    }

    public Alternative(Alternative alt) {
        this.categoryId = alt.categoryId;
        this.locationGroupId = alt.locationGroupId;
        this.agencyId = alt.agencyId;
        this.aliasId = alt.aliasId;
        this.agencyName = alt.agencyName;
        this.aliasLongName = alt.aliasLongName;
        this.aliasPublicName = alt.aliasPublicName;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        this.agencyId = categoryId + "-" + this.locationGroupId;
    }

    public String getLocationGroupId() {
        return this.locationGroupId;
    }

    public void setLocationGroupId(String locationGroupId) {
        this.locationGroupId = locationGroupId;
        this.agencyId = this.categoryId + "-" + locationGroupId;
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getAliasId() {
        return this.aliasId;
    }

    public void setAliasId(String aliasId) {
        this.aliasId = aliasId;
    }

    public String getAliasLongName() {
        return this.aliasLongName;
    }

    public void setAliasLongName(String aliasLongName) {
        this.aliasLongName = aliasLongName;
    }

    public String getAliasPublicName() {
        return this.aliasPublicName;
    }

    public void setAliasPublicName(String aliasPublicName) {
        this.aliasPublicName = aliasPublicName;
    }
}

