/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.location.LocationTemplate;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class AssignedLocation
extends NamedType {
    private static final Logger LOGGER = Logger.getLogger(AssignedLocation.class.getName());
    private static final String LOC_REF = "loc_ref";
    private static final String ATTRIBUTE = "attribute";
    private static final String ALIAS_ID = "alias_id";
    private static final String ELEMENT = "assigned_location";
    private static final String ASSOCIATED_LOC_REF = "associated_loc_ref";
    private final double version = 1.0;
    private String aliasId;
    private Double attribute = null;
    private LocationTemplate locRef;
    private LocationTemplate _associatedLocRef;
    public static final Comparator<AssignedLocation> AttributeComparator = (loc, loc2) -> {
        int retval = -1;
        Double attribute1 = loc.getAttribute();
        Double attribute2 = loc2.getAttribute();
        if (attribute1 != null && attribute2 != null) {
            retval = Double.compare(attribute1, attribute2);
        } else if (attribute1 == null && attribute2 == null) {
            LocationTemplate locRef1 = loc.getLocRef();
            LocationTemplate locRef2 = loc2.getLocRef();
            retval = locRef1 == null && locRef2 == null ? 0 : LocationTemplate.LocationComparator.compare(locRef1, locRef2);
        } else if (attribute1 == null && attribute2 != null) {
            retval = 1;
        }
        return retval;
    };

    public AssignedLocation(LocationTemplate locRef, String aliasId, Double attribute, LocationTemplate associatedLocRef) {
        if (locRef != null) {
            this.setName(locRef.getName());
        }
        this.aliasId = aliasId;
        this.attribute = attribute;
        this.locRef = locRef;
        this._associatedLocRef = associatedLocRef;
    }

    public AssignedLocation(Element element) {
        if (element != null) {
            this.aliasId = element.getAttributeValue(ALIAS_ID);
            String attributeString = element.getAttributeValue(ATTRIBUTE);
            this.attribute = attributeString == null || attributeString.isEmpty() ? null : Double.valueOf(attributeString);
            this.locRef = LocationTemplate.parse(element.getChild(LOC_REF));
            Element child = element.getChild(ASSOCIATED_LOC_REF);
            if (child != null) {
                this._associatedLocRef = LocationTemplate.parse(child);
            }
        }
        if (this.locRef != null) {
            this.setName(this.locRef.getName());
        } else {
            LOGGER.fine("Constructing an AssignedLocation with a null LocationTemplate");
        }
    }

    public void buildElement(Element element) {
        if (element != null) {
            element.setAttribute("version", Double.toString(1.0));
            if (this.aliasId != null && !this.aliasId.isEmpty()) {
                element.setAttribute(ALIAS_ID, this.aliasId);
            }
            if (this.attribute != null) {
                element.setAttribute(ATTRIBUTE, this.attribute.toString());
            }
            if (this.locRef != null) {
                this.locRef.buildElement(XMLUtilities.getOrCreateChild(element, LOC_REF));
            }
            Element assocLocRef = XMLUtilities.getOrCreateChild(element, ASSOCIATED_LOC_REF);
            if (this._associatedLocRef != null) {
                this._associatedLocRef.buildElement(assocLocRef);
            } else {
                assocLocRef.removeContent();
            }
        }
    }

    @Override
    public void setName(String s) {
    }

    @Override
    public String getName() {
        LocationTemplate locationRef = this.getLocRef();
        if (locationRef == null) {
            return null;
        }
        return locationRef.getLocationId();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public LocationTemplate getAssociatedLocRef() {
        return this._associatedLocRef;
    }

    public void setAssociatedLocRef(LocationTemplate locRef) {
        this._associatedLocRef = locRef;
    }

    public String getAliasId() {
        return this.aliasId;
    }

    public void setAliasId(String aliasId) {
        this.aliasId = aliasId;
    }

    public Double getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Double attribute) {
        this.attribute = attribute;
    }

    public LocationTemplate getLocRef() {
        return this.locRef;
    }

    public void setLocRef(LocationTemplate locRef) {
        this.locRef = locRef;
    }

    public String toXmlString() {
        String retval = null;
        Element element = new Element(ELEMENT);
        this.buildElement(element);
        try {
            retval = XMLUtilities.toXmlString(element);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "toXmlString:Caught XmlException.", e);
        }
        return retval;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locRef == null ? 0 : this.locRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssignedLocation other = (AssignedLocation)obj;
        return !(this.locRef == null ? other.locRef != null : !this.locRef.equals((Object)other.locRef));
    }
}

