/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.DbOfficeId;
import hec.data.ParamDouble;
import hec.data.location.Alternative;
import hec.data.location.LocationTemplate;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;
import org.jdom.Attribute;
import org.jdom.Element;
import rma.util.RMAConst;

@EntityBeanType(beanType="usace.rowcps.db.oracle.LocationObjTUser")
public class Location
extends LocationTemplate
implements Serializable {
    private static final long serialVersionUID = 6707373635374701268L;
    public static final String[] NATION_LIST = new String[]{"UNITED STATES", "MEXICO", "CANADA"};
    public static final String ACTIVE = "active";
    public static final String LOCATION_TYPE = "location_type";
    public static final String LOCATION_KIND_ID = "location_kind_id";
    public static final String PUBLIC_NAME = "public_name";
    public static final String LONG_NAME = "long_name";
    public static final String DESCRIPTION = "description";
    public static final String NATION = "nation";
    public static final String STATE = "state";
    public static final String INITIAL = "initial";
    public static final String COUNTY = "county";
    public static final String NEAREST_CITY = "nearest_city";
    public static final String HORIZONTAL_LOCATION = "horizontal_location";
    public static final String ACTUAL = "actual";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String PUBLISHED = "published";
    public static final String ELEVATION = "elevation";
    public static final String UNIT = "unit";
    public static final String DATUM = "datum";
    public static final String TIMEZONE_NAME = "timezone_name";
    public static final String MAP_LABEL = "map_label";
    public static final String BOUNDING_OFFICE = "bounding_office";
    public static final String STATE_INITIAL = "state_initial";
    public static final String COUNTY_NAME = "county_name";
    public static final String HORIZONTAL_DATUM = "horizontal_datum";
    public static final String ELEV_UNIT_ID = "elev_unit_id";
    public static final String VERTICAL_DATUM = "vertical_datum";
    public static final String ACTIVE_FLAG = "active_flag";
    private Map alternatives = new TreeMap();
    private boolean active = true;
    private String publicName;
    private String longName;
    private String _description;
    private String timezoneId;
    private String locationType;
    private String extendedType;
    private String locationKind;
    private String nation;
    private String stateInitial;
    private String countyName;
    private String nearestCity;
    private String horizontalDatum;
    private Double longitude;
    private Double latitude;
    private Double publishedLongitude;
    private Double publishedLatitude;
    private String verticalDatum;
    private Double elevation;
    private String mapLabel;
    private String boundingOfficeId;
    private String boundingOfficeName;
    private boolean storeAlternatives = false;

    public void setStoreAlternatives(boolean val) {
        this.storeAlternatives = val;
    }

    public boolean getStoreAlternatives() {
        return this.storeAlternatives;
    }

    public static String getElevationUnits() {
        return ParameterLookup.getUnitsStringForSystem((String)"Elev", (int)2);
    }

    public static Location parseElement(Element locationElement) {
        if (locationElement == null) {
            return null;
        }
        LocationTemplate locationTempl = LocationTemplate.parse(locationElement);
        if (locationTempl == null) {
            return null;
        }
        Location location = new Location(locationTempl);
        boolean active = Boolean.parseBoolean(locationElement.getAttributeValue(ACTIVE));
        location.setActive(active);
        String locationType = locationElement.getAttributeValue(LOCATION_TYPE);
        location.setLocationType(locationType);
        String locationKind = locationElement.getAttributeValue(LOCATION_KIND_ID);
        location.setLocationKind(locationKind);
        String publicName = locationElement.getChildText(PUBLIC_NAME);
        location.setPublicName(publicName);
        String longName = locationElement.getChildText(LONG_NAME);
        location.setLongName(longName);
        String description = locationElement.getChildText(DESCRIPTION);
        location.setDescription(description);
        String nation = locationElement.getChildText(NATION);
        location.setNation(nation);
        Element child = locationElement.getChild(STATE);
        if (child != null) {
            String stateInitial = child.getAttributeValue(INITIAL);
            location.setStateInitial(stateInitial);
        }
        String county = locationElement.getChildText(COUNTY);
        location.setCountyName(county);
        String nearestCity = locationElement.getChildText(NEAREST_CITY);
        location.setNearestCity(nearestCity);
        child = locationElement.getChild(HORIZONTAL_LOCATION);
        if (child != null) {
            Double longitude2;
            Double latitude2;
            String horizontalDatum = child.getAttributeValue(DATUM);
            location.setHorizontalDatum(horizontalDatum);
            Element latlong = child.getChild(ACTUAL);
            if (latlong != null) {
                String actualLong;
                String actualLat = latlong.getChildText(LATITUDE);
                if (actualLat != null) {
                    try {
                        latitude2 = Double.parseDouble(actualLat);
                        location.setLatitude(latitude2);
                    }
                    catch (NumberFormatException latitude2) {
                        // empty catch block
                    }
                }
                if ((actualLong = latlong.getChildText(LONGITUDE)) != null) {
                    try {
                        longitude2 = Double.parseDouble(actualLong);
                        location.setLongitude(longitude2);
                    }
                    catch (NumberFormatException longitude2) {
                        // empty catch block
                    }
                }
            }
            if ((latlong = child.getChild(PUBLISHED)) != null) {
                String publishedLong;
                String publishedLat = latlong.getChildText(LATITUDE);
                if (publishedLat != null) {
                    try {
                        latitude2 = Double.parseDouble(publishedLat);
                        location.setPublishedLatitude(latitude2);
                    }
                    catch (NumberFormatException latitude3) {
                        // empty catch block
                    }
                }
                if ((publishedLong = latlong.getChildText(LONGITUDE)) != null) {
                    try {
                        longitude2 = Double.parseDouble(publishedLong);
                        location.setPublishedLongitude(longitude2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((child = locationElement.getChild(ELEVATION)) != null) {
            String elevUnit = child.getAttributeValue(UNIT);
            String elevDatum = child.getAttributeValue(DATUM);
            location.setVerticalDatum(elevDatum);
            String elevValue = child.getText();
            if (elevValue != null) {
                try {
                    Double elevation = Double.parseDouble(elevValue);
                    location.setElevation(elevation);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String timezoneName = locationElement.getChildText(TIMEZONE_NAME);
        location.setTimezoneId(timezoneName);
        String mapLabel = locationElement.getChildText(MAP_LABEL);
        location.setMapLabel(mapLabel);
        child = locationElement.getChild(BOUNDING_OFFICE);
        DbOfficeId dbOfficeId = DbOfficeId.parse(child);
        if (dbOfficeId != null) {
            location.setBoundingOffice(dbOfficeId.getOfficeId(), dbOfficeId.getOfficeName());
        }
        return location;
    }

    public void buildElement(Element element) {
        super.buildElement(element);
        Location.addAttributeToElement(element, ACTIVE, Boolean.toString(this.getActive()));
        Location.addAttributeToElement(element, LOCATION_TYPE, this.getLocationType());
        Location.addAttributeToElement(element, LOCATION_KIND_ID, this.getLocationKind());
        Element nameEl = XMLUtilities.getOrCreateChild(element, PUBLIC_NAME);
        nameEl.setText(this.getPublicName());
        Element longNameEl = XMLUtilities.getOrCreateChild(element, LONG_NAME);
        longNameEl.setText(this.getLongName());
        Element descEl = XMLUtilities.getOrCreateChild(element, DESCRIPTION);
        descEl.setText(this.getDescription());
        XMLUtilities.getOrCreateChild(element, NATION).setText(this.getNation());
        Element stateElement = XMLUtilities.getOrCreateChild(element, STATE);
        Location.addAttributeToElement(stateElement, INITIAL, this.getStateInitial());
        XMLUtilities.getOrCreateChild(element, COUNTY).setText(this.getCountyName());
        XMLUtilities.getOrCreateChild(element, NEAREST_CITY).setText(this.getNearestCity());
        Element horizontalChild = XMLUtilities.getOrCreateChild(element, HORIZONTAL_LOCATION);
        if (this.horizontalDatum != null) {
            horizontalChild.setAttribute(DATUM, this.horizontalDatum);
        } else {
            horizontalChild.removeAttribute(DATUM);
        }
        Element latlong = XMLUtilities.getOrCreateChild(horizontalChild, ACTUAL);
        Element lat = XMLUtilities.getOrCreateChild(latlong, LATITUDE);
        if (this.latitude != null) {
            lat.setText(this.latitude.toString());
        } else {
            lat.removeContent();
        }
        Element lng = XMLUtilities.getOrCreateChild(latlong, LONGITUDE);
        if (this.longitude != null) {
            lng.setText(this.longitude.toString());
        } else {
            lng.removeContent();
        }
        latlong = XMLUtilities.getOrCreateChild(horizontalChild, PUBLISHED);
        lat = XMLUtilities.getOrCreateChild(latlong, LATITUDE);
        if (this.publishedLatitude != null) {
            lat.setText(this.publishedLatitude.toString());
        } else {
            lat.removeContent();
        }
        lng = XMLUtilities.getOrCreateChild(latlong, LONGITUDE);
        if (this.publishedLongitude != null) {
            lng.setText(this.publishedLongitude.toString());
        } else {
            lng.removeContent();
        }
        Element elevationElement = XMLUtilities.getOrCreateChild(element, ELEVATION);
        Location.addAttributeToElement(elevationElement, UNIT, this.getElevationUnitId());
        Double elevation = this.getElevation();
        if (elevation == null || RMAConst.isUndefinedValue(elevation)) {
            elevationElement.removeContent();
        } else {
            String str = elevation.toString();
            elevationElement.setText(str);
            elevationElement.removeAttribute(UNIT);
            elevationElement.removeAttribute(DATUM);
            String elevUnit = this.getElevationUnitId();
            String elevDatum = this.getVerticalDatum();
            if (elevUnit != null) {
                elevationElement.setAttribute(UNIT, elevUnit);
            }
            if (elevDatum != null) {
                elevationElement.setAttribute(DATUM, elevDatum);
            }
        }
        XMLUtilities.getOrCreateChild(element, TIMEZONE_NAME).setText(this.getTimezoneId());
        XMLUtilities.getOrCreateChild(element, MAP_LABEL).setText(this.getMapLabel());
        DbOfficeId boundingDbOfficeId = new DbOfficeId(this.getBoundingOfficeId(), this.getBoundingOfficeName());
        boundingDbOfficeId.buildElement(XMLUtilities.getOrCreateChild(element, BOUNDING_OFFICE));
    }

    public Location(LocationTemplate template) {
        super(template);
    }

    public Location(Location fromLoc) {
        super(fromLoc);
        this.alternatives = new TreeMap(fromLoc.alternatives);
        this.setActive(fromLoc.getActive());
        this.setLocationType(fromLoc.getLocationType());
        this.setLocationKind(fromLoc.getLocationKind());
        this.setPublicName(fromLoc.getPublicName());
        this.setLongName(fromLoc.getLongName());
        this.setDescription(fromLoc.getDescription());
        this.setStateInitial(fromLoc.getStateInitial());
        this.setCountyName(fromLoc.getCountyName());
        this.setMapLabel(fromLoc.getMapLabel());
        this.setNearestCity(fromLoc.getNearestCity());
        this.setElevation(fromLoc.getElevation());
        this.setLongitude(fromLoc.getLongitude());
        this.setLatitude(fromLoc.getLatitude());
        this.setTimezoneId(fromLoc.getTimezoneId());
        this.setVerticalDatum(fromLoc.getVerticalDatum());
    }

    public Location() {
    }

    public Map getAlternativeMap() {
        return this.alternatives;
    }

    public void addAlternative(Alternative alt) {
        this.alternatives.put(alt.getAgencyId(), new Alternative(alt));
    }

    public String toStringBig() {
        StringBuffer out = new StringBuffer();
        out.append("Office Id = " + this.getOfficeId());
        out.append("\n");
        out.append("Location Id = " + this.getLocationId());
        out.append("\n");
        out.append("Public Name = " + this.getPublicName());
        out.append("\n");
        out.append("Long Name = " + this.getLongName());
        out.append("\n");
        out.append("Description = " + this.getDescription());
        out.append("\n");
        out.append("Elevation = " + this.getElevation());
        out.append("\n");
        out.append("Longitude = " + this.getLongitude());
        out.append("\n");
        out.append("Latitude = " + this.getLatitude());
        out.append("\n");
        out.append("Zone Id = " + this.getTimezoneId());
        out.append("\n");
        out.append("Location Type = " + this.getLocationType());
        out.append("\n");
        out.append("Vertical Datum = " + this.getVerticalDatum());
        out.append("\n");
        out.append("County Id (FIPS Number) = " + this.getCountyName());
        out.append("\n");
        out.append("State Initial = " + this.getStateInitial());
        out.append("\n");
        Iterator iterator = this.alternatives.keySet().iterator();
        while (iterator.hasNext()) {
            Alternative alt = (Alternative)this.alternatives.get(iterator.next());
            if (alt == null) continue;
            out.append("Agency Id = ");
            out.append(alt.getAgencyId());
            out.append("\n");
            out.append("Agency Name = ");
            out.append(alt.getAgencyId());
            out.append("\n");
            out.append("Alias Id = ");
            out.append(alt.getAliasId());
            out.append("\n");
            out.append("Alias Public Name = ");
            out.append(alt.getAliasPublicName());
            out.append("\n");
            out.append("Alias Long Name = ");
            out.append(alt.getAliasLongName());
            out.append("\n");
        }
        return out.toString();
    }

    @EntityBeanMap(attributeName="countyName")
    public String getCountyName() {
        return this.countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    @EntityBeanMap(attributeName="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @EntityBeanMap(attributeName="elevation")
    public Double getElevation() {
        return this.elevation;
    }

    public void setElevation(Double dbl) {
        this.elevation = dbl;
    }

    public void getElevation(ParamDouble pd) {
        pd.setUnitSystem(2);
        if (this.elevation != null) {
            pd.setUnitSystem(2);
            pd.setValue(this.elevation);
        } else {
            pd.setValue(Double.NEGATIVE_INFINITY);
        }
    }

    public void setElevation(ParamDouble pd) {
        double val;
        if (pd != null && RMAConst.isValidValue(val = pd.convertToUnitSystem(2))) {
            this.elevation = val;
            return;
        }
        this.elevation = null;
    }

    @EntityBeanMap(attributeName="elevUnitId")
    public String getElevationUnitId() {
        return Location.getElevationUnits();
    }

    public void setElevationUnitId(String s) {
    }

    @EntityBeanMap(attributeName="latitude")
    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLatitude(double dbl) {
        this.latitude = new Double(dbl);
    }

    @EntityBeanMap(attributeName="locationType")
    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(String extendedType) {
        this.extendedType = extendedType;
    }

    @EntityBeanMap(attributeName="longitude")
    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLongitude(double dbl) {
        this.longitude = new Double(dbl);
    }

    @EntityBeanMap(attributeName="longName")
    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    @EntityBeanMap(attributeName="publicName")
    public String getPublicName() {
        return this.publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    @EntityBeanMap(attributeName="stateInitial")
    public String getStateInitial() {
        return this.stateInitial;
    }

    public void setStateInitial(String stateInitial) {
        this.stateInitial = stateInitial;
    }

    @EntityBeanMap(attributeName="timeZoneName")
    public String getTimezoneId() {
        return this.timezoneId;
    }

    public void setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
    }

    @EntityBeanMap(attributeName="verticalDatum")
    public String getVerticalDatum() {
        return this.verticalDatum;
    }

    public void setVerticalDatum(String verticalDatum) {
        this.verticalDatum = verticalDatum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Location location = (Location)o;
        return this.getActive() == location.getActive() && this.getStoreAlternatives() == location.getStoreAlternatives() && Objects.equals(this.alternatives, location.alternatives) && Objects.equals(this.getPublicName(), location.getPublicName()) && Objects.equals(this.getLongName(), location.getLongName()) && Objects.equals(this.getTimezoneId(), location.getTimezoneId()) && Objects.equals(this.getLocationType(), location.getLocationType()) && Objects.equals(this.getExtendedType(), location.getExtendedType()) && Objects.equals(this.getLocationKind(), location.getLocationKind()) && Objects.equals(this.getNation(), location.getNation()) && Objects.equals(this.getStateInitial(), location.getStateInitial()) && Objects.equals(this.getCountyName(), location.getCountyName()) && Objects.equals(this.getNearestCity(), location.getNearestCity()) && Objects.equals(this.getHorizontalDatum(), location.getHorizontalDatum()) && Objects.equals(this.getLongitude(), location.getLongitude()) && Objects.equals(this.getLatitude(), location.getLatitude()) && Objects.equals(this.getPublishedLongitude(), location.getPublishedLongitude()) && Objects.equals(this.getPublishedLatitude(), location.getPublishedLatitude()) && Objects.equals(this.getVerticalDatum(), location.getVerticalDatum()) && Objects.equals(this.getElevation(), location.getElevation()) && Objects.equals(this.getMapLabel(), location.getMapLabel()) && Objects.equals(this.getBoundingOfficeId(), location.getBoundingOfficeId()) && Objects.equals(this.getBoundingOfficeName(), location.getBoundingOfficeName());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alternatives, this.getActive(), this.getPublicName(), this.getLongName(), this.getTimezoneId(), this.getLocationType(), this.getExtendedType(), this.getLocationKind(), this.getNation(), this.getStateInitial(), this.getCountyName(), this.getNearestCity(), this.getHorizontalDatum(), this.getLongitude(), this.getLatitude(), this.getPublishedLongitude(), this.getPublishedLatitude(), this.getVerticalDatum(), this.getElevation(), this.getMapLabel(), this.getBoundingOfficeId(), this.getBoundingOfficeName(), this.getStoreAlternatives());
    }

    public String getVerticalDatumWithNullsReplacedByUndefined() {
        if (this.verticalDatum == null || this.verticalDatum.equals("null")) {
            return "undefined";
        }
        return this.verticalDatum;
    }

    @EntityBeanMap(attributeName="horizontalDatum")
    public String getHorizontalDatum() {
        return this.horizontalDatum;
    }

    public void setHorizontalDatum(String horizontalDatum) {
        this.horizontalDatum = horizontalDatum;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @EntityBeanMap(attributeName="activeFlag")
    public String getActiveString() {
        return this.getActive() ? "T" : "F";
    }

    public void setActiveString(String value) {
        this.setActive(value.toUpperCase().equals("T"));
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    @EntityBeanMap(attributeName="nationId")
    public String getNation() {
        return this.nation;
    }

    public void setNearestCity(String nearestCity) {
        this.nearestCity = nearestCity;
    }

    @EntityBeanMap(attributeName="nearestCity")
    public String getNearestCity() {
        return this.nearestCity;
    }

    public void setPublishedLongitude(Double publishedLongitude) {
        this.publishedLongitude = publishedLongitude;
    }

    @EntityBeanMap(attributeName="publishedLongitude")
    public Double getPublishedLongitude() {
        return this.publishedLongitude;
    }

    public void setPublishedLatitude(Double publishedLatitude) {
        this.publishedLatitude = publishedLatitude;
    }

    @EntityBeanMap(attributeName="publishedLatitude")
    public Double getPublishedLatitude() {
        return this.publishedLatitude;
    }

    public void setMapLabel(String mapLabel) {
        this.mapLabel = mapLabel;
    }

    @EntityBeanMap(attributeName="mapLabel")
    public String getMapLabel() {
        return this.mapLabel;
    }

    public void setBoundingOffice(String newId, String newName) {
        this.setBoundingOfficeId(newId);
        this.setBoundingOfficeName(newName);
    }

    @EntityBeanMap(attributeName="boundingOfficeId")
    public String getBoundingOfficeId() {
        return this.boundingOfficeId;
    }

    public void setBoundingOfficeId(String newId) {
        this.boundingOfficeId = newId;
    }

    @EntityBeanMap(attributeName="boundingOfficeName")
    public String getBoundingOfficeName() {
        return this.boundingOfficeName;
    }

    public void setBoundingOfficeName(String newName) {
        this.boundingOfficeName = newName;
    }

    public void setLocationKind(String locationKind) {
        this.locationKind = locationKind;
    }

    @EntityBeanMap(attributeName="locationKindId")
    public String getLocationKind() {
        return this.locationKind;
    }

    @EntityBean(attributeName="locationRef")
    public LocationTemplate getLocationTemplate() {
        return new LocationTemplate(this);
    }

    public void setLocationTemplate(LocationTemplate locTemp) {
        this.setBaseLocationId(locTemp.getBaseLocationId());
        this.setLocationId(locTemp.getLocationId());
        this.setOfficeId(locTemp.getOfficeId());
        this.setOfficeName(locTemp.getOfficeName());
        this.setSubLocationId(locTemp.getSubLocationId());
    }

    public static Element addAttributeToElement(Element element, String name, String value) {
        Attribute attrib;
        if (value == null) {
            value = "";
        }
        if ((attrib = element.getAttribute(name)) != null) {
            attrib.setValue(value);
        } else {
            element.getAttributes().add(new Attribute(name, value));
        }
        return element;
    }
}

