/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.location.LocationCategoryRef;
import hec.data.location.LocationGroup;
import hec.data.location.LocationTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class LocationCategory {
    private String categoryId;
    private String officeId;
    private String description;
    private Map<String, LocationGroup> groupMap = new TreeMap<String, LocationGroup>();

    public LocationCategory(String categoryId) {
        this.categoryId = categoryId;
    }

    public LocationCategory(String categoryId, String officeId) {
        this.categoryId = categoryId;
        this.officeId = officeId;
    }

    public String getId() {
        return this.categoryId;
    }

    public String getOfficeId() {
        return this.officeId;
    }

    public void setOfficeId(String officeId) {
        this.officeId = officeId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescrpition() {
        return this.description;
    }

    public LocationGroup addGroup(String groupId, String groupDescription, String catOfficeId, String groupOfficeId, String sharedAlias, String sharedRef) {
        LocationTemplate locTemplate = null;
        if (sharedRef != null) {
            locTemplate = new LocationTemplate(groupOfficeId, sharedRef);
        }
        LocationGroup locationGroup = new LocationGroup(groupId, new LocationCategoryRef(this.getId(), catOfficeId), groupDescription, groupOfficeId, sharedAlias, locTemplate);
        return this.groupMap.put(locationGroup.getId(), locationGroup);
    }

    public LocationGroup addGroup(String groupId, String groupDescription, String catOfficeId, String groupOfficeId) {
        LocationGroup locationGroup = new LocationGroup(groupId, new LocationCategoryRef(this.getId(), catOfficeId), groupDescription, groupOfficeId, null, null);
        return this.groupMap.put(locationGroup.getId(), locationGroup);
    }

    public LocationGroup addGroup(String groupId, String officeId, String groupDescription) {
        LocationGroup locationGroup = new LocationGroup(groupId, new LocationCategoryRef(this.getId(), officeId), groupDescription, officeId, null, null);
        return this.groupMap.put(locationGroup.getId(), locationGroup);
    }

    public LocationGroup addGroup(LocationGroup locationGroup) {
        return this.groupMap.put(locationGroup.getId(), locationGroup);
    }

    public int size() {
        return this.groupMap.size();
    }

    public Collection<LocationGroup> values() {
        return this.groupMap.values();
    }

    public LocationGroup get(String groupId) {
        return this.groupMap.get(groupId);
    }
}

