/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.location.AssignedLocation;
import hec.data.location.LocationCategory;
import hec.data.location.LocationGroup;
import hec.data.meta.Catalog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class LocationCategoryMap
extends AbstractListModel
implements ComboBoxModel {
    private Map<String, LocationCategory> categoryMap = new TreeMap<String, LocationCategory>();
    private LocationGroup selectedItem;

    public LocationCategoryMap(Catalog locGroupCatalog) {
        this.categoryMap.clear();
        this.addParsedCatalog(locGroupCatalog, true);
    }

    public LocationCategoryMap() {
    }

    private void addParsedCatalog(Catalog locGroupCatalog, boolean addNullEntry) {
        int categoryIdIdx = locGroupCatalog.getColumnIndex("LOC_CATEGORY_ID");
        int categoryDescIdx = locGroupCatalog.getColumnIndex("LOC_CATEGORY_DESC");
        int categoryOfficeIdx = locGroupCatalog.getColumnIndex("CAT_DB_OFFICE_ID");
        int locGroupIdIdx = locGroupCatalog.getColumnIndex("LOC_GROUP_ID");
        int locGroupDescIdx = locGroupCatalog.getColumnIndex("LOC_GROUP_DESC");
        int locGroupOfficeIdx = locGroupCatalog.getColumnIndex("GRP_DB_OFFICE_ID");
        int locGroupSharedAlias = locGroupCatalog.getColumnIndex("SHARED_LOC_ALIAS_ID");
        int locGroupSharedRef = locGroupCatalog.getColumnIndex("SHARED_LOC_REF_ID");
        for (int rowidx = 0; rowidx < locGroupCatalog.size(); ++rowidx) {
            List row = locGroupCatalog.getRow(rowidx);
            String categoryId = (String)row.get(categoryIdIdx);
            String categoryDesc = (String)row.get(categoryDescIdx);
            String categoryOffice = (String)row.get(categoryOfficeIdx);
            String groupId = (String)row.get(locGroupIdIdx);
            String groupDesc = (String)row.get(locGroupDescIdx);
            String groupOfficeId = (String)row.get(locGroupOfficeIdx);
            String sharedAlias = (String)row.get(locGroupSharedAlias);
            String sharedRef = (String)row.get(locGroupSharedRef);
            if (categoryId == null) continue;
            LocationCategory category = this.categoryMap.get(categoryId);
            if (category == null) {
                category = new LocationCategory(categoryId, categoryOffice);
                category.setDescription(categoryDesc);
                this.categoryMap.put(categoryId, category);
            }
            if (groupId == null) continue;
            category.addGroup(groupId, groupDesc, categoryOffice, groupOfficeId, sharedAlias, sharedRef);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem instanceof LocationGroup ? (LocationGroup)anItem : (anItem != null ? this.find(anItem.toString()) : null);
        this.fireContentsChanged(this, -1, -1);
    }

    private LocationGroup find(String string) {
        StringTokenizer st = new StringTokenizer("-");
        if (st.countTokens() < 2) {
            return null;
        }
        String strCategory = st.nextToken();
        String strGroup = st.nextToken();
        LocationCategory category = this.categoryMap.get(strCategory);
        if (category == null) {
            return null;
        }
        return category.get(strGroup);
    }

    @Override
    public Object getElementAt(int index) {
        int ii = 0;
        for (LocationCategory locationCategory : this.categoryMap.values()) {
            int size = locationCategory.size();
            if (index > ii + size) {
                ii += size;
                continue;
            }
            for (LocationGroup locationGroup : locationCategory.values()) {
                if (ii == index) {
                    return locationGroup;
                }
                ++ii;
            }
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public int size() {
        int size = 0;
        for (LocationCategory locationCategory : this.categoryMap.values()) {
            size += locationCategory.size();
        }
        return size;
    }

    public LocationCategory[] getLocationCategories() {
        LocationCategory[] locationCategories = new LocationCategory[this.categoryMap.values().size()];
        int i = 0;
        for (LocationCategory locationCategory : this.categoryMap.values()) {
            locationCategories[i++] = locationCategory;
        }
        return locationCategories;
    }

    public LocationGroup[] getLocationGroups() {
        ArrayList<LocationGroup> locationGroupArray = new ArrayList<LocationGroup>();
        for (LocationCategory locationCategory : this.categoryMap.values()) {
            for (LocationGroup locationGroup : locationCategory.values()) {
                locationGroupArray.add(locationGroup);
            }
        }
        LocationGroup[] returnArray = new LocationGroup[locationGroupArray.size()];
        locationGroupArray.toArray(returnArray);
        return returnArray;
    }

    public void addCategory(LocationCategory category) {
        if (category == null || category.getId() == null) {
            return;
        }
        LocationCategory existingCategory = this.categoryMap.putIfAbsent(category.getId(), category);
        if (existingCategory != null) {
            category.values().forEach(this::addGroup);
        }
    }

    public void addGroup(LocationGroup group) {
        LocationGroup previousGroup;
        LocationCategory category;
        if (group != null && group.getCategoryId() != null && group.getId() != null && (category = this.categoryMap.get(group.getCategoryId())) != null && (previousGroup = category.addGroup(group)) != null) {
            for (AssignedLocation assignedLocation : previousGroup.getAssignedLocations()) {
                group.addAssignedLocation(assignedLocation);
            }
        }
    }
}

