/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.DbOfficeId;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import org.jdom.Element;

public class LocationCategoryRef
extends NamedType {
    public static final String ID = "id";
    private double version = 1.0;
    private String _catOfficeId = null;

    public LocationCategoryRef(String categoryId, String dbOfficeId) {
        this._catOfficeId = dbOfficeId;
        this.setName(categoryId);
    }

    public LocationCategoryRef() {
    }

    public LocationCategoryRef(Element element) {
        if (element != null) {
            String id = element.getAttributeValue(ID);
            this.setName(id);
            DbOfficeId dbOfficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            if (dbOfficeId != null) {
                this._catOfficeId = dbOfficeId.getOfficeId();
            }
        }
    }

    @Override
    public int compareTo(Object otherObj) {
        int c2;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == otherObj) {
            return 0;
        }
        if (otherObj == null) {
            return 1;
        }
        if (this.getClass() != otherObj.getClass()) {
            return super.compareTo(otherObj);
        }
        LocationCategoryRef other = (LocationCategoryRef)otherObj;
        if (this._catOfficeId == null) {
            if (other._catOfficeId != null) {
                return -1;
            }
        } else if (other._catOfficeId != null && (c2 = this._catOfficeId.compareTo(other._catOfficeId)) != 0) {
            return c2;
        }
        if (this.getId() == null) {
            if (other.getId() != null) {
                return -1;
            }
        } else if (other.getId() != null && (c2 = this.getId().compareTo(other.getId())) != 0) {
            return c2;
        }
        return 0;
    }

    public void buildElement(Element element) {
        if (element != null) {
            element.setAttribute("version", String.valueOf(this.version));
            element.setAttribute(ID, this.getId());
            Element dbOfficeElement = XMLUtilities.getOrCreateChild(element, "db_office_id");
            DbOfficeId dbOfficeId = new DbOfficeId(this._catOfficeId);
            dbOfficeId.buildElement(dbOfficeElement);
        }
    }

    public String getId() {
        return this.getName();
    }

    public void setId(String newId) {
        this.setName(newId);
    }

    public String getOfficeId() {
        return this._catOfficeId;
    }

    public void setOfficeId(String dbOfficeId) {
        this._catOfficeId = dbOfficeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().toUpperCase().hashCode());
        result = 31 * result + (this._catOfficeId == null ? 0 : this._catOfficeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationCategoryRef other = (LocationCategoryRef)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().toUpperCase().equals(other.getId().toUpperCase())) {
            return false;
        }
        return !(this._catOfficeId == null ? other._catOfficeId != null : !this._catOfficeId.equals(other._catOfficeId));
    }
}

