/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.location.AssignedLocation;
import hec.data.location.LocationCategoryRef;
import hec.data.location.LocationGroupRef;
import hec.data.location.LocationTemplate;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class LocationGroup
extends NamedType {
    private static final Logger logger = Logger.getLogger(LocationGroup.class.getName());
    public static final String DESCRIPTION = "description";
    public static final String SHARED_LOC_REF = "shared_loc_ref";
    public static final String SHARED_LOC_ALIAS_ID = "shared_loc_alias_id";
    public static final String LOC_GROUP_REF = "loc_group_ref";
    public static final String ASSIGNED_LOCATION_SET = "assigned_location_set";
    public static final String ASSIGNED_LOCATION = "assigned_location";
    public static final String LOC_REF = "loc_ref";
    public static final String ELEMENT = "loc_group";
    public static final String VERSION = "version";
    private double version = 1.0;
    private LocationGroupRef _groupRef = null;
    private Set<AssignedLocation> _assignedLocations = new HashSet<AssignedLocation>();
    private String _sharedLocAliasId;
    private LocationTemplate _sharedLocRef;

    public LocationGroup() {
    }

    public LocationGroup(String groupId, LocationCategoryRef categoryRef, String groupDescription, String dbOfficeId, String sharedLocAliasId, LocationTemplate sharedLocationRef) {
        this(new LocationGroupRef(categoryRef, dbOfficeId, groupId), groupDescription, sharedLocAliasId, sharedLocationRef);
    }

    public LocationGroup(LocationGroupRef groupRef, String groupDescription, String sharedLocAliasId, LocationTemplate sharedLocationRef) {
        super(groupRef.getId(), groupDescription);
        this._groupRef = groupRef;
        this._sharedLocAliasId = sharedLocAliasId;
        this._sharedLocRef = sharedLocationRef;
    }

    public LocationGroup(Element element) {
        this._ignoreModifiedEvents = true;
        if (element != null) {
            this._groupRef = new LocationGroupRef(element);
            this.setName(this._groupRef.getId());
            this._sharedLocAliasId = element.getAttributeValue(SHARED_LOC_ALIAS_ID);
            Element child = element.getChild(SHARED_LOC_REF);
            if (child != null) {
                this._sharedLocRef = LocationTemplate.parse(child);
            }
            this.setDescription(element.getChildText(DESCRIPTION));
            this._assignedLocations = this.parseAssignedLocations(element.getChild(ASSIGNED_LOCATION_SET));
        }
        this._ignoreModifiedEvents = false;
    }

    public LocationGroupRef getLocationGroupRef() {
        return this._groupRef;
    }

    public void setLocationGroupRef(LocationGroupRef groupRef) {
        this._groupRef = groupRef;
        if (this._groupRef != null) {
            this.setName(this._groupRef.getId());
        }
    }

    private NavigableSet<AssignedLocation> parseAssignedLocations(Element child) {
        TreeSet<AssignedLocation> locationSet = new TreeSet<AssignedLocation>(AssignedLocation.AttributeComparator);
        List children = child.getChildren(ASSIGNED_LOCATION);
        for (Element assignedLocElement : children) {
            AssignedLocation assignedLocation = new AssignedLocation(assignedLocElement);
            locationSet.add(assignedLocation);
        }
        return locationSet;
    }

    public void buildElement(Element element) {
        if (element != null) {
            element.setAttribute(VERSION, Double.toString(this.version));
            if (this._groupRef != null) {
                this._groupRef.buildElement(element);
            }
            Element descElement = XMLUtilities.getOrCreateChild(element, DESCRIPTION);
            descElement.setText(this.getDescription() == null ? "" : this.getDescription());
            Element assignLocSetElement = XMLUtilities.getOrCreateChild(element, ASSIGNED_LOCATION_SET);
            this.buildAssignedLocationSetElement(assignLocSetElement);
            if (this._sharedLocAliasId != null) {
                element.setAttribute(SHARED_LOC_ALIAS_ID, this._sharedLocAliasId);
            } else {
                element.removeAttribute(SHARED_LOC_ALIAS_ID);
            }
            Element sharedLocRefElement = XMLUtilities.getOrCreateChild(element, SHARED_LOC_REF);
            if (this._sharedLocRef != null) {
                this._sharedLocRef.buildElement(sharedLocRefElement);
            } else {
                sharedLocRefElement.removeContent();
            }
        }
    }

    private void buildAssignedLocationSetElement(Element assignLocSetElement) {
        List children = assignLocSetElement.getChildren(ASSIGNED_LOCATION);
        HashMap<String, Map<String, Element>> existingAssignedLocations = new HashMap<String, Map<String, Element>>();
        if (!this._assignedLocations.isEmpty()) {
            for (Element child : children) {
                AssignedLocation assignedLocation = new AssignedLocation(child);
                String officeId = assignedLocation.getLocRef().getOfficeId();
                String locId = assignedLocation.getLocRef().getLocationId();
                HashMap<String, Element> map = (HashMap<String, Element>)existingAssignedLocations.get(officeId);
                if (map == null) {
                    map = new HashMap<String, Element>();
                    existingAssignedLocations.put(officeId, map);
                }
                map.put(locId, child);
            }
        }
        ArrayList<Element> assignedLocationElements = new ArrayList<Element>();
        for (AssignedLocation assignedLoc : this._assignedLocations) {
            Element locRefElement = this.findOrBuildAssignedLocElement(assignedLoc, assignLocSetElement, existingAssignedLocations);
            assignedLoc.buildElement(locRefElement);
            locRefElement.detach();
            assignedLocationElements.add(locRefElement);
        }
        assignLocSetElement.removeContent();
        assignLocSetElement.addContent(assignedLocationElements);
    }

    private Element findOrBuildAssignedLocElement(AssignedLocation assignedLoc, Element assignLocSetElement, Map<String, Map<String, Element>> existingAssignedLocations) {
        Element retval;
        String officeId = assignedLoc.getLocRef().getOfficeId();
        String locId = assignedLoc.getLocRef().getLocationId();
        Map<String, Element> map = existingAssignedLocations.get(officeId);
        if (map != null && (retval = map.get(locId)) != null) {
            return retval;
        }
        retval = new Element(ASSIGNED_LOCATION);
        assignLocSetElement.addContent((Content)retval);
        return retval;
    }

    public String getGroupDescription() {
        return this.getDescription();
    }

    public void setGroupDescription(String groupDescription) {
        this.setDescription(groupDescription);
    }

    public String getId() {
        if (this._groupRef == null) {
            return null;
        }
        return this._groupRef.getId();
    }

    public void setId(String groupId) {
        if (this._groupRef == null) {
            this._groupRef = new LocationGroupRef();
        }
        this._groupRef.setId(groupId);
        this.setName(this._groupRef.getId());
    }

    public String getDbOfficeId() {
        if (this._groupRef == null) {
            return null;
        }
        return this._groupRef.getDbOfficeId();
    }

    public void setDbOfficeId(String dbOfficeId) {
        if (this._groupRef == null) {
            this._groupRef = new LocationGroupRef();
        }
        this._groupRef.setDbOfficeId(dbOfficeId);
    }

    public LocationCategoryRef getCategoryRef() {
        if (this._groupRef == null) {
            return null;
        }
        return this._groupRef.getCategoryRef();
    }

    public void setCategoryRef(LocationCategoryRef categoryRef) {
        if (this._groupRef == null) {
            this._groupRef = new LocationGroupRef();
        }
        this._groupRef.setCategoryRef(categoryRef);
    }

    public String getSharedLocAliasId() {
        return this._sharedLocAliasId;
    }

    public void setSharedLocAliasId(String aliasId) {
        this._sharedLocAliasId = aliasId;
    }

    public LocationTemplate getSharedLocRef() {
        return this._sharedLocRef;
    }

    public void setSharedLocRef(LocationTemplate sharedLocRef) {
        this._sharedLocRef = sharedLocRef;
    }

    public Set<AssignedLocation> getAssignedLocations() {
        return this._assignedLocations;
    }

    public List<AssignedLocation> getAssignedLocationsSorted() {
        ArrayList<AssignedLocation> locList = new ArrayList<AssignedLocation>();
        if (this._assignedLocations != null && !this._assignedLocations.isEmpty()) {
            locList.addAll(this._assignedLocations);
            Collections.sort(locList, AssignedLocation.AttributeComparator);
        }
        return locList;
    }

    public void setAssignedLocations(Set<AssignedLocation> assignedLocations) {
        this._assignedLocations.clear();
        this._assignedLocations.addAll(assignedLocations);
    }

    public void addAssignedLocation(AssignedLocation newLocation) {
        this._assignedLocations.add(newLocation);
    }

    public String toXmlString() {
        String retval = null;
        Element element = new Element(ELEMENT);
        this.buildElement(element);
        try {
            retval = XMLUtilities.toXmlString(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "toXmlString:Caught XmlException.", e);
        }
        return retval;
    }

    public String getCategoryId() {
        String retval = null;
        if (this._groupRef != null && this._groupRef.getCategoryRef() != null) {
            retval = this._groupRef.getCategoryRef().getId();
        }
        return retval;
    }

    public AssignedLocation removeLocation(LocationTemplate location) {
        if (location == null) {
            return null;
        }
        for (AssignedLocation assignedLocation : this._assignedLocations) {
            LocationTemplate locRef = assignedLocation.getLocRef();
            if (locRef == null || !locRef.equals((Object)location)) continue;
            this._assignedLocations.remove(assignedLocation);
            return assignedLocation;
        }
        return null;
    }

    public boolean containsLocationRef(LocationTemplate locationRef) {
        for (AssignedLocation assignedLocation : this._assignedLocations) {
            LocationTemplate locRef = assignedLocation.getLocRef();
            if (locRef == null || !locRef.equals((Object)locationRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this._groupRef == null) {
            return "";
        }
        return this._groupRef.toString();
    }
}

