/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.DbOfficeId;
import hec.data.location.LocationCategoryRef;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import org.jdom.Element;

public class LocationGroupRef
extends NamedType {
    private static final long serialVersionUID = -3183387991220602736L;
    public static final String ID = "id";
    public static final String LOC_CAT_REF = "loc_category_ref";
    private String _groupOfficeId = null;
    private LocationCategoryRef _categoryRef = null;

    public LocationGroupRef(LocationCategoryRef categoryRef, String groupOfficeId, String groupId) {
        this._categoryRef = categoryRef;
        this._groupOfficeId = groupOfficeId;
        this.setName(groupId);
    }

    public LocationGroupRef() {
    }

    public LocationGroupRef(Element element) {
        if (element != null) {
            String groupId = element.getAttributeValue(ID);
            LocationCategoryRef categoryRef = null;
            Element child = element.getChild(LOC_CAT_REF);
            if (child != null) {
                categoryRef = new LocationCategoryRef(child);
            }
            DbOfficeId dbOfficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            String groupOfficeId = dbOfficeId.getOfficeId();
            this._categoryRef = categoryRef;
            this._groupOfficeId = groupOfficeId;
            this.setName(groupId);
        }
    }

    @Override
    public int compareTo(Object otherObj) {
        int c2;
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == otherObj) {
            return 0;
        }
        if (otherObj == null) {
            return 1;
        }
        if (this.getClass() != otherObj.getClass()) {
            return super.compareTo(otherObj);
        }
        LocationGroupRef other = (LocationGroupRef)otherObj;
        if (this._categoryRef == null) {
            if (other._categoryRef != null) {
                return -1;
            }
        } else if (other._categoryRef != null && (c2 = this._categoryRef.compareTo(other._categoryRef)) != 0) {
            return c2;
        }
        if (this._groupOfficeId == null) {
            if (other._groupOfficeId != null) {
                return -1;
            }
        } else if (other._groupOfficeId != null && (c2 = this._groupOfficeId.compareTo(other._groupOfficeId)) != 0) {
            return c2;
        }
        if (this.getName() == null) {
            if (other.getName() != null) {
                return -1;
            }
        } else if (other.getName() != null && (c2 = this.getName().compareTo(other.getName())) != 0) {
            return c2;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._categoryRef == null ? 0 : this._categoryRef.hashCode());
        result = 31 * result + (this._groupOfficeId == null ? 0 : this._groupOfficeId.hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().toUpperCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationGroupRef other = (LocationGroupRef)obj;
        if (this._categoryRef == null ? other._categoryRef != null : !this._categoryRef.equals(other._categoryRef)) {
            return false;
        }
        if (this._groupOfficeId == null ? other._groupOfficeId != null : !this._groupOfficeId.equals(other._groupOfficeId)) {
            return false;
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().toUpperCase().equals(other.getName().toUpperCase()));
    }

    public String getDbOfficeId() {
        return this._groupOfficeId;
    }

    public void setDbOfficeId(String groupOfficeId) {
        this._groupOfficeId = groupOfficeId;
    }

    public LocationCategoryRef getCategoryRef() {
        return this._categoryRef;
    }

    public void setCategoryRef(LocationCategoryRef categoryRef) {
        this._categoryRef = categoryRef;
    }

    public String getId() {
        return this.getName();
    }

    public void setId(String groupId) {
        this.setName(groupId);
    }

    public void buildElement(Element element) {
        element.setAttribute(ID, this.getName() == null ? "" : this.getName());
        if (this._categoryRef != null) {
            Element catRefElement = XMLUtilities.getOrCreateChild(element, LOC_CAT_REF);
            this._categoryRef.buildElement(catRefElement);
        }
        DbOfficeId dbOfficeId = new DbOfficeId(this._groupOfficeId);
        Element dbOfficeElement = XMLUtilities.getOrCreateChild(element, "db_office_id");
        dbOfficeId.buildElement(dbOfficeElement);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._categoryRef != null) {
            sb.append(this._categoryRef.getId());
            sb.append("-");
        }
        sb.append(this.getId());
        return sb.toString();
    }
}

