/*
 * Decompiled with CFR 0.152.
 */
package hec.data.location;

import hec.data.location.LocationCategoryRef;
import hec.data.location.LocationGroup;
import hec.data.location.LocationGroupRef;
import hec.data.location.LocationTemplate;
import hec.lang.NamedType;
import hec.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class LocationGroupSet
extends NamedType {
    private static final Logger logger = Logger.getLogger(LocationGroupSet.class.getName());
    private NavigableMap<LocationGroupRef, LocationGroup> groupMap = new TreeMap<LocationGroupRef, LocationGroup>();
    public static final String ELEMENT = "loc_group_set";
    private double version = 1.0;

    LocationGroupSet(Element element) {
        this();
        if (element != null) {
            List locGroupElements = element.getChildren("loc_group");
            for (Element locGroupElement : locGroupElements) {
                LocationGroup locationGroup = new LocationGroup(locGroupElement);
                this.groupMap.put(locationGroup.getLocationGroupRef(), locationGroup);
            }
        }
    }

    public LocationGroupSet() {
    }

    public void buildElement(Element element) {
        if (element != null) {
            element.setAttribute("version", Double.toString(this.version));
            for (LocationGroup group : this.groupMap.values()) {
                Element locGroupElement = new Element("loc_group");
                group.buildElement(locGroupElement);
                element.addContent((Content)locGroupElement);
            }
        }
    }

    public String toXmlString() {
        String retval = null;
        Element element = new Element(ELEMENT);
        this.buildElement(element);
        try {
            retval = XMLUtilities.toXmlString(element);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "toXmlString:Caught XmlException.", e);
        }
        return retval;
    }

    public List<LocationGroup> getLocationGroups(LocationTemplate sharedLocRef, LocationTemplate associatedLocRef, LocationCategoryRef catRef) {
        if (catRef == null) {
            return null;
        }
        ArrayList<LocationGroup> groupList = new ArrayList<LocationGroup>();
        for (LocationGroup group : this.groupMap.values()) {
            LocationCategoryRef categoryRef;
            if (group == null || (categoryRef = group.getCategoryRef()) == null || !categoryRef.equals(catRef) || associatedLocRef != null && !group.containsLocationRef(associatedLocRef) || sharedLocRef != null && (group.getSharedLocRef() == null || !group.getSharedLocRef().equals((Object)sharedLocRef))) continue;
            groupList.add(group);
        }
        return groupList;
    }

    public LocationGroup getLocationGroup(LocationCategoryRef catRef, String groupId) {
        LocationGroupRef groupRef = new LocationGroupRef(catRef, catRef.getOfficeId(), groupId);
        return this.getLocationGroup(groupRef);
    }

    public LocationGroup getLocationGroup(LocationGroupRef groupRef) {
        return (LocationGroup)this.groupMap.get(groupRef);
    }

    public LocationGroup add(LocationGroup locationGroup) {
        LocationGroup prev = this.groupMap.put(locationGroup.getLocationGroupRef(), locationGroup);
        this.setModified(true);
        return prev;
    }

    public LocationGroup remove(LocationGroupRef groupRef) {
        return (LocationGroup)this.groupMap.remove(groupRef);
    }

    public void addAll(List<LocationGroup> list) {
        for (LocationGroup group : list) {
            this.groupMap.put(group.getLocationGroupRef(), group);
        }
        this.setModified(true);
    }

    public int size() {
        return this.groupMap.size();
    }

    public void clear() {
        this.setModified(true);
        this.groupMap.clear();
    }

    public List<LocationGroup> getLocationGroups() {
        Collection values = this.groupMap.values();
        ArrayList<LocationGroup> list = new ArrayList<LocationGroup>();
        list.addAll(values);
        return list;
    }

    public List<LocationGroupRef> getLocationGroupRefs() {
        Set keySet = this.groupMap.keySet();
        ArrayList<LocationGroupRef> list = new ArrayList<LocationGroupRef>();
        list.addAll(keySet);
        return list;
    }

    public LocationGroup[] toArray(LocationGroup[] a) {
        return this.groupMap.values().toArray(a);
    }

    public boolean contains(LocationGroupRef ref) {
        return this.groupMap.containsKey(ref);
    }
}

