/*
 * Decompiled with CFR 0.152.
 */
package hec.data.lock;

import hec.data.IColumnDescriptor;
import hec.data.location.LocationTemplate;
import hec.data.lock.ILockDescriptor;
import hec.lang.NamedType;
import java.util.List;

public class AtLockDescriptor
extends NamedType
implements Cloneable,
ILockDescriptor {
    private static final String PROJECT_LOCATION_ID = "project_location_id";
    private List<IColumnDescriptor> _columnList;
    private List<Object> _row;
    private LocationTemplate _projectLocationRef;
    private LocationTemplate _projectChildLocationRef;
    private String _publicName;
    private String _longName;

    public AtLockDescriptor(List<IColumnDescriptor> columnList, List<Object> row) {
        this._columnList = columnList;
        this._row = row;
        this.parseRow();
    }

    private void parseRow() {
        this._projectLocationRef = new LocationTemplate();
        this._projectChildLocationRef = new LocationTemplate();
        for (int ii = 0; ii < this._columnList.size(); ++ii) {
            Object object;
            IColumnDescriptor columnDescriptor = this._columnList.get(ii);
            String columnName = columnDescriptor.getColumnName();
            if (columnName == null) continue;
            if (columnName.equalsIgnoreCase("db_office_id")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._projectLocationRef.setOfficeId(object.toString());
                this._projectChildLocationRef.setOfficeId(object.toString());
                continue;
            }
            if (columnName.equalsIgnoreCase("base_location_id")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._projectChildLocationRef.setBaseLocationId(object.toString());
                continue;
            }
            if (columnName.equalsIgnoreCase("sub_location_id")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._projectChildLocationRef.setSubLocationId(object.toString());
                continue;
            }
            if (columnName.equalsIgnoreCase("public_name")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._publicName = object.toString();
                this.setName(this._publicName);
                continue;
            }
            if (columnName.equalsIgnoreCase("long_name")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._longName = object.toString();
                this.setDescription(this._longName);
                continue;
            }
            if (!columnName.equalsIgnoreCase(PROJECT_LOCATION_ID) || (object = this._row.get(ii)) == null) continue;
            String locationId = object.toString();
            this._projectLocationRef.setLocationId(locationId);
        }
    }

    public LocationTemplate getProjectLocationRef() {
        return this._projectLocationRef;
    }

    public LocationTemplate getProjectChildLocationRef() {
        return this._projectChildLocationRef;
    }

    public String getOfficeId() {
        if (this._projectChildLocationRef == null) {
            return null;
        }
        return this._projectChildLocationRef.getOfficeId();
    }

    public String getLocationId() {
        if (this._projectChildLocationRef == null) {
            return null;
        }
        return this._projectChildLocationRef.getLocationId();
    }

    public String getBaseLocationId() {
        if (this._projectChildLocationRef == null) {
            return null;
        }
        return this._projectChildLocationRef.getBaseLocationId();
    }

    public String getSubLocationId() {
        if (this._projectChildLocationRef == null) {
            return null;
        }
        return this._projectChildLocationRef.getSubLocationId();
    }

    public List<Object> getRow() {
        return this._row;
    }
}

