/*
 * Decompiled with CFR 0.152.
 */
package hec.data.lock;

import hec.data.AbstractJDomDataObject;
import hec.data.ColumnDescriptorImpl;
import hec.data.IColumnDescriptor;
import hec.data.JDomDataObjectFactory;
import hec.data.location.Location;
import hec.data.lock.AtLockDescriptor;
import hec.data.lock.ILock;
import hec.data.lock.ILockCatalog;
import hec.data.lock.ILockDescriptor;
import hec.data.lock.JDomLockImpl;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class JDomLockCatalogImpl
extends AbstractJDomDataObject
implements ILockCatalog {
    private static final Logger logger = Logger.getLogger(JDomLockCatalogImpl.class.getName());
    private List<IColumnDescriptor> _columnList = new ArrayList<IColumnDescriptor>();
    private List<ILockDescriptor> _lockDescriptorList = new ArrayList<ILockDescriptor>();

    public JDomLockCatalogImpl() {
    }

    public JDomLockCatalogImpl(Element element) {
        JDomDataObjectFactory<JDomLockImpl> factory = new JDomDataObjectFactory<JDomLockImpl>(JDomLockImpl.class);
        try {
            List<JDomLockImpl> lockList = factory.buildDataObjectList(element.getChildren());
            this.buildColumnList();
            for (int ii = 0; ii < lockList.size(); ++ii) {
                ILock lock = lockList.get(ii);
                List<Object> row = this.convertToRow(lock);
                this._lockDescriptorList.add(new AtLockDescriptor(this._columnList, row));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ColumnDescriptorImpl buildColumnDescriptor(String columnName, int columnType, String columnTypeName) {
        return new ColumnDescriptorImpl(columnName, columnType, columnTypeName);
    }

    private void buildColumnList() {
        this._columnList.clear();
        this._columnList.add(this.buildColumnDescriptor("db_office_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("project_location_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("base_location_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("sub_location_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("time_zone_name", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("latitude", 2, "number"));
        this._columnList.add(this.buildColumnDescriptor("longitude", 2, "number"));
        this._columnList.add(this.buildColumnDescriptor("horizontal_datum", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("elevation", 2, "number"));
        this._columnList.add(this.buildColumnDescriptor("elev_unit_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("vertical_datum", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("public_name", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("long_name", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("description", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("active_flag", 12, "varchar2"));
    }

    public List<Object> convertToRow(ILock projectChild) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(projectChild.getParentLocationRef().getOfficeId());
        Location location = projectChild.getLocation();
        row.add(location.getBaseLocationId());
        row.add(location.getSubLocationId());
        row.add(location.getTimezoneId());
        row.add(location.getLatitude());
        row.add(location.getLongitude());
        row.add(location.getHorizontalDatum());
        row.add(location.getElevation());
        row.add(location.getElevationUnits());
        row.add(location.getVerticalDatum());
        row.add(location.getPublicName());
        row.add(location.getLongName());
        row.add(location.getDescription());
        row.add(location.getActive());
        return row;
    }

    @Override
    public void buildElement(Element element) {
    }

    public void parse(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int numcols = metaData.getColumnCount();
        this._columnList.clear();
        for (int ii = 1; ii <= numcols; ++ii) {
            String columnName = metaData.getColumnName(ii);
            String columnTypeName = metaData.getColumnTypeName(ii);
            int columnType = metaData.getColumnType(ii);
            ColumnDescriptorImpl columnDescriptor = new ColumnDescriptorImpl(columnName, columnType, columnTypeName);
            this._columnList.add(columnDescriptor);
            if (!logger.isLoggable(Level.FINEST)) continue;
            String s = "column " + ii + ":" + columnName + ":" + columnTypeName;
            logger.log(Level.FINEST, s);
        }
        this._lockDescriptorList.clear();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>(numcols);
            for (int ii = 1; ii <= numcols; ++ii) {
                Object object = rs.getObject(ii);
                if (logger.isLoggable(Level.FINEST)) {
                    StringBuffer sb = new StringBuffer();
                    String msg = sb.toString();
                    logger.log(Level.FINEST, msg);
                }
                row.add(object);
            }
            this._lockDescriptorList.add(new AtLockDescriptor(this._columnList, row));
        }
    }

    @Override
    public List<ILockDescriptor> getLockDescriptorList() {
        return this._lockDescriptorList;
    }

    @Override
    public ILockDescriptor getLockDescriptor(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.size()) {
            return null;
        }
        ILockDescriptor descriptor = this._lockDescriptorList.get(rowIdx);
        return descriptor;
    }

    @Override
    public ILockDescriptor getLockDescriptor(String itemName) {
        if (itemName == null) {
            return null;
        }
        for (int ii = 0; ii < this._lockDescriptorList.size(); ++ii) {
            ILockDescriptor descriptor = this._lockDescriptorList.get(ii);
            String string = descriptor.toString();
            if (string == null || !string.equalsIgnoreCase(itemName)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public int size() {
        return this._lockDescriptorList.size();
    }

    private int getColumnCount() {
        return this._columnList.size();
    }

    @Override
    public List<IColumnDescriptor> getColumnList() {
        return this._columnList;
    }
}

