/*
 * Decompiled with CFR 0.152.
 */
package hec.data.lock;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.location.Location;
import hec.data.location.LocationTemplate;
import hec.data.lock.ILock;
import hec.data.lookup.ILookupType;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.LockObjTUser")
public class JDomLockImpl
extends AbstractJDomDataObject
implements ILock {
    private Location _lockLocation;
    private LocationTemplate _projectLocationRef;
    private double _lockWidth = Double.NEGATIVE_INFINITY;
    private double _lockLength = Double.NEGATIVE_INFINITY;
    private double _normalLockLift = Double.NEGATIVE_INFINITY;
    private double _volumePerLockage = Double.NEGATIVE_INFINITY;
    private double _minimumDraft = Double.NEGATIVE_INFINITY;
    private String _lengthUnit;
    private String _volumeUnit;
    private String _elevationUnit;
    private ILookupType _chamberType;
    private double _highWaterUpperPoolWarningLevel = Double.NEGATIVE_INFINITY;
    private double _highWaterLowerPoolWarningLevel = Double.NEGATIVE_INFINITY;
    private double _maximumLockLift = Double.NEGATIVE_INFINITY;
    private double _highWaterUpperPoolLocationLevel = Double.NEGATIVE_INFINITY;
    private double _lowWaterUpperPoolLocationLevel = Double.NEGATIVE_INFINITY;
    private double _highWaterLowerPoolLocationLevel = Double.NEGATIVE_INFINITY;
    private double _lowWaterLowerPoolLocationLevel = Double.NEGATIVE_INFINITY;

    public JDomLockImpl() {
    }

    @Deprecated
    public JDomLockImpl(Element lockElement) {
        Element element = lockElement.getChild("project_location_ref");
        if (element != null) {
            this._projectLocationRef = LocationTemplate.parse(element);
        }
        if ((element = lockElement.getChild("lock_location")) != null) {
            this._lockLocation = Location.parseElement(element);
            this.setName(this._lockLocation.getLocationId());
        }
        ParamDouble paramDouble = new ParamDouble();
        this._lockWidth = JDomLockImpl.getXmlValue(paramDouble, lockElement, "lock_width", Parameter.PARAMID_WIDTH);
        this._lockLength = JDomLockImpl.getXmlValue(paramDouble, lockElement, "lock_length", Parameter.PARAMID_LENGTH);
        this._normalLockLift = JDomLockImpl.getXmlValue(paramDouble, lockElement, "normal_lock_lift", Parameter.PARAMID_LENGTH);
        this._volumePerLockage = JDomLockImpl.getXmlValue(paramDouble, lockElement, "volume_per_lockage", Parameter.PARAMID_VOLUME);
        this._minimumDraft = JDomLockImpl.getXmlValue(paramDouble, lockElement, "minimum_draft", Parameter.PARAMID_LENGTH);
    }

    public JDomLockImpl(LocationTemplate projectLocationRef, Location lockLocation) {
        this._projectLocationRef = projectLocationRef;
        this._lockLocation = lockLocation;
        this.setName(this._lockLocation.getLocationId());
    }

    @Deprecated
    public JDomLockImpl(ILock iLock) {
        this(JDomDataObjectFactory.getRootElement(iLock.toXmlString()));
    }

    @Override
    @Deprecated
    public void buildElement(Element element) {
        Element projectLoc = XMLUtilities.getOrCreateChild(element, "project_location_ref");
        if (this.getParentLocationRef() != null) {
            this.getParentLocationRef().buildElement(projectLoc);
        }
        Element lockLoc = XMLUtilities.getOrCreateChild(element, "lock_location");
        if (this.getLocation() != null) {
            this.getLocation().buildElement(lockLoc);
        }
        ParamDouble paramDouble = new ParamDouble();
        JDomLockImpl.setXmlValue(paramDouble, element, "lock_width", this.getLockWidth(), Parameter.PARAMID_WIDTH);
        JDomLockImpl.setXmlValue(paramDouble, element, "lock_length", this.getLockLength(), Parameter.PARAMID_LENGTH);
        JDomLockImpl.setXmlValue(paramDouble, element, "normal_lock_lift", this.getNormalLockLift(), Parameter.PARAMID_LENGTH);
        JDomLockImpl.setXmlValue(paramDouble, element, "volume_per_lockage", this.getVolumePerLockage(), Parameter.PARAMID_VOLUME);
        JDomLockImpl.setXmlValue(paramDouble, element, "minimum_draft", this.getMinimumDraft(), Parameter.PARAMID_LENGTH);
    }

    @EntityBeanMap(attributeName="unitsId")
    public String getUnitsId() {
        return Parameter.getUnitsStringForSystem(Parameter.PARAMID_LENGTH, 2);
    }

    public void setUnitsId(String s) {
    }

    @EntityBeanMap(attributeName="volumeUnitsId")
    public String getVolumeUnitsId() {
        return Parameter.getUnitsStringForSystem(Parameter.PARAMID_VOLUME, 2);
    }

    public void setVolumeUnitsId(String s) {
    }

    @Override
    @EntityBeanMap(attributeName="lockLength")
    public double getLockLength() {
        return this._lockLength;
    }

    @Override
    @EntityBean(attributeName="lockLocation")
    public Location getLocation() {
        return this._lockLocation;
    }

    @Override
    public void setLengthUnit(String lengthUnit) {
        this._lengthUnit = lengthUnit;
    }

    @Override
    @EntityBeanMap(attributeName="lockUnit")
    public String getLengthUnit() {
        return this._lengthUnit;
    }

    @Override
    public void setElevationUnit(String unit) {
        this._elevationUnit = unit;
    }

    @Override
    @EntityBeanMap(attributeName="elevationUnit")
    public String getElevationUnit() {
        return this._elevationUnit;
    }

    @Override
    public void setVolumeUnit(String unit) {
        this._volumeUnit = unit;
    }

    @Override
    @EntityBeanMap(attributeName="volumeUnit")
    public String getVolumeUnit() {
        return this._volumeUnit;
    }

    @Override
    @EntityBeanMap(attributeName="lockWidth")
    public double getLockWidth() {
        return this._lockWidth;
    }

    @Override
    @EntityBeanMap(attributeName="minimumDraft")
    public double getMinimumDraft() {
        return this._minimumDraft;
    }

    @Override
    @EntityBeanMap(attributeName="normalLockLift")
    public double getNormalLockLift() {
        return this._normalLockLift;
    }

    @Override
    @EntityBean(attributeName="ProjectLocationRef")
    public LocationTemplate getParentLocationRef() {
        return this._projectLocationRef;
    }

    @Override
    public void setParentLocationRef(LocationTemplate projectLocationRef) {
        this._projectLocationRef = projectLocationRef;
    }

    @Override
    @EntityBeanMap(attributeName="volumePerLockage")
    public double getVolumePerLockage() {
        return this._volumePerLockage;
    }

    @Override
    public void setLockLength(Double val) {
        this._lockLength = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public void setLockWidth(Double val) {
        this._lockWidth = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public void setMinimumDraft(Double val) {
        this._minimumDraft = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public void setNormalLockLift(Double val) {
        this._normalLockLift = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public void setVolumePerLockage(Double val) {
        this._volumePerLockage = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public String toString() {
        if (this._lockLocation != null) {
            return this._lockLocation.getLocationId();
        }
        return super.toString();
    }

    @Override
    public void getLockLength(ParamDouble pd) {
        pd.setParameterId(Parameter.PARAMID_LENGTH);
        pd.setUnitSystem(2);
        pd.setValue(this._lockLength);
    }

    @Override
    public void setLockLength(ParamDouble pd) {
        this._lockLength = pd.convertToUnitSystem(2);
    }

    @Override
    public void getLockWidth(ParamDouble pd) {
        pd.setParameterId(Parameter.PARAMID_WIDTH);
        pd.setUnitSystem(2);
        pd.setValue(this._lockWidth);
    }

    @Override
    public void setLockWidth(ParamDouble pd) {
        this._lockWidth = pd.convertToUnitSystem(2);
    }

    @Override
    public void getMinimumDraft(ParamDouble pd) {
        pd.setParameterId(Parameter.PARAMID_LENGTH);
        pd.setUnitSystem(2);
        pd.setValue(this._minimumDraft);
    }

    @Override
    public void getMaximumLockLift(ParamDouble pd) {
        pd.setParameterId(Parameter.PARAMID_LENGTH);
        pd.setUnitSystem(2);
        pd.setValue(this._maximumLockLift);
    }

    @Override
    public void setMinimumDraft(ParamDouble pd) {
        this._minimumDraft = pd.convertToUnitSystem(2);
    }

    @Override
    public void getNormalLockLift(ParamDouble pd) {
        pd.setParameterId(Parameter.PARAMID_LENGTH);
        pd.setUnitSystem(2);
        pd.setValue(this._normalLockLift);
    }

    @Override
    public void setNormalLockLift(ParamDouble pd) {
        this._normalLockLift = pd.convertToUnitSystem(2);
    }

    @Override
    public void setHighWaterLowerPoolLocationLevel(Double level) {
        this._highWaterLowerPoolLocationLevel = level == null ? Double.NEGATIVE_INFINITY : level;
    }

    @Override
    public double getHighWaterLowerPoolLocationLevel() {
        return this._highWaterLowerPoolLocationLevel;
    }

    @Override
    public void setHighWaterUpperPoolLocationLevel(Double level) {
        this._highWaterUpperPoolLocationLevel = level == null ? Double.NEGATIVE_INFINITY : level;
    }

    @Override
    public void getVolumePerLockage(ParamDouble pd) {
        pd.setParameterId(Parameter.PARAMID_VOLUME);
        pd.setUnitSystem(2);
        pd.setValue(this._volumePerLockage);
    }

    @Override
    public void setVolumePerLockage(ParamDouble pd) {
        this._volumePerLockage = pd.convertToUnitSystem(2);
    }

    @Override
    public void setLocation(Location lockLocation) {
        this._lockLocation = lockLocation;
        this.setName(this._lockLocation.getLocationId());
    }

    @Override
    public void setMaximumLockLift(Double pd) {
        this._maximumLockLift = pd;
    }

    @Override
    public double getMaximumLockLift() {
        return this._maximumLockLift;
    }

    @Override
    public void setHighWaterUpperPoolWarningLevel(Double val) {
        this._highWaterUpperPoolWarningLevel = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public void setHighWaterLowerPoolWarningLevel(Double val) {
        this._highWaterLowerPoolWarningLevel = val == null ? Double.NEGATIVE_INFINITY : val;
    }

    @Override
    public void setLowWaterUpperPoolLocationLevel(Double level) {
        this._lowWaterUpperPoolLocationLevel = level == null ? Double.NEGATIVE_INFINITY : level;
    }

    @Override
    public double getLowWaterUpperPoolLocationLevel() {
        return this._lowWaterUpperPoolLocationLevel;
    }

    @Override
    public void setLowWaterLowerPoolLocationLevel(Double level) {
        this._lowWaterLowerPoolLocationLevel = level == null ? Double.NEGATIVE_INFINITY : level;
    }

    @Override
    public double getLowWaterLowerPoolLocationLevel() {
        return this._lowWaterLowerPoolLocationLevel;
    }

    @Override
    public double getHighWaterUpperPoolWarningLevel() {
        return this._highWaterUpperPoolWarningLevel;
    }

    @Override
    public double getHighWaterLowerPoolWarningLevel() {
        return this._highWaterLowerPoolWarningLevel;
    }

    @Override
    public double getHighWaterUpperPoolLocationLevel() {
        return this._highWaterUpperPoolLocationLevel;
    }

    @Override
    public ILookupType getChamberType() {
        return this._chamberType;
    }

    @Override
    public void setChamberType(ILookupType chamberType) {
        this._chamberType = chamberType;
    }
}

