/*
 * Decompiled with CFR 0.152.
 */
package hec.data.lookup;

import hec.data.AbstractJDomDataObject;
import hec.data.DbOfficeId;
import hec.data.JDomDataObjectFactory;
import hec.data.lookup.ILookupType;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.LookupTypeObjTUser")
public class JDomLookupTypeImpl
extends AbstractJDomDataObject
implements ILookupType {
    public static final String ATTR_TOOLTIP = "tooltip";
    public static final String ATTR_ACTIVE = "active";
    private boolean _active;
    private String _officeId;

    public JDomLookupTypeImpl() {
    }

    public JDomLookupTypeImpl(String officeId, boolean active, String displayValue, String tooltip) {
        this._officeId = officeId;
        this._active = active;
        this._name = displayValue;
        this._description = tooltip;
    }

    public JDomLookupTypeImpl(Element element) {
        if (element != null) {
            this._name = element.getValue().trim();
            this._description = element.getAttributeValue(ATTR_TOOLTIP);
            this._active = XMLUtilities.getAttributeValueAsBoolean(element, ATTR_ACTIVE, true);
            DbOfficeId dbofficeId = DbOfficeId.parse(element.getChild("db_office_id"));
            if (dbofficeId != null) {
                this._officeId = dbofficeId.getOfficeId();
            }
        }
    }

    public JDomLookupTypeImpl(ILookupType lookup) {
        this(JDomDataObjectFactory.getRootElement(lookup.toXmlString()));
    }

    @Override
    @EntityBeanMap(attributeName="OfficeId")
    public String getOfficeId() {
        return this._officeId;
    }

    @Override
    public void setOfficeId(String officeId) {
        this._officeId = officeId;
    }

    @Override
    @EntityBeanMap(attributeName="Active")
    public String getActiveString() {
        return this._active ? "T" : "F";
    }

    @Override
    public void setActiveString(String active) {
        this._active = active != null && active.equalsIgnoreCase("t");
    }

    @Override
    public boolean getActive() {
        return this._active;
    }

    @Override
    public void setActive(boolean active) {
        this._active = active;
    }

    @Override
    @EntityBeanMap(attributeName="DisplayValue")
    public String getDisplayValue() {
        return this.getName();
    }

    @Override
    @EntityBeanMap(attributeName="Tooltip")
    public String getTooltip() {
        return this.getDescription();
    }

    @Override
    public void setDisplayValue(String displayValue) {
        this.setName(displayValue);
    }

    @Override
    public void setTooltip(String tooltip) {
        this.setDescription(tooltip);
    }

    @Override
    public void buildElement(Element element) {
        element.setAttribute(ATTR_ACTIVE, this.getActiveString());
        String tooltip = this.getTooltip();
        if (tooltip != null) {
            element.setAttribute(ATTR_TOOLTIP, tooltip);
        } else {
            element.removeAttribute(ATTR_TOOLTIP);
        }
        String displayValue = this.getDisplayValue();
        element.setText(displayValue);
        Element child = XMLUtilities.getOrCreateChild(element, "db_office_id");
        new DbOfficeId(this._officeId).buildElement(child);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._officeId == null ? 0 : this._officeId.hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomLookupTypeImpl other = (JDomLookupTypeImpl)obj;
        if (this._officeId == null ? other._officeId != null : !this._officeId.equals(other._officeId)) {
            return false;
        }
        if (this.getName() == null) {
            return other.getName() == null;
        }
        return this.getName().equals(other.getName());
    }

    @Override
    public boolean isValid() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String tooltip = this.getTooltip();
        return tooltip != null && !tooltip.isEmpty();
    }
}

