/*
 * Decompiled with CFR 0.152.
 */
package hec.data.meta;

import hec.data.meta.CatalogListener;
import hec.data.meta.CatalogTemplate;
import hec.data.meta.Conditional;
import hec.data.meta.SqlQuery;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import rma.util.IntVector;

public class Catalog
extends CatalogTemplate
implements SqlQuery {
    List _rows;
    boolean _needToReOrder = false;
    HashSet _childCatalogs = new HashSet();
    private List<WeakReference<CatalogListener>> listenerList = new ArrayList<WeakReference<CatalogListener>>();

    public Catalog(CatalogTemplate catTemplate, List rows) {
        super(catTemplate);
        this._rows = rows;
    }

    public void addListener(CatalogListener l) {
        WeakReference<CatalogListener> ref = new WeakReference<CatalogListener>(l);
        this.listenerList.add(ref);
    }

    public void removeListener(CatalogListener l) {
        ArrayList<WeakReference<CatalogListener>> removeList = new ArrayList<WeakReference<CatalogListener>>();
        for (WeakReference<CatalogListener> ref : this.listenerList) {
            CatalogListener innerL = (CatalogListener)ref.get();
            if (innerL != null && innerL != l) continue;
            removeList.add(ref);
        }
        this.listenerList.removeAll(removeList);
    }

    public synchronized void set(List oldRow, List newRow) {
        this.update(oldRow, newRow);
    }

    public synchronized void set(int index, List row) {
        this._rows.set(index, row);
        this.fireRowUpdated(this, index, index);
    }

    public synchronized int getRowIndex(List row) {
        if (this._needToReOrder) {
            this.reOrder();
        }
        int idx = this._rows.indexOf(row);
        return idx;
    }

    public synchronized List getRow(int idx) {
        if (idx < 0 || idx >= this._rows.size()) {
            return null;
        }
        if (this._needToReOrder) {
            this.reOrder();
        }
        List row = (List)this._rows.get(idx);
        return Collections.unmodifiableList(row);
    }

    public synchronized int size() {
        if (this._rows == null) {
            return 0;
        }
        return this._rows.size();
    }

    public synchronized List getRows() {
        return Collections.unmodifiableList(this._rows);
    }

    public void merge(Catalog cat) {
        for (Object obj : cat.getRows()) {
            this.add((List)obj);
        }
    }

    public synchronized boolean add(List row) {
        Conditional c2;
        boolean tf = false;
        if (row.size() == this.getNumColumns() && ((c2 = this.getConditional()) == null || c2.evaluate(this.getColumnNames(), row))) {
            this._rows.add(row);
            Object[] children = this._childCatalogs.toArray();
            for (int ii = 0; ii < children.length; ++ii) {
                Catalog child = (Catalog)children[ii];
                child.add(row);
            }
            this.fireRowAdded(this, this._rows.size() - 1);
            tf = true;
        }
        return tf;
    }

    public boolean contains(List row, boolean caseSensitive) {
        boolean tf = false;
        if (row.size() == this.getNumColumns()) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof List) || !(o2 instanceof List)) {
                        // empty if block
                    }
                    List list1 = (List)o1;
                    List list2 = (List)o2;
                    StringBuffer sb1 = new StringBuffer();
                    StringBuffer sb2 = new StringBuffer();
                    sb1.setLength(0);
                    sb2.setLength(0);
                    for (int ii = 0; ii < list1.size() && ii < list2.size(); ++ii) {
                        Object objA = list1.get(ii);
                        Object objB = list2.get(ii);
                        if (objA != null) {
                            sb1.append(objA.toString().toUpperCase());
                        }
                        if (objB == null) continue;
                        sb2.append(objB.toString().toUpperCase());
                    }
                    return sb1.toString().compareTo(sb2.toString());
                }

                @Override
                public boolean equals(Object obj) {
                    return this == obj;
                }
            };
            int idx = Collections.binarySearch(this._rows, row, comparator);
            tf = idx >= 0;
        }
        return tf;
    }

    public synchronized boolean remove(int listColumn, int thisColumn, List list) {
        List row;
        if (listColumn < 0 || listColumn >= list.size()) {
            return false;
        }
        if (thisColumn < 0 || thisColumn >= this.getNumColumns()) {
            return false;
        }
        Object listObject = list.get(listColumn);
        String listObjectString = listObject.toString();
        ArrayList<List> removeRows = new ArrayList<List>();
        for (int rowIdx = 0; rowIdx < this._rows.size(); ++rowIdx) {
            row = (List)this._rows.get(rowIdx);
            Object thisObject = row.get(thisColumn);
            if (!listObjectString.equalsIgnoreCase(thisObject.toString())) continue;
            removeRows.add(row);
        }
        if (removeRows.size() < 1) {
            return false;
        }
        for (int ii = 0; ii < removeRows.size(); ++ii) {
            row = (List)removeRows.get(ii);
            this.remove(row);
        }
        return true;
    }

    public synchronized boolean remove(List row) {
        int idx;
        boolean tf = false;
        if (row.size() == this.getNumColumns() && (idx = this._rows.indexOf(row)) != -1 && this._rows.remove(row)) {
            Object[] children = this._childCatalogs.toArray();
            for (int ii = 0; ii < children.length; ++ii) {
                Catalog child = (Catalog)children[ii];
                child.remove(row);
            }
            this.fireRowRemoved(this, idx);
            tf = true;
        }
        return tf;
    }

    public synchronized boolean update(List oldRow, List newRow) {
        int idx;
        boolean tf = false;
        if (oldRow.size() == this.getNumColumns() && newRow.size() == this.getNumColumns() && (idx = this._rows.indexOf(oldRow)) != -1) {
            this._rows.set(idx, newRow);
            Object[] children = this._childCatalogs.toArray();
            for (int ii = 0; ii < children.length; ++ii) {
                Catalog child = (Catalog)children[ii];
                child.update(oldRow, newRow);
            }
            this.fireRowUpdated(this, idx, idx);
            tf = true;
        }
        return tf;
    }

    public synchronized boolean update(List oldList, List newList, int listColumn, int thisColumn) {
        if (oldList.size() != newList.size()) {
            return false;
        }
        if (listColumn < 0 || listColumn >= oldList.size()) {
            return false;
        }
        if (thisColumn < 0 || thisColumn >= this.getNumColumns()) {
            return false;
        }
        Object oldObject = oldList.get(listColumn);
        String oldObjectString = oldObject.toString();
        Object newObject = newList.get(listColumn);
        IntVector updatedRowIndexes = new IntVector();
        for (int rowIdx = 0; rowIdx < this._rows.size(); ++rowIdx) {
            List row = (List)this._rows.get(rowIdx);
            Object thisObject = row.get(thisColumn);
            if (!oldObjectString.equalsIgnoreCase(thisObject.toString())) continue;
            ArrayList newRow = new ArrayList(row.size());
            newRow.addAll(row);
            newRow.set(thisColumn, newObject);
            this._rows.set(rowIdx, newRow);
            updatedRowIndexes.add(rowIdx);
        }
        if (updatedRowIndexes.size() > 0) {
            int[] rowIndexes = updatedRowIndexes.toArray();
            Arrays.sort(rowIndexes);
            this.fireRowUpdated(this, rowIndexes[0], rowIndexes[rowIndexes.length - 1]);
            return true;
        }
        return false;
    }

    public synchronized Catalog executeQuery(CatalogTemplate catalogTemplate) throws SQLException {
        int ii;
        if (!this._table.equalsIgnoreCase(catalogTemplate._table)) {
            throw new SQLException("Catalog Table (" + this.getTable() + ") is different than QueryTemplate Table (" + catalogTemplate.getTable() + ").");
        }
        if (!this.containsColumns(catalogTemplate._columnNames)) {
            throw new SQLException("Catalog does not contain queried columns. " + catalogTemplate._columnNames);
        }
        if (catalogTemplate._conditional != null && !this.containsColumns(catalogTemplate._conditional.getColumns())) {
            throw new SQLException("Catalog does not contain the conditional columns: " + this._conditional.getColumns());
        }
        Catalog catalog = null;
        int newNumCols = catalogTemplate._columnNames.length;
        ArrayList newRows = new ArrayList();
        HashSet hashSet = null;
        if (catalogTemplate._distinct) {
            hashSet = new HashSet();
        }
        int[] columnIdxMap = new int[newNumCols];
        Arrays.fill(columnIdxMap, -1);
        block0: for (ii = 0; ii < newNumCols; ++ii) {
            for (int jj = 0; jj < this._columnNames.length; ++jj) {
                if (!catalogTemplate._columnNames[ii].equalsIgnoreCase(this._columnNames[jj])) continue;
                columnIdxMap[ii] = jj;
                continue block0;
            }
        }
        for (ii = 0; ii < this._rows.size(); ++ii) {
            List row = (List)this._rows.get(ii);
            if (catalogTemplate._conditional != null && !catalogTemplate._conditional.evaluate(catalogTemplate._columnNames, row)) continue;
            ArrayList resultingRow = new ArrayList(newNumCols);
            for (int jj = 0; jj < columnIdxMap.length; ++jj) {
                if (columnIdxMap[jj] == -1) continue;
                Object o = row.get(columnIdxMap[jj]);
                resultingRow.add(o);
            }
            if (hashSet != null) {
                if (!hashSet.add(resultingRow)) continue;
                newRows.add(resultingRow);
                continue;
            }
            newRows.add(resultingRow);
        }
        if (catalogTemplate._orderBy != null) {
            catalogTemplate._orderBy.order(catalogTemplate._columnNames, newRows);
        }
        catalog = new Catalog(catalogTemplate, newRows);
        this._childCatalogs.add(catalog);
        return catalog;
    }

    protected void fireRowRemoved(Object source, int row) {
        ArrayList<WeakReference<CatalogListener>> copy = new ArrayList<WeakReference<CatalogListener>>(this.listenerList);
        for (WeakReference weakReference : copy) {
            CatalogListener catalogListener = (CatalogListener)weakReference.get();
            if (catalogListener == null) continue;
            catalogListener.dataRemoved(row);
        }
    }

    protected void fireRowUpdated(Object source, int firstRow, int lastRow) {
        this._needToReOrder = true;
        ArrayList<WeakReference<CatalogListener>> copy = new ArrayList<WeakReference<CatalogListener>>(this.listenerList);
        for (WeakReference weakReference : copy) {
            CatalogListener catalogListener = (CatalogListener)weakReference.get();
            if (catalogListener == null) continue;
            catalogListener.dataUpdated(firstRow, lastRow);
        }
    }

    protected void fireRowAdded(Object source, int row) {
        this._needToReOrder = true;
        ArrayList<WeakReference<CatalogListener>> copy = new ArrayList<WeakReference<CatalogListener>>(this.listenerList);
        for (WeakReference weakReference : copy) {
            CatalogListener catalogListener = (CatalogListener)weakReference.get();
            if (catalogListener == null) continue;
            catalogListener.dataAdded(row);
        }
    }

    private void fireCatalogReordered() {
        ArrayList<WeakReference<CatalogListener>> copy = new ArrayList<WeakReference<CatalogListener>>(this.listenerList);
        for (WeakReference weakReference : copy) {
            CatalogListener catalogListener = (CatalogListener)weakReference.get();
            if (catalogListener == null) continue;
            catalogListener.dataChanged();
        }
    }

    public void reOrder() {
        if (this._orderBy != null) {
            this._orderBy.order(this._columnNames, this._rows);
            this.fireCatalogReordered();
        }
        this._needToReOrder = false;
    }

    public boolean needToReOrder() {
        return this._needToReOrder;
    }

    public int getNumVisibleColumns() {
        return this._numVisibleColumns;
    }

    public boolean[] getVisible() {
        return this._visible;
    }
}

