/*
 * Decompiled with CFR 0.152.
 */
package hec.data.meta;

import hec.data.meta.Conditional;
import hec.data.meta.ConditionalLeaf;
import hec.data.meta.ConditionalNode;
import hec.data.meta.MetaCatalogQuery;
import hec.data.meta.OrderBy;
import hec.data.meta.SqlQuery;
import java.io.Serializable;
import java.sql.SQLException;

public class CatalogTemplate
implements SqlQuery,
MetaCatalogQuery {
    String _table;
    String[] _columnNames;
    String[] _columnNameHeaders = null;
    boolean[] _visible;
    boolean _distinct;
    int _numVisibleColumns = 0;
    Conditional _conditional;
    OrderBy _orderBy;

    public static CatalogTemplate getMetaCatalogTemplate() {
        try {
            CatalogTemplate catTemplate = new CatalogTemplate("RT_META_CATALOG", META_CATALOG_COLUMNS, META_CATALOG_VISIBLE_COLUMNS, false, null, META_CATALOG_ORDER_BY);
            return catTemplate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public String[] getColumnNameHeaders() {
        return this._columnNameHeaders;
    }

    public int getColumnIndex(String columnName) {
        if (this._columnNames == null || columnName == null) {
            return -1;
        }
        for (int ii = 0; ii < this._columnNames.length; ++ii) {
            if (this._columnNames[ii] == null || columnName == null || !this._columnNames[ii].equalsIgnoreCase(columnName)) continue;
            return ii;
        }
        return -1;
    }

    public OrderBy getOrderBy() {
        return this._orderBy;
    }

    public boolean[] getVisibleColumns() {
        return this._visible;
    }

    public boolean getDistinct() {
        return this._distinct;
    }

    public Conditional getConditional() {
        return this._conditional;
    }

    public void setConditional(Conditional c2) {
        this._conditional = c2;
    }

    public void addOfficeIdConditional(String officeId, String officeColumn) {
        ConditionalLeaf officeCond = new ConditionalLeaf(officeColumn, "=", (Serializable)((Object)officeId));
        if (this._conditional != null) {
            ConditionalNode condNode = new ConditionalNode(officeCond, "AND", this._conditional);
            this._conditional = condNode;
        } else {
            this._conditional = officeCond;
        }
    }

    public CatalogTemplate(CatalogTemplate catTemplate) {
        this._table = new String(catTemplate._table);
        this._columnNames = new String[catTemplate._columnNames.length];
        System.arraycopy(catTemplate._columnNames, 0, this._columnNames, 0, catTemplate._columnNames.length);
        if (catTemplate._columnNameHeaders != null) {
            this._columnNameHeaders = new String[catTemplate._columnNameHeaders.length];
            System.arraycopy(catTemplate._columnNameHeaders, 0, this._columnNameHeaders, 0, catTemplate._columnNameHeaders.length);
        }
        this._visible = new boolean[catTemplate._visible.length];
        System.arraycopy(catTemplate._visible, 0, this._visible, 0, catTemplate._visible.length);
        this._distinct = catTemplate._distinct;
        try {
            if (catTemplate._conditional != null) {
                this._conditional = (Conditional)catTemplate._conditional.clone();
            }
        }
        catch (Exception e) {
            System.out.println("Error cloning Conditional");
            e.printStackTrace();
        }
        this._orderBy = new OrderBy(catTemplate._orderBy);
        this._numVisibleColumns = catTemplate._numVisibleColumns;
    }

    public CatalogTemplate(String table, String[] columns, boolean[] visible, boolean distinct, Conditional conditional, OrderBy orderBy) throws SQLException {
        this._table = table;
        this._columnNames = columns;
        this._visible = visible;
        this._distinct = distinct;
        for (int ii = 0; ii < this._visible.length; ++ii) {
            if (!this._visible[ii]) continue;
            ++this._numVisibleColumns;
        }
        this._conditional = conditional;
        this._orderBy = orderBy;
        if (this._orderBy != null && !this.containsColumns(this._orderBy._orderByColumns)) {
            throw new SQLException("CatalogTemplate does not contain OrderBy columns.");
        }
    }

    public CatalogTemplate(String table, String[] columns, String[] columnNameHeaders, boolean[] visible, boolean distinct, Conditional conditional, OrderBy orderBy) throws SQLException {
        this._table = table;
        this._columnNames = columns;
        this._columnNameHeaders = columnNameHeaders;
        this._visible = visible;
        this._distinct = distinct;
        for (int ii = 0; ii < this._visible.length; ++ii) {
            if (!this._visible[ii]) continue;
            ++this._numVisibleColumns;
        }
        this._conditional = conditional;
        this._orderBy = orderBy;
        if (this._orderBy != null && !this.containsColumns(this._orderBy._orderByColumns)) {
            throw new SQLException("CatalogTemplate does not contain OrderBy columns.");
        }
    }

    public String getTable() {
        return this._table;
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    public boolean containsColumns(String[] columns) {
        boolean tf = true;
        for (int jj = 0; jj < columns.length; ++jj) {
            boolean found = false;
            for (int ii = 0; ii < this._columnNames.length; ++ii) {
                if (!columns[jj].equalsIgnoreCase(this._columnNames[ii])) continue;
                found = true;
                break;
            }
            if (found) continue;
            tf = false;
            break;
        }
        return tf;
    }

    public boolean isMetaCatalogTemplate() {
        return this._table.equalsIgnoreCase("RT_META_CATALOG");
    }

    public int getNumColumns() {
        return this._columnNames.length;
    }

    @Override
    public String buildSqlQuery() {
        StringBuffer sb = new StringBuffer();
        this.buildSqlQuery(sb);
        return sb.toString();
    }

    @Override
    public StringBuffer buildSqlQuery(StringBuffer sb) {
        sb.append("SELECT");
        sb.append(" ");
        if (this._distinct) {
            sb.append("DISTINCT");
            sb.append(" ");
        }
        for (int ii = 0; ii < this._columnNames.length; ++ii) {
            sb.append(this._columnNames[ii]);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(" ");
        sb.append("FROM");
        sb.append(" ");
        sb.append(this._table);
        if (this._conditional != null) {
            sb.append(" ");
            sb.append("WHERE");
            sb.append(" ");
            this._conditional.buildSqlQuery(sb);
        }
        if (this._orderBy != null) {
            sb.append(" ");
            this._orderBy.buildSqlQuery(sb);
        }
        return sb;
    }
}

