/*
 * Decompiled with CFR 0.152.
 */
package hec.data.meta;

import hec.data.meta.Catalog;
import hec.data.meta.CatalogTemplate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public abstract class CatalogTemplateProducer
implements Serializable {
    public abstract CatalogTemplate getCatalogTemplate();

    public static Catalog buildBaseCatalog(Catalog catalog, String id, CatalogTemplate baseTemplate) {
        String[] ids = new String[]{id};
        return CatalogTemplateProducer.buildBaseCatalog(catalog, ids, baseTemplate);
    }

    public static Catalog buildBaseCatalog(Catalog catalog, String[] ids, CatalogTemplate baseTemplate) {
        int[] columnIndexes = new int[ids.length];
        for (int ii = 0; ii < ids.length; ++ii) {
            columnIndexes[ii] = catalog.getColumnIndex(ids[ii]);
        }
        List catalogRows = catalog.getRows();
        TreeMap map = new TreeMap();
        for (int ii = 0; ii < catalogRows.size(); ++ii) {
            List row = (List)catalogRows.get(ii);
            StringBuffer sb = new StringBuffer();
            ArrayList<String> newRow = new ArrayList<String>(columnIndexes.length);
            for (int jj = 0; jj < columnIndexes.length; ++jj) {
                String data = (String)row.get(columnIndexes[jj]);
                if (data != null) {
                    sb.append(data);
                }
                newRow.add(data);
                sb.append(".");
            }
            if (sb.length() <= columnIndexes.length) continue;
            map.put(sb.toString(), newRow);
        }
        ArrayList rows = new ArrayList(map.values());
        Catalog baseCatalog = new Catalog(baseTemplate, rows);
        return baseCatalog;
    }
}

