/*
 * Decompiled with CFR 0.152.
 */
package hec.data.meta;

import hec.data.meta.Conditional;
import hec.data.meta.SqlQuery;
import java.io.Serializable;
import java.util.List;

public class ConditionalLeaf
extends Conditional
implements SqlQuery {
    String _type;
    Serializable _value;

    public ConditionalLeaf(String type, String oper, Serializable value) {
        this._type = type;
        this._operator = oper;
        this._value = value;
    }

    @Override
    public int getNumberColumns() {
        return 1;
    }

    @Override
    public String buildSqlQuery() {
        StringBuffer sb = new StringBuffer();
        this.buildSqlQuery(sb);
        return sb.toString();
    }

    @Override
    public StringBuffer buildSqlQuery(StringBuffer sb) {
        sb.append(this._type);
        sb.append(" ");
        sb.append(this._operator);
        sb.append(" '");
        sb.append(this._value.toString());
        sb.append("'");
        return sb;
    }

    @Override
    public String[] getColumns() {
        String[] columns = new String[]{this._type};
        return columns;
    }

    @Override
    public boolean contains(Conditional c2) {
        String incomingSql = c2.buildSqlQuery();
        return this.buildSqlQuery().equals(incomingSql);
    }

    @Override
    public boolean evaluate(String[] colnames, List row) {
        boolean tf = true;
        for (int ii = 0; ii < colnames.length; ++ii) {
            if (!colnames[ii].equalsIgnoreCase(this._type)) continue;
            Object o = row.get(ii);
            if (this._operator.equalsIgnoreCase("=") && o.toString().compareToIgnoreCase(this._value.toString()) == 0) {
                tf = true;
                break;
            }
            if (this._operator.equalsIgnoreCase(">") && o.toString().compareToIgnoreCase(this._value.toString()) > 0) {
                tf = true;
                break;
            }
            if (this._operator.equalsIgnoreCase(">=") && o.toString().compareToIgnoreCase(this._value.toString()) >= 0) {
                tf = true;
                break;
            }
            if (this._operator.equalsIgnoreCase("<") && o.toString().compareToIgnoreCase(this._value.toString()) < 0) {
                tf = true;
                break;
            }
            if (this._operator.equalsIgnoreCase("<=") && o.toString().compareToIgnoreCase(this._value.toString()) <= 0) {
                tf = true;
                break;
            }
            if (this._operator.equalsIgnoreCase("<>") && o.toString().compareToIgnoreCase(this._value.toString()) != 0) {
                tf = true;
                break;
            }
            tf = false;
        }
        return tf;
    }
}

