/*
 * Decompiled with CFR 0.152.
 */
package hec.data.meta;

import hec.data.IntervalOffset;
import hec.data.meta.Catalog;
import hec.data.meta.CatalogTemplate;
import hec.data.meta.CatalogTemplateProducer;
import hec.data.meta.OrderBy;
import hec.data.tx.DescriptionTx;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class DescriptionTxCatalogQuery
extends CatalogTemplateProducer {
    public static final String CATALOG = "cwms_cat.cat_ts_desc";
    public static final String OFFICE_ID = "db_office_id";
    public static final String BASE_LOCATION_ID = "base_location_id";
    public static final String TIMESERIES_ID = "cwms_ts_id";
    public static final String INTERVAL_UTC_OFFSET = "interval_utc_offset";
    public static final String LOCAL_REGULAR_TIMEZONE = "lrts_timezone";
    public static final String ACTIVE_FLAG = "ts_active_flag";
    public static final String USER_PRIVILEGES = "user_privileges";
    public static final String TIMESERIES_ID_HEADER = "Time Series ID";
    private static final int OFFICE_ID_IDX = 0;
    private static final int BASE_LOCATION_ID_IDX = 1;
    private static final int TIMESERIES_ID_IDX = 2;
    private static final int INTERVAL_UTC_OFFSET_IDX = 3;
    private static final int LOCAL_REGULAR_TIMEZONE_IDX = 4;
    private static final int ACTIVE_FLAG_IDX = 5;
    private static final int USER_PRIVILEGES_IDX = 6;
    private static final int USER_PRIVILEGE_R = 2;
    private static final int USER_PRIVILEGE_RW = 6;
    public static final String[] COLUMNS = new String[]{"db_office_id", "base_location_id", "cwms_ts_id", "interval_utc_offset", "lrts_timezone", "ts_active_flag", "user_privileges"};
    public static final String[] COLUMN_HEADERS = new String[]{"", "", "Time Series ID"};
    public static final String[] ORDER_BY_STRING_ARRAY = new String[]{"base_location_id", "cwms_ts_id", "interval_utc_offset"};
    public static final OrderBy ORDER_BY = new OrderBy(ORDER_BY_STRING_ARRAY);
    public static final boolean[] VISIBLE_COLUMNS = new boolean[]{false, false, true, false, false, false, false};

    public static int getDefaultPrivilege() {
        return 6;
    }

    public static CatalogTemplate getDescriptionTxCatalogTemplate() {
        try {
            CatalogTemplate catTemplate = new CatalogTemplate(CATALOG, COLUMNS, COLUMN_HEADERS, VISIBLE_COLUMNS, false, null, ORDER_BY);
            return catTemplate;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List convertToTablePanelList(DescriptionTx desc) {
        ArrayList<Object> list = new ArrayList<Object>(COLUMNS.length);
        list.add(desc.getOfficeId());
        list.add(desc.getLocationID().getBaseLocation());
        list.add(desc.toString());
        list.add("" + desc.getUtcIntervalOffsetInMinutes());
        list.add(desc.getLocalRegularTimeZoneString());
        list.add(desc.getActive() ? "T" : "F");
        list.add(Integer.toString(desc.getUserPrivilege()));
        return list;
    }

    public static List convertToList(DescriptionTx desc) {
        ArrayList<String> list = new ArrayList<String>(COLUMNS.length);
        list.add(desc.getOfficeId());
        list.add(desc.getLocationID().getBaseLocation());
        list.add(desc.toString());
        list.add(IntervalOffset.getIntervalOffsetString(desc.getUtcIntervalOffset()));
        list.add(desc.getLocalRegularTimeZoneString());
        list.add(Boolean.toString(desc.getActive()));
        list.add(Integer.toString(desc.getUserPrivilege()));
        return list;
    }

    public static DescriptionTx convertToDescription(List<String> list) {
        if (list.size() != COLUMNS.length) {
            return null;
        }
        try {
            int minUtcIntervalOffset;
            String officeId = list.get(0);
            String strDesc = list.get(2);
            String strMinUtcIntervalOffset = list.get(3);
            String strLocalRegularTimeZone = list.get(4);
            String strActive = list.get(5);
            String strUserPrivileges = list.get(6);
            DescriptionTx desc = new DescriptionTx(officeId, strDesc);
            int secUtcIntervalOffset = minUtcIntervalOffset = Integer.parseInt(strMinUtcIntervalOffset);
            if (minUtcIntervalOffset != Integer.MIN_VALUE && minUtcIntervalOffset != Integer.MAX_VALUE) {
                secUtcIntervalOffset = minUtcIntervalOffset * 60;
            }
            desc.setUtcIntervalOffset(secUtcIntervalOffset);
            if (strLocalRegularTimeZone != null) {
                desc.setLocalRegularTimeZone(strLocalRegularTimeZone);
            }
            desc.setActive(Boolean.parseBoolean(strActive));
            desc.setUserPrivilege(Integer.parseInt(strUserPrivileges));
            return desc;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Error building Time Series Identifier from Catalog row. Identifier is: ");
            sb.append(list.toString());
            sb.append(".\nError is: " + e.getMessage());
            System.out.println(sb.toString());
            return null;
        }
    }

    public static boolean canWrite(String strUserPrivilege) {
        try {
            int ipriv = Integer.parseInt(strUserPrivilege);
            return DescriptionTxCatalogQuery.canWrite(ipriv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean canRead(String strUserPrivilege) {
        try {
            int ipriv = Integer.parseInt(strUserPrivilege);
            return DescriptionTxCatalogQuery.canRead(ipriv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean canReadWrite(String strUserPrivilege) {
        try {
            int ipriv = Integer.parseInt(strUserPrivilege);
            return DescriptionTxCatalogQuery.canReadWrite(ipriv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean canRead(int userPrivilege) {
        return (userPrivilege & 4) == 4;
    }

    public static boolean canWrite(int userPrivilege) {
        return (userPrivilege & 2) == 2;
    }

    public static boolean canReadWrite(int userPrivilege) {
        return (userPrivilege & 6) == 6;
    }

    @Override
    public CatalogTemplate getCatalogTemplate() {
        return DescriptionTxCatalogQuery.getDescriptionTxCatalogTemplate();
    }

    public static String getOfficeId(Catalog catalog, DescriptionTx descriptionTx) {
        if (descriptionTx.getOfficeId() != null && descriptionTx.getOfficeId().length() > 0) {
            return descriptionTx.getOfficeId();
        }
        if (!catalog.containsColumns(COLUMNS)) {
            return null;
        }
        for (int ii = 0; ii < catalog.size(); ++ii) {
            List row = catalog.getRow(ii);
            DescriptionTx catalogDesc = DescriptionTxCatalogQuery.convertToDescription(row);
            if (catalogDesc == null || !catalogDesc.equals(descriptionTx)) continue;
            return catalogDesc.getOfficeId();
        }
        return null;
    }

    public static Map<String, DescriptionTx> convertToUppercaseKeyedMap(List<List<String>> catList) {
        HashMap<String, DescriptionTx> retval = new HashMap<String, DescriptionTx>();
        if (catList != null) {
            for (List<String> row : catList) {
                DescriptionTx convertToDescription;
                if (row == null || (convertToDescription = DescriptionTxCatalogQuery.convertToDescription(row)) == null) continue;
                String id = convertToDescription.toString();
                String ucId = id.toUpperCase();
                retval.put(ucId, convertToDescription);
            }
        }
        return retval;
    }
}

