/*
 * Decompiled with CFR 0.152.
 */
package hec.data.meta;

import hec.data.location.Location;
import hec.data.location.LocationTemplate;
import hec.data.meta.CatalogTemplate;
import hec.data.meta.CatalogTemplateProducer;
import hec.data.meta.OrderBy;
import java.util.ArrayList;
import java.util.List;

public class LocationCatalogQuery
extends CatalogTemplateProducer {
    public static final String CATALOG = "cwms_cat.cat_location";
    public static final String CATALOG2 = "cwms_cat.cat_location2";
    public static final String DB_OFFICE_ID = "db_office_id";
    public static final String LOCATION_ID = "location_id";
    public static final String BASE_LOCATION_ID = "base_location_id";
    public static final String SUB_LOCATION_ID = "sub_location_id";
    public static final String STATE_INITIAL = "state_initial";
    public static final String COUNTY_NAME = "county_name";
    public static final String TIMEZONE_NAME = "time_zone_name";
    public static final String LOCATION_TYPE = "location_type";
    public static final String LOCATION_KIND = "location_kind_id";
    public static final String MAP_LABEL = "map_label";
    public static final String BOUNDING_OFFICE = "BOUNDING_OFFICE_ID";
    public static final String NATION = "NATION_ID";
    public static final String NEAREST_CITY = "nearest_city";
    public static final String PUB_LATITUDE = "PUBLISHED_LATITUDE";
    public static final String PUB_LONGITUDE = "PUBLISHED_LONGITUDE";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String HORIZONTAL_DATUM = "horizontal_datum";
    public static final String ELEVATION = "elevation";
    public static final String ELEV_UNIT_ID = "elev_unit_id";
    public static final String VERTICAL_DATUM = "vertical_datum";
    public static final String PUBLIC_NAME = "public_name";
    public static final String LONG_NAME = "long_name";
    public static final String DESCRIPTION = "description";
    public static final String ACTIVE_FLAG = "active_flag";
    public static final String OFFICE_ID_HEADER = "Office ID";
    public static final String LOCATION_ID_HEADER = "Location ID";
    @Deprecated
    public static final int BASE_LOCATION_ID_MAX_LENGTH = 24;
    @Deprecated
    public static final int SUB_LOCATION_ID_MAX_LENGTH = 32;
    public static final int OFFICE_ID_IDX = 0;
    public static final int LOCATION_ID_IDX = 1;
    public static final int BASE_LOCATION_ID_IDX = 2;
    public static final int SUB_LOCATION_ID_IDX = 3;
    public static final int STATE_INITIAL_IDX = 4;
    public static final int COUNTY_NAME_IDX = 5;
    public static final int TIMEZONE_NAME_IDX = 6;
    public static final int LOCATION_TYPE_IDX = 7;
    public static final int LATITUDE_IDX = 8;
    public static final int LONGITUDE_IDX = 9;
    public static final int HORIZONTAL_DATUM_IDX = 10;
    public static final int ELEVATION_IDX = 11;
    public static final int ELEVATION_UNIT_ID_IDX = 12;
    public static final int VERTICAL_DATUM_IDX = 13;
    public static final int PUBLIC_NAME_IDX = 14;
    public static final int LONG_NAME_IDX = 15;
    public static final int DESCRIPTION_IDX = 16;
    public static final int ACTIVE_FLAG_IDX = 17;
    public static final String[] LOCATION_CATALOG_COLUMNS = new String[]{"db_office_id", "location_id", "base_location_id", "sub_location_id", "state_initial", "county_name", "time_zone_name", "location_type", "latitude", "longitude", "horizontal_datum", "elevation", "elev_unit_id", "vertical_datum", "public_name", "long_name", "description", "active_flag"};
    public static final String[] LOCATION2_CATALOG_COLUMNS = new String[]{"location_kind_id", "map_label", "PUBLISHED_LATITUDE", "PUBLISHED_LONGITUDE", "BOUNDING_OFFICE_ID", "NATION_ID", "nearest_city"};
    public static final String[] LOCATION_CATALOG_ORDER_BY_STRING_ARRAY = new String[]{"base_location_id", "sub_location_id"};
    public static final OrderBy LOCATION_CATALOG_ORDER_BY = new OrderBy(LOCATION_CATALOG_ORDER_BY_STRING_ARRAY);
    public static final boolean[] LOCATION_CATALOG_VISIBLE_COLUMNS = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final boolean[] LOCATION2_CATALOG_VISIBLE_COLUMNS = new boolean[]{false, false, false, false, false, false, false};

    @Override
    public CatalogTemplate getCatalogTemplate() {
        return LocationCatalogQuery.getLocationCatalogTemplate();
    }

    public static CatalogTemplate getLocationCatalogTemplate() {
        try {
            CatalogTemplate catTemplate = new CatalogTemplate(CATALOG, LOCATION_CATALOG_COLUMNS, LOCATION_CATALOG_VISIBLE_COLUMNS, false, null, LOCATION_CATALOG_ORDER_BY);
            return catTemplate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CatalogTemplate getLocation2CatalogTemplate() {
        try {
            int i;
            int i2;
            String[] bothLocation = new String[LOCATION_CATALOG_COLUMNS.length + LOCATION2_CATALOG_COLUMNS.length];
            int j = 0;
            for (i2 = 0; i2 < LOCATION_CATALOG_COLUMNS.length; ++i2) {
                bothLocation[j++] = LOCATION_CATALOG_COLUMNS[i2];
            }
            for (i2 = 0; i2 < LOCATION2_CATALOG_COLUMNS.length; ++i2) {
                bothLocation[j++] = LOCATION2_CATALOG_COLUMNS[i2];
            }
            boolean[] bothVisible = new boolean[LOCATION_CATALOG_VISIBLE_COLUMNS.length + LOCATION2_CATALOG_VISIBLE_COLUMNS.length];
            j = 0;
            for (i = 0; i < LOCATION_CATALOG_VISIBLE_COLUMNS.length; ++i) {
                bothVisible[j++] = LOCATION_CATALOG_VISIBLE_COLUMNS[i];
            }
            for (i = 0; i < LOCATION2_CATALOG_VISIBLE_COLUMNS.length; ++i) {
                bothVisible[j++] = LOCATION2_CATALOG_VISIBLE_COLUMNS[i];
            }
            CatalogTemplate catTemplate = new CatalogTemplate(CATALOG2, bothLocation, bothVisible, false, null, LOCATION_CATALOG_ORDER_BY);
            return catTemplate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LocationTemplate convertToLocationTemplate(List row) {
        CatalogTemplate locationCatalogTemplate = LocationCatalogQuery.getLocationCatalogTemplate();
        String officeId = (String)row.get(locationCatalogTemplate.getColumnIndex(DB_OFFICE_ID));
        String baseLocationId = (String)row.get(locationCatalogTemplate.getColumnIndex(BASE_LOCATION_ID));
        String subLocationId = (String)row.get(locationCatalogTemplate.getColumnIndex(SUB_LOCATION_ID));
        LocationTemplate locationTemplate = new LocationTemplate(officeId, baseLocationId, subLocationId);
        return locationTemplate;
    }

    public static Location convertToLocation(List row) {
        Location retval = new Location();
        retval.setOfficeId(LocationCatalogQuery.wrapString(row.get(0)));
        retval.setLocationId(LocationCatalogQuery.wrapString(row.get(1)));
        retval.setStateInitial(LocationCatalogQuery.wrapString(row.get(4)));
        retval.setCountyName(LocationCatalogQuery.wrapString(row.get(5)));
        retval.setTimezoneId(LocationCatalogQuery.wrapString(row.get(6)));
        retval.setLocationType(LocationCatalogQuery.wrapString(row.get(7)));
        retval.setLatitude(LocationCatalogQuery.wrapDouble(row.get(8)));
        retval.setLongitude(LocationCatalogQuery.wrapDouble(row.get(9)));
        retval.setHorizontalDatum(LocationCatalogQuery.wrapString(row.get(10)));
        retval.setElevation(LocationCatalogQuery.wrapDouble(row.get(11)));
        retval.setElevationUnitId(LocationCatalogQuery.wrapString(row.get(12)));
        retval.setVerticalDatum(LocationCatalogQuery.wrapString(row.get(13)));
        retval.setPublicName(LocationCatalogQuery.wrapString(row.get(14)));
        retval.setLongName(LocationCatalogQuery.wrapString(row.get(15)));
        retval.setDescription(LocationCatalogQuery.wrapString(row.get(16)));
        retval.setActive(LocationCatalogQuery.wrapBoolean(row.get(17)));
        retval.setLocationKind(LocationCatalogQuery.wrapString(row.get(18)));
        retval.setMapLabel(LocationCatalogQuery.wrapString(row.get(19)));
        retval.setPublishedLatitude(LocationCatalogQuery.wrapDouble(row.get(20)));
        retval.setPublishedLongitude(LocationCatalogQuery.wrapDouble(row.get(21)));
        retval.setBoundingOfficeId(LocationCatalogQuery.wrapString(row.get(22)));
        retval.setNation(LocationCatalogQuery.wrapString(row.get(23)));
        retval.setNearestCity(LocationCatalogQuery.wrapString(row.get(24)));
        return retval;
    }

    private static String wrapString(Object object) {
        String retval = null;
        if (object != null) {
            retval = object.toString();
        }
        return retval;
    }

    private static boolean wrapBoolean(Object object) {
        boolean retval = false;
        if (object != null) {
            retval = "T".equals(object.toString()) ? true : ("F".equals(object.toString()) ? false : Boolean.parseBoolean(object.toString()));
        }
        return retval;
    }

    private static Double wrapDouble(Object object) {
        Double retval = null;
        if (object != null) {
            retval = Double.parseDouble(object.toString());
        }
        return retval;
    }

    public static List convertToList(Location location) {
        ArrayList<String> list = new ArrayList<String>(LOCATION_CATALOG_COLUMNS.length);
        list.add(location.getOfficeId());
        list.add(location.getLocationId());
        list.add(location.getBaseLocationId());
        list.add(location.getSubLocationId());
        list.add(location.getStateInitial());
        list.add(location.getCountyName());
        list.add(location.getTimezoneId());
        list.add(location.getLocationType());
        list.add(location.getLatitude().toString());
        list.add(location.getLongitude().toString());
        list.add(location.getHorizontalDatum());
        Double elev = location.getElevation();
        if (elev != null) {
            list.add(Double.toString(elev));
        } else {
            list.add(null);
        }
        list.add(location.getElevationUnitId());
        list.add(location.getVerticalDatum());
        list.add(location.getPublicName());
        list.add(location.getLongName());
        list.add(location.getDescription());
        list.add(Boolean.toString(location.getActive()));
        return list;
    }
}

