/*
 * Decompiled with CFR 0.152.
 */
package hec.data.operations;

import hec.data.AbstractJDomDataObject;
import hec.data.DataObjectException;
import hec.data.ILocationRef;
import hec.data.TimeWindow;
import hec.data.TimeWindowMap;
import hec.data.location.LocationTemplate;
import hec.data.operations.IPhysicalStructureOperationalChange;
import hec.data.operations.IPhysicalStructureOperationalChangeRef;
import hec.data.operations.IProjectOperationalChanges;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OperationalProjectChanges<OC extends IPhysicalStructureOperationalChange<? extends IPhysicalStructureOperationalChangeRef>>
extends AbstractJDomDataObject
implements ILocationRef,
IProjectOperationalChanges<OC> {
    private final NavigableMap<Date, OC> _datedOperationsChangeMap = new ConcurrentSkipListMap<Date, OC>();
    private final TimeWindowMap _modifiedTimeWindowMap = new TimeWindowMap();
    private LocationTemplate _projectLocationRef;

    public OperationalProjectChanges() {
    }

    public OperationalProjectChanges(LocationTemplate projectLocationRef) {
        this._projectLocationRef = projectLocationRef;
    }

    @Override
    public void clearTimeWindowMap() {
        this._modifiedTimeWindowMap.clear();
    }

    @Override
    public LocationTemplate getLocationRef() {
        return this._projectLocationRef;
    }

    @Override
    public OC getOperationalChange(Date changeDate) {
        return (OC)((IPhysicalStructureOperationalChange)this._datedOperationsChangeMap.get(changeDate));
    }

    @Override
    public NavigableMap<Date, OC> getOperationalChanges() {
        return this._datedOperationsChangeMap;
    }

    public NavigableMap<Date, OC> getOperationalChanges(Date startTime, Date endTime) {
        return this._datedOperationsChangeMap.subMap(startTime, true, endTime, true);
    }

    @Override
    public LocationTemplate getProjectLocationRef() {
        return this._projectLocationRef;
    }

    @Override
    public TimeWindowMap getTimeWindowMap() {
        return this._modifiedTimeWindowMap;
    }

    @Override
    public void mergeOperationalChanges(IProjectOperationalChanges<OC> projectOperationalChanges, boolean generateModifiedTimeWindow, boolean preserveModifiedData) throws DataObjectException {
        if (!this.getProjectLocationRef().equals((Object)projectOperationalChanges.getProjectLocationRef())) {
            throw new DataObjectException("Cannot merge operational changes for different projects.");
        }
        NavigableMap<Date, OC> datedOpsChanges = projectOperationalChanges.getOperationalChanges();
        this.mergeOperationalChanges(datedOpsChanges, generateModifiedTimeWindow, preserveModifiedData);
    }

    @Override
    public synchronized void mergeOperationalChanges(NavigableMap<Date, OC> datedOpsChangeMap, boolean generateModifiedTimeWindow, boolean preserveModifiedData) {
        if (datedOpsChangeMap == null || datedOpsChangeMap.isEmpty()) {
            return;
        }
        if (preserveModifiedData && this._modifiedTimeWindowMap.size() > 0) {
            Set<TimeWindow> timeWindowSet = this._modifiedTimeWindowMap.getTimeWindowSet();
            for (TimeWindow mtw : timeWindowSet) {
                Date mtwEndDate;
                Date mtwStartDate = mtw.getStartDate();
                NavigableMap<Date, OC> modSet = datedOpsChangeMap.subMap(mtwStartDate, true, mtwEndDate = mtw.getEndDate(), true);
                if (modSet == null || modSet.isEmpty()) continue;
                HashSet modSetKeys = new HashSet(modSet.keySet());
                datedOpsChangeMap.keySet().removeAll(modSetKeys);
            }
        }
        if (datedOpsChangeMap.isEmpty()) {
            return;
        }
        NavigableMap<Date, Object> tempCache = new TreeMap<Date, OC>(this._datedOperationsChangeMap);
        boolean valuesRemoved = (tempCache = tempCache.subMap((Date)datedOpsChangeMap.firstKey(), true, (Date)datedOpsChangeMap.lastKey(), true)).keySet().removeAll(datedOpsChangeMap.keySet());
        if (valuesRemoved) {
            Set entrySet = tempCache.entrySet();
            for (Map.Entry entry : entrySet) {
                Date key = (Date)entry.getKey();
                if (preserveModifiedData && this._modifiedTimeWindowMap.containedInTimeWindow(key, true)) continue;
                IPhysicalStructureOperationalChange value = (IPhysicalStructureOperationalChange)entry.getValue();
                value.setUndefined(true);
            }
        }
        this._datedOperationsChangeMap.putAll(datedOpsChangeMap);
        if (generateModifiedTimeWindow) {
            try {
                this._modifiedTimeWindowMap.addTimeWindow((Date)datedOpsChangeMap.firstKey(), true, (Date)datedOpsChangeMap.lastKey(), true);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(OperationalProjectChanges.class.getName()).log(Level.SEVERE, "Unable to merge operational changes. Invalid Time Window.", ex);
            }
        }
    }

    @Override
    public void setLocationRef(LocationTemplate projectLocationRef) {
        this._projectLocationRef = projectLocationRef;
    }

    public void setProjectLocationRef(LocationTemplate projectLocationRef) {
        this._projectLocationRef = projectLocationRef;
    }

    @Override
    public int size() {
        return this._datedOperationsChangeMap.size();
    }

    @Override
    public IProjectOperationalChanges<OC> windowAndLimit(Date startTime, Date endTime, boolean headFlag, int rowLimit, boolean pruneUndefined) {
        IProjectOperationalChanges<OC> dst = this.buildProjectOpsChanges(this._projectLocationRef);
        NavigableMap<Date, OC> srcChanges = this.getOperationalChanges(startTime, endTime);
        if (srcChanges == null || srcChanges.isEmpty()) {
            return dst;
        }
        NavigableMap<Date, OC> dstChanges = dst.getOperationalChanges();
        if (srcChanges.size() < rowLimit) {
            if (!pruneUndefined) {
                dstChanges.putAll(srcChanges);
            } else {
                Set entrySet = srcChanges.entrySet();
                for (Map.Entry entry : entrySet) {
                    Date key = (Date)entry.getKey();
                    IPhysicalStructureOperationalChange value = (IPhysicalStructureOperationalChange)entry.getValue();
                    if (value == null || value.isUndefined()) continue;
                    dstChanges.put(key, value);
                }
            }
            return dst;
        }
        Set<Object> keySet = headFlag ? srcChanges.keySet() : srcChanges.descendingKeySet();
        int ii = 0;
        for (Date key : keySet) {
            if (ii >= rowLimit) break;
            IPhysicalStructureOperationalChange srcVal = (IPhysicalStructureOperationalChange)srcChanges.get(key);
            if (pruneUndefined && srcVal.isUndefined()) continue;
            dstChanges.put(key, srcVal);
            ++ii;
        }
        return dst;
    }

    protected abstract IProjectOperationalChanges<OC> buildProjectOpsChanges(LocationTemplate var1);

    @Override
    public void deleteOperationalChanges(Set<Date> dateSet) {
        for (Date date : dateSet) {
            IPhysicalStructureOperationalChange opChange = (IPhysicalStructureOperationalChange)this._datedOperationsChangeMap.get(date);
            if (opChange == null) {
                OC undefChange = this.buildUndefOperationalChange(this.getProjectLocationRef(), date);
                this._datedOperationsChangeMap.put(date, undefChange);
            } else {
                opChange.setUndefined(true);
            }
            try {
                this._modifiedTimeWindowMap.addTimeWindow(date, true, date, true);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(OperationalProjectChanges.class.getName()).log(Level.SEVERE, "Invalid time window. Start time cannot be after end time.", ex);
            }
        }
    }

    @Override
    public void clearUndefinedChanges() {
        HashSet<Date> removeSet = new HashSet<Date>();
        Set entrySet = this._datedOperationsChangeMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Date key = (Date)entry.getKey();
            IPhysicalStructureOperationalChange value = (IPhysicalStructureOperationalChange)entry.getValue();
            if (value == null || !value.isUndefined()) continue;
            removeSet.add(key);
        }
        this._datedOperationsChangeMap.keySet().removeAll(removeSet);
    }

    protected abstract OC buildUndefOperationalChange(LocationTemplate var1, Date var2);
}

