/*
 * Decompiled with CFR 0.152.
 */
package hec.data.operations;

import hec.data.AbstractJDomDataObject;
import hec.data.ParamDouble;
import hec.data.ParamDoubleSupport;
import hec.data.Parameter;
import hec.data.location.LocationTemplate;
import hec.data.lookup.ILookupType;
import hec.data.operations.IPhysicalStructureOperationalChangeRef;
import java.util.Date;

public abstract class PhysicalStructureOperationalChange<T extends IPhysicalStructureOperationalChangeRef>
extends AbstractJDomDataObject {
    private T _changeRef;
    private ILookupType _dischargeComputationType;
    private ILookupType _reasonType;
    private boolean _isProtected = false;
    private double _newTotalDischargeOverride;
    private double _oldTotalDischargeOverride;
    private double _poolElev;
    private double _tailwaterElev;
    private boolean _undefined = false;

    public PhysicalStructureOperationalChange() {
    }

    public PhysicalStructureOperationalChange(T changeRef) {
        this._changeRef = changeRef;
    }

    public PhysicalStructureOperationalChange(T changeRef, ILookupType dischargeComputationLookup, ILookupType reasonLookup, boolean isProtected) {
        this._changeRef = changeRef;
        this._dischargeComputationType = dischargeComputationLookup;
        this._reasonType = reasonLookup;
        this._isProtected = isProtected;
    }

    public T getOperationalChangeRef() {
        return this._changeRef;
    }

    public LocationTemplate getProjectLocationRef() {
        if (this._changeRef == null) {
            return null;
        }
        return this._changeRef.getProjectLocationRef();
    }

    public Date getChangeDate() {
        if (this._changeRef == null) {
            return null;
        }
        return this._changeRef.getChangeDate();
    }

    public String getChangeNotes() {
        return this.getDescription();
    }

    public ILookupType getDischargeComputation() {
        return this._dischargeComputationType;
    }

    public ILookupType getReason() {
        return this._reasonType;
    }

    public void setReason(ILookupType type) {
        this._reasonType = type;
    }

    public String getDischargeUnits() {
        return Parameter.getUnitsStringForSystem(Parameter.PARAMID_FLOW, 2);
    }

    public String getElevationUnits() {
        return Parameter.getUnitsStringForSystem(Parameter.PARAMID_ELEV, 2);
    }

    public double getNewTotalDischargeOverride() {
        return this._newTotalDischargeOverride;
    }

    public void getNewTotalDischargeOverride(ParamDouble pd) {
        ParamDoubleSupport.FLOW.initParamDouble(pd);
        pd.setValue(this._newTotalDischargeOverride);
    }

    public double getOldTotalDischargeOverride() {
        return this._oldTotalDischargeOverride;
    }

    public void getOldTotalDischargeOverride(ParamDouble pd) {
        ParamDoubleSupport.FLOW.initParamDouble(pd);
        pd.setValue(this._oldTotalDischargeOverride);
    }

    public double getPoolElevation() {
        return this._poolElev;
    }

    public void getPoolElevation(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this._poolElev);
    }

    public double getTailwaterElevation() {
        return this._tailwaterElev;
    }

    public void getTailwaterElevation(ParamDouble pd) {
        ParamDoubleSupport.ELEV.initParamDouble(pd);
        pd.setValue(this._tailwaterElev);
    }

    public boolean isProtected() {
        return this._isProtected;
    }

    public boolean isUndefined() {
        return this._undefined;
    }

    public void setChangeNotes(String notes) {
        this.setDescription(notes);
    }

    public void setDischargeComputation(ILookupType type) {
        this._dischargeComputationType = type;
    }

    public void setNewTotalDischargeOverride(ParamDouble pd) {
        this._newTotalDischargeOverride = pd.convertToUnitSystem(2);
    }

    public void setNewTotalDischargeOverride(double d) {
        this._newTotalDischargeOverride = d;
    }

    public void setOldTotalDischargeOverride(ParamDouble pd) {
        this._oldTotalDischargeOverride = pd.convertToUnitSystem(2);
    }

    public void setOldTotalDischargeOverride(double d) {
        this._oldTotalDischargeOverride = d;
    }

    public void setPoolElevation(double d) {
        this._poolElev = d;
    }

    public void setPoolElevation(ParamDouble pd) {
        this._poolElev = pd.convertToUnitSystem(2);
    }

    public void setProtected(boolean tf) {
        this._isProtected = tf;
    }

    public void setTailwaterElevation(double d) {
        this._tailwaterElev = d;
    }

    public void setTailwaterElevation(ParamDouble pd) {
        this._tailwaterElev = pd.convertToUnitSystem(2);
    }

    public void setUndefined(boolean tf) {
        this._undefined = tf;
    }
}

