/*
 * Decompiled with CFR 0.152.
 */
package hec.data.outlet;

import hec.data.JDomDataObjectException;
import hec.data.JDomDataObjectFactory;
import hec.data.characteristic.ICharacteristicTypeRef;
import hec.data.characteristic.JDomCharacteristicTypeRef;
import hec.data.location.Location;
import hec.data.location.LocationGroupRef;
import hec.data.location.LocationTemplate;
import hec.data.outlet.IOutlet;
import hec.data.physicalstructure.PhysicalStructure;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanType;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.ProjectStructureObjTUser")
public class JDomOutletImpl
extends PhysicalStructure
implements IOutlet {
    private boolean _isCompoundOutletMember = false;
    private List<IOutlet> _inflow;
    private List<IOutlet> _outflow;
    private String _compoundOutletName = "None";
    private String _compoundOutletDescription = "";

    public JDomOutletImpl() {
    }

    public JDomOutletImpl(IOutlet iOutlet) {
        this(JDomDataObjectFactory.getRootElement(iOutlet.toXmlString()));
    }

    public JDomOutletImpl(Element element) {
        super(element);
    }

    public JDomOutletImpl(LocationTemplate projectLocationRef, Location outletLocation, ICharacteristicTypeRef characteristicTypeRef, LocationGroupRef groupRef) throws JDomDataObjectException {
        super(projectLocationRef, outletLocation, characteristicTypeRef, groupRef);
    }

    @Override
    protected String getCharacteristicRefElementName() {
        return "outlet_characteristic_ref";
    }

    @Override
    protected String getLocationElementName() {
        return "outlet_location";
    }

    @Override
    protected String getProjectChildName() {
        return "project_location_ref";
    }

    @Override
    @EntityBean(attributeName="structureLocation")
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    @EntityBean(attributeName="projectLocationRef")
    public LocationTemplate getParentLocationRef() {
        return super.getParentLocationRef();
    }

    @Override
    @EntityBean(attributeName="characteristicRef")
    public JDomCharacteristicTypeRef getCharacteristicRef() {
        return super.getCharacteristicRef();
    }

    @Override
    public void setIsCompoundOutletMember(boolean isGroupMember) {
        this._isCompoundOutletMember = isGroupMember;
    }

    @Override
    public boolean isCompoundOutletMember() {
        return this._isCompoundOutletMember;
    }

    @Override
    public void setInflows(List<IOutlet> inflow) {
        this._inflow = inflow;
    }

    @Override
    public List<IOutlet> getInflows() {
        return this._inflow;
    }

    @Override
    public void setOutflows(List<IOutlet> outflow) {
        this._outflow = outflow;
    }

    @Override
    public List<IOutlet> getOutflows() {
        return this._outflow;
    }

    @Override
    public void setCompoundOutletName(String compoundOutletName) {
        this._compoundOutletName = compoundOutletName;
    }

    @Override
    public String getCompoundOutletName() {
        return this._compoundOutletName;
    }

    @Override
    public void setCompoundOutletDescription(String compoundOutletDescription) {
        this._compoundOutletDescription = compoundOutletDescription;
    }

    @Override
    public String getCompoundOutletDescription() {
        return this._compoundOutletDescription;
    }

    @Override
    public boolean isReservoirInflow() {
        return this._inflow == null || this._inflow.isEmpty();
    }

    @Override
    public boolean isDownstreamOutflow() {
        return this._outflow == null || this._outflow.isEmpty();
    }

    @Override
    public void addOutflow(IOutlet outflow) {
        if (this._outflow == null) {
            this._outflow = new ArrayList<IOutlet>();
            this._outflow.add(outflow);
        } else if (!this._outflow.contains(outflow)) {
            this._outflow.add(outflow);
        }
    }

    @Override
    public void addInflow(IOutlet inflow) {
        if (this._inflow == null) {
            this._inflow = new ArrayList<IOutlet>();
            this._inflow.add(inflow);
        } else if (!this._inflow.contains(inflow)) {
            this._inflow.add(inflow);
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

