/*
 * Decompiled with CFR 0.152.
 */
package hec.data.physicalstructure;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectException;
import hec.data.characteristic.ICharacteristicTypeRef;
import hec.data.characteristic.JDomCharacteristicTypeRef;
import hec.data.location.Location;
import hec.data.location.LocationGroupRef;
import hec.data.location.LocationTemplate;
import hec.data.physicalstructure.IPhysicalStructure;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.ProjectStructureObjTUser")
public abstract class PhysicalStructure
extends AbstractJDomDataObject
implements IPhysicalStructure {
    protected Location _location;
    protected LocationTemplate _projectLocationRef;
    protected JDomCharacteristicTypeRef _characteristicsRef;
    protected LocationGroupRef _groupRef;

    public PhysicalStructure() {
    }

    public PhysicalStructure(LocationTemplate projectLocationRef, Location outletLocation, ICharacteristicTypeRef characteristicTypeRef, LocationGroupRef groupRef) throws JDomDataObjectException {
        this._projectLocationRef = projectLocationRef;
        this._location = outletLocation;
        this._groupRef = groupRef;
        this.setCharacteristicRef(characteristicTypeRef);
        super.setName(outletLocation.getLocationId());
    }

    public PhysicalStructure(Element element) {
        if (element != null) {
            LocationTemplate projLoc;
            Element subElement1 = element.getChild(this.getProjectChildName());
            this._projectLocationRef = projLoc = LocationTemplate.parse(subElement1);
            Element elem = element.getChild(this.getLocationElementName());
            Location outLoc = Location.parseElement(elem);
            this.setLocation(outLoc);
            elem = element.getChild(this.getCharacteristicRefElementName());
            this._characteristicsRef = new JDomCharacteristicTypeRef(elem);
        }
    }

    @Override
    public void buildElement(Element element) {
        Element projectLocElement = XMLUtilities.getOrCreateChild(element, this.getProjectChildName());
        this._projectLocationRef.buildElement(projectLocElement);
        Element outletLocElement = XMLUtilities.getOrCreateChild(element, this.getLocationElementName());
        this._location.buildElement(outletLocElement);
        Element outletCharElement = XMLUtilities.getOrCreateChild(element, this.getCharacteristicRefElementName());
        if (this._characteristicsRef != null) {
            this._characteristicsRef.buildElement(outletCharElement);
        }
    }

    @Override
    public Location getLocation() {
        return this._location;
    }

    @Override
    public LocationTemplate getParentLocationRef() {
        return this._projectLocationRef;
    }

    @Override
    public JDomCharacteristicTypeRef getCharacteristicRef() {
        return this._characteristicsRef;
    }

    @Override
    public void setLocation(Location location) {
        this._location = location;
        super.setName(location.getLocationId());
    }

    @Override
    public void setParentLocationRef(LocationTemplate projectLoc) {
        this._projectLocationRef = projectLoc;
    }

    @Override
    public void setCharacteristicRef(ICharacteristicTypeRef charRef) throws JDomDataObjectException {
        if (charRef instanceof JDomCharacteristicTypeRef) {
            this._characteristicsRef = (JDomCharacteristicTypeRef)charRef;
        } else if (charRef != null) {
            this._characteristicsRef = new JDomCharacteristicTypeRef(charRef);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._characteristicsRef == null ? 0 : this._characteristicsRef.hashCode());
        result = 31 * result + (this._location == null ? 0 : this._location.hashCode());
        result = 31 * result + (this._projectLocationRef == null ? 0 : this._projectLocationRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhysicalStructure other = (PhysicalStructure)obj;
        if (this._characteristicsRef == null ? other._characteristicsRef != null : !this._characteristicsRef.equals(other._characteristicsRef)) {
            return false;
        }
        if (this._location == null ? other._location != null : !this._location.equals(other._location)) {
            return false;
        }
        return !(this._projectLocationRef == null ? other._projectLocationRef != null : !this._projectLocationRef.equals((Object)other._projectLocationRef));
    }

    protected abstract String getCharacteristicRefElementName();

    protected abstract String getLocationElementName();

    protected abstract String getProjectChildName();

    @Override
    public LocationGroupRef getRatingGroupRef() {
        return this._groupRef;
    }

    @Override
    public void setRatingGroupRef(LocationGroupRef groupRef) {
        this._groupRef = groupRef;
    }
}

