/*
 * Decompiled with CFR 0.152.
 */
package hec.data.pool;

import hec.data.level.ILocationLevelRef;
import hec.data.location.LocationTemplate;
import hec.data.pool.IPool;
import hec.data.pool.IPoolName;
import hec.data.pool.PoolNameRef;
import hec.data.pool.PoolRef;
import hec.data.pool.PoolUtilities;
import java.util.Objects;

public class Pool
implements IPool {
    private final IPoolName _poolName;
    private final LocationTemplate _projectLocation;
    private final ILocationLevelRef _bottomLevel;
    private final ILocationLevelRef _topLevel;
    private final boolean _implicit;

    public Pool(IPoolName poolName, LocationTemplate projectLocation, ILocationLevelRef bottomLevel, ILocationLevelRef topLevel) {
        this(poolName, projectLocation, bottomLevel, topLevel, false);
    }

    public Pool(IPoolName poolName, LocationTemplate projectLocation, ILocationLevelRef bottomLevel, ILocationLevelRef topLevel, boolean implicit) {
        this._poolName = poolName;
        this._projectLocation = projectLocation;
        this._bottomLevel = bottomLevel;
        this._topLevel = topLevel;
        this._implicit = implicit;
    }

    @Override
    public IPoolName getPoolName() {
        return this._poolName;
    }

    @Override
    public LocationTemplate getProjectLocationTemplate() {
        return this._projectLocation;
    }

    @Override
    public ILocationLevelRef getBottomLocationLevel() {
        return this._bottomLevel;
    }

    @Override
    public ILocationLevelRef getTopLocationLevel() {
        return this._topLevel;
    }

    @Override
    public boolean isImplicit() {
        return this._implicit;
    }

    @Override
    public PoolRef asRef() {
        PoolNameRef nameRef = this._poolName.asRef();
        return new PoolRef(nameRef, this._projectLocation.getLocationId(), this._bottomLevel.getLocationLevelId(), this._topLevel.getLocationLevelId());
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this._poolName);
        hash = 53 * hash + Objects.hashCode((Object)this._projectLocation);
        hash = 53 * hash + Objects.hashCode(this._bottomLevel);
        hash = 53 * hash + Objects.hashCode(this._topLevel);
        return hash;
    }

    public boolean equals(Object obj) {
        String otherBottomLevel;
        String otherProjectLocation;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pool other = (Pool)obj;
        if (!Objects.equals(this._poolName, other._poolName)) {
            return false;
        }
        String projectLocation = this.getLocationId(this._projectLocation);
        if (!Objects.equals(projectLocation, otherProjectLocation = this.getLocationId(other._projectLocation))) {
            return false;
        }
        String bottomLevel = this.getLevelId(this._bottomLevel);
        if (!Objects.equals(bottomLevel, otherBottomLevel = this.getLevelId(other._bottomLevel))) {
            return false;
        }
        String topLevel = this.getLevelId(this._topLevel);
        String otherTopLevel = this.getLevelId(other._topLevel);
        return Objects.equals(topLevel, otherTopLevel);
    }

    private String getLocationId(LocationTemplate template) {
        String output = null;
        if (template != null) {
            output = PoolUtilities.getCaseInsensitiveValue(template.getLocationId());
        }
        return output;
    }

    private String getLevelId(ILocationLevelRef ref) {
        String output = null;
        if (ref != null) {
            output = PoolUtilities.getCaseInsensitiveValue(ref.getLocationLevelId());
        }
        return output;
    }
}

