/*
 * Decompiled with CFR 0.152.
 */
package hec.data.pool;

import hec.data.pool.IPoolName;
import hec.data.pool.PoolNameRef;
import hec.data.pool.PoolUtilities;
import java.util.Objects;

public class PoolName
implements IPoolName {
    private final String _poolName;
    private final String _officeId;

    public PoolName(String poolName, String officeId) {
        this._poolName = poolName;
        this._officeId = officeId;
    }

    @Override
    public String getPoolName() {
        return this._poolName;
    }

    @Override
    public String getOfficeId() {
        return this._officeId;
    }

    public int hashCode() {
        int hash = 5;
        String poolName = PoolUtilities.getCaseInsensitiveValue(this._poolName);
        String officeId = PoolUtilities.getCaseInsensitiveValue(this._officeId);
        hash = 67 * hash + Objects.hashCode(poolName);
        hash = 67 * hash + Objects.hashCode(officeId);
        return hash;
    }

    @Override
    public PoolNameRef asRef() {
        return new PoolNameRef(this._poolName, this._officeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PoolName other = (PoolName)obj;
        String poolName = PoolUtilities.getCaseInsensitiveValue(this._poolName);
        String officeId = PoolUtilities.getCaseInsensitiveValue(this._officeId);
        String otherPoolName = PoolUtilities.getCaseInsensitiveValue(other._poolName);
        String otherOfficeId = PoolUtilities.getCaseInsensitiveValue(other._officeId);
        return Objects.equals(poolName, otherPoolName) && Objects.equals(officeId, otherOfficeId);
    }
}

