/*
 * Decompiled with CFR 0.152.
 */
package hec.data.pool;

import hec.data.pool.PoolUtilities;
import java.util.Objects;

public final class PoolNameRef {
    private final String _poolNameMask;
    private final String _officeIdMask;

    public PoolNameRef(String poolNameMask, String officeIdMask) {
        if (poolNameMask == null) {
            poolNameMask = PoolUtilities.ANY_MASK;
        }
        if (officeIdMask == null) {
            officeIdMask = PoolUtilities.ANY_MASK;
        }
        this._poolNameMask = poolNameMask;
        this._officeIdMask = officeIdMask;
    }

    public static PoolNameRef all() {
        return new PoolNameRef(PoolUtilities.ANY_MASK, PoolUtilities.ANY_MASK);
    }

    public String getPoolNameMask() {
        return this._poolNameMask;
    }

    public String getOfficeIdMask() {
        return this._officeIdMask;
    }

    public int hashCode() {
        int hash = 7;
        String poolNameMask = PoolUtilities.getCaseInsensitiveValue(this._poolNameMask);
        String officeIdMask = PoolUtilities.getCaseInsensitiveValue(this._officeIdMask);
        hash = 71 * hash + Objects.hashCode(poolNameMask);
        hash = 71 * hash + Objects.hashCode(officeIdMask);
        return hash;
    }

    public boolean equals(Object obj) {
        String otherPoolNameMask;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PoolNameRef other = (PoolNameRef)obj;
        String poolNameMask = PoolUtilities.getCaseInsensitiveValue(this._poolNameMask);
        if (!Objects.equals(poolNameMask, otherPoolNameMask = PoolUtilities.getCaseInsensitiveValue(other._poolNameMask))) {
            return false;
        }
        String officeIdMask = PoolUtilities.getCaseInsensitiveValue(this._officeIdMask);
        String otherOfficeIdMask = PoolUtilities.getCaseInsensitiveValue(other._officeIdMask);
        return Objects.equals(officeIdMask, otherOfficeIdMask);
    }
}

