/*
 * Decompiled with CFR 0.152.
 */
package hec.data.pool;

import hec.data.pool.PoolNameRef;
import hec.data.pool.PoolUtilities;
import java.util.Objects;

public class PoolRef {
    private final PoolNameRef _poolNameRef;
    private final String _projectIdMask;
    private final String _bottomLevelMask;
    private final String _topLevelMask;

    public PoolRef(PoolNameRef poolNameRef, String projectIdMask, String bottomLevelMask, String topLevelMask) {
        if (poolNameRef == null) {
            poolNameRef = PoolNameRef.all();
        }
        if (projectIdMask == null) {
            projectIdMask = PoolUtilities.ANY_MASK;
        }
        if (bottomLevelMask == null) {
            bottomLevelMask = PoolUtilities.ANY_MASK;
        }
        if (topLevelMask == null) {
            topLevelMask = PoolUtilities.ANY_MASK;
        }
        this._poolNameRef = poolNameRef;
        this._projectIdMask = projectIdMask;
        this._bottomLevelMask = bottomLevelMask;
        this._topLevelMask = topLevelMask;
    }

    public PoolRef(PoolNameRef poolNameRef, String projectIdMask) {
        this(poolNameRef, projectIdMask, null, null);
    }

    public PoolRef(PoolNameRef poolNameRef) {
        this(poolNameRef, null);
    }

    public static PoolRef all() {
        return new PoolRef(PoolNameRef.all());
    }

    public PoolNameRef getPoolNameRef() {
        return this._poolNameRef;
    }

    public String getProjectIdMask() {
        return this._projectIdMask;
    }

    public String getBottomLevelMask() {
        return this._bottomLevelMask;
    }

    public String getTopLevelMask() {
        return this._topLevelMask;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Objects.hashCode(this._poolNameRef);
        String projectIdMask = PoolUtilities.getCaseInsensitiveValue(this._projectIdMask);
        String bottomLevelMask = PoolUtilities.getCaseInsensitiveValue(this._bottomLevelMask);
        String topLevelMask = PoolUtilities.getCaseInsensitiveValue(this._topLevelMask);
        hash = 13 * hash + Objects.hashCode(projectIdMask);
        hash = 13 * hash + Objects.hashCode(bottomLevelMask);
        hash = 13 * hash + Objects.hashCode(topLevelMask);
        return hash;
    }

    public boolean equals(Object obj) {
        String otherBottomLevelMask;
        String otherProjectIdMask;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PoolRef other = (PoolRef)obj;
        if (!Objects.equals(this._poolNameRef, other._poolNameRef)) {
            return false;
        }
        String projectIdMask = PoolUtilities.getCaseInsensitiveValue(this._projectIdMask);
        if (!Objects.equals(projectIdMask, otherProjectIdMask = PoolUtilities.getCaseInsensitiveValue(other._projectIdMask))) {
            return false;
        }
        String bottomLevelMask = PoolUtilities.getCaseInsensitiveValue(this._bottomLevelMask);
        if (!Objects.equals(bottomLevelMask, otherBottomLevelMask = PoolUtilities.getCaseInsensitiveValue(other._bottomLevelMask))) {
            return false;
        }
        String topLevelMask = PoolUtilities.getCaseInsensitiveValue(this._topLevelMask);
        String otherTopLevelMask = PoolUtilities.getCaseInsensitiveValue(other._topLevelMask);
        return Objects.equals(topLevelMask, otherTopLevelMask);
    }
}

