/*
 * Decompiled with CFR 0.152.
 */
package hec.data.project;

import hec.data.IColumnDescriptor;
import hec.data.location.Location;
import hec.data.location.LocationTemplate;
import hec.data.project.IProject;
import hec.data.project.IProjectDescriptor;
import hec.lang.NamedType;
import java.util.List;

public class AtProjectDescriptor
extends NamedType
implements Cloneable,
IProjectDescriptor {
    private List<IColumnDescriptor> _columnList;
    private List<Object> _row;
    private LocationTemplate _projectLocationRef;
    private String _publicName;
    private String _longName;

    public AtProjectDescriptor(List<IColumnDescriptor> columnList, List<Object> row) {
        this();
        this._columnList = columnList;
        this._row = row;
        this.parseRow();
    }

    public AtProjectDescriptor() {
    }

    public void setValues(List<IColumnDescriptor> columnList, List<Object> row) {
        this._columnList = columnList;
        this._row = row;
        this.parseRow();
    }

    @Override
    public void setValues(IProject project) {
        Location projectLocation = project.getLocation();
        this._projectLocationRef = projectLocation.getLocationTemplate();
        this._publicName = projectLocation.getPublicName();
        this.setName(projectLocation.getLocationId());
        this._longName = projectLocation.getLongName();
        this.setDescription(this._longName);
    }

    private void parseRow() {
        this._projectLocationRef = new LocationTemplate();
        for (int ii = 0; ii < this._columnList.size(); ++ii) {
            Object object;
            IColumnDescriptor columnDescriptor = this._columnList.get(ii);
            String columnName = columnDescriptor.getColumnName();
            if (columnName == null) continue;
            if (columnName.equalsIgnoreCase("db_office_id")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._projectLocationRef.setOfficeId(object.toString());
                continue;
            }
            if (columnName.equalsIgnoreCase("base_location_id")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._projectLocationRef.setBaseLocationId(object.toString());
                continue;
            }
            if (columnName.equalsIgnoreCase("sub_location_id")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._projectLocationRef.setSubLocationId(object.toString());
                continue;
            }
            if (columnName.equalsIgnoreCase("public_name")) {
                object = this._row.get(ii);
                if (object == null) continue;
                this._publicName = object.toString();
                continue;
            }
            if (!columnName.equalsIgnoreCase("long_name") || (object = this._row.get(ii)) == null) continue;
            this._longName = object.toString();
        }
        this.setName(this._projectLocationRef.getLocationId());
        this.setDescription(this._longName);
    }

    @Override
    public LocationTemplate getProjectLocationRef() {
        return this._projectLocationRef;
    }

    public String getPublicName() {
        return this._publicName;
    }

    public String getLongName() {
        return this._longName;
    }

    public String getOfficeId() {
        if (this._projectLocationRef == null) {
            return null;
        }
        return this._projectLocationRef.getOfficeId();
    }

    public String getLocationId() {
        if (this._projectLocationRef == null) {
            return null;
        }
        return this._projectLocationRef.getLocationId();
    }

    public String getBaseLocationId() {
        if (this._projectLocationRef == null) {
            return null;
        }
        return this._projectLocationRef.getBaseLocationId();
    }

    public String getSubLocationId() {
        if (this._projectLocationRef == null) {
            return null;
        }
        return this._projectLocationRef.getSubLocationId();
    }

    public List<Object> getRow() {
        return this._row;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._longName == null ? 0 : this._longName.hashCode());
        result = 31 * result + (this._projectLocationRef == null ? 0 : this._projectLocationRef.hashCode());
        result = 31 * result + (this._publicName == null ? 0 : this._publicName.hashCode());
        result = 31 * result + (this._row == null ? 0 : this._row.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtProjectDescriptor other = (AtProjectDescriptor)obj;
        if (this._longName == null ? other._longName != null : !this._longName.equals(other._longName)) {
            return false;
        }
        if (this._projectLocationRef == null ? other._projectLocationRef != null : !this._projectLocationRef.equals((Object)other._projectLocationRef)) {
            return false;
        }
        if (this._publicName == null) {
            return other._publicName == null;
        }
        return this._publicName.equals(other._publicName);
    }

    @Override
    public void setModified(boolean flag) {
        super.setModified(flag);
    }

    public void setProjectLocationRef(LocationTemplate newProject) {
        if (this._projectLocationRef != null) {
            this._projectLocationRef.setLocationId(newProject.getBaseLocationId(), newProject.getSubLocationId());
        } else {
            this._projectLocationRef = new LocationTemplate(newProject.getOfficeId(), newProject.getLocationId());
        }
        this.setName(this._projectLocationRef.getLocationId());
    }
}

