/*
 * Decompiled with CFR 0.152.
 */
package hec.data.project;

import hec.data.AbstractJDomDataObject;
import hec.data.ColumnDescriptorImpl;
import hec.data.IColumnDescriptor;
import hec.data.JDomDataObjectFactory;
import hec.data.location.Location;
import hec.data.location.LocationTemplate;
import hec.data.project.AtProjectDescriptor;
import hec.data.project.IProject;
import hec.data.project.IProjectCatalog;
import hec.data.project.IProjectDescriptor;
import hec.data.project.JDomProjectImpl;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Element;

public class JDomProjectCatalogImpl
extends AbstractJDomDataObject
implements IProjectCatalog {
    private static final String PROJECT_ELEMENT = "project";
    private static final Logger logger = Logger.getLogger(JDomProjectCatalogImpl.class.getName());
    private List<IColumnDescriptor> _columnList = new ArrayList<IColumnDescriptor>();
    private List<AtProjectDescriptor> _projectDescriptorList = new ArrayList<AtProjectDescriptor>();

    public JDomProjectCatalogImpl() {
        this.buildColumnList();
    }

    public JDomProjectCatalogImpl(Element element) {
        this();
        JDomDataObjectFactory<JDomProjectImpl> factory = new JDomDataObjectFactory<JDomProjectImpl>(JDomProjectImpl.class);
        try {
            List<JDomProjectImpl> projectList = factory.buildDataObjectList(element.getChildren());
            for (int ii = 0; ii < projectList.size(); ++ii) {
                IProject project = projectList.get(ii);
                AtProjectDescriptor descriptor = this.newProjectDescriptor(project);
                descriptor.setModified(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Object> convertToRow(IProject project) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(project.getProjectOfficeId());
        Location projectLocation = project.getLocation();
        row.add(projectLocation.getBaseLocationId());
        row.add(projectLocation.getSubLocationId());
        row.add(projectLocation.getTimezoneId());
        row.add(projectLocation.getLatitude());
        row.add(projectLocation.getLongitude());
        row.add(projectLocation.getHorizontalDatum());
        row.add(projectLocation.getElevation());
        row.add(projectLocation.getElevationUnits());
        row.add(projectLocation.getVerticalDatum());
        row.add(projectLocation.getPublicName());
        row.add(projectLocation.getLongName());
        row.add(projectLocation.getDescription());
        row.add(projectLocation.getActive());
        return row;
    }

    @Override
    public AtProjectDescriptor getProjectDescriptor(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.size()) {
            return null;
        }
        AtProjectDescriptor descriptor = this._projectDescriptorList.get(rowIdx);
        return descriptor;
    }

    @Override
    public AtProjectDescriptor getProjectDescriptor(String itemName) {
        if (itemName == null) {
            return null;
        }
        for (int ii = 0; ii < this._projectDescriptorList.size(); ++ii) {
            AtProjectDescriptor descriptor = this._projectDescriptorList.get(ii);
            String string = descriptor.toString();
            if (string == null || !string.equalsIgnoreCase(itemName)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public AtProjectDescriptor getProjectDescriptor(LocationTemplate projectLocation) {
        for (int ii = 0; ii < this._projectDescriptorList.size(); ++ii) {
            AtProjectDescriptor descriptor = this._projectDescriptorList.get(ii);
            LocationTemplate projectLocationRef = descriptor.getProjectLocationRef();
            if (!projectLocationRef.equals((Object)projectLocation)) continue;
            return descriptor;
        }
        return null;
    }

    private void buildColumnList() {
        this._columnList.clear();
        this._columnList.add(this.buildColumnDescriptor("db_office_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("base_location_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("sub_location_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("time_zone_name", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("latitude", 2, "number"));
        this._columnList.add(this.buildColumnDescriptor("longitude", 2, "number"));
        this._columnList.add(this.buildColumnDescriptor("horizontal_datum", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("elevation", 2, "number"));
        this._columnList.add(this.buildColumnDescriptor("elev_unit_id", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("vertical_datum", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("public_name", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("long_name", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("description", 12, "varchar2"));
        this._columnList.add(this.buildColumnDescriptor("active_flag", 12, "varchar2"));
    }

    private ColumnDescriptorImpl buildColumnDescriptor(String columnName, int columnType, String columnTypeName) {
        return new ColumnDescriptorImpl(columnName, columnType, columnTypeName);
    }

    @Override
    public void buildElement(Element element) {
    }

    public void parse(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int numcols = metaData.getColumnCount();
        this._columnList.clear();
        for (int ii = 1; ii <= numcols; ++ii) {
            String columnName = metaData.getColumnName(ii);
            String columnTypeName = metaData.getColumnTypeName(ii);
            int columnType = metaData.getColumnType(ii);
            ColumnDescriptorImpl columnDescriptor = new ColumnDescriptorImpl(columnName, columnType, columnTypeName);
            this._columnList.add(columnDescriptor);
        }
        this._projectDescriptorList.clear();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>(numcols);
            for (int ii = 1; ii <= numcols; ++ii) {
                Object object = rs.getObject(ii);
                row.add(object);
            }
            AtProjectDescriptor atProjectDescriptor = new AtProjectDescriptor(this._columnList, row);
            atProjectDescriptor.setModified(false);
            this._projectDescriptorList.add(atProjectDescriptor);
        }
    }

    @Override
    public List<AtProjectDescriptor> getProjectDescriptorList() {
        return Collections.unmodifiableList(this._projectDescriptorList);
    }

    @Override
    public int size() {
        return this._projectDescriptorList.size();
    }

    private int getColumnCount() {
        return this._columnList.size();
    }

    @Override
    public List<IColumnDescriptor> getColumnList() {
        return this._columnList;
    }

    @Override
    public AtProjectDescriptor newProjectDescriptor(IProject project) {
        List<Object> row = JDomProjectCatalogImpl.convertToRow(project);
        AtProjectDescriptor descriptor = new AtProjectDescriptor(this._columnList, row);
        this._projectDescriptorList.add(descriptor);
        return descriptor;
    }

    @Override
    public void remove(LocationTemplate projectLocationRef) {
        for (int ii = 0; ii < this._projectDescriptorList.size(); ++ii) {
            IProjectDescriptor descriptor = this._projectDescriptorList.get(ii);
            LocationTemplate descriptorProjectRef = descriptor.getProjectLocationRef();
            if (!descriptorProjectRef.equals((Object)projectLocationRef)) continue;
            this._projectDescriptorList.remove(ii);
            break;
        }
    }
}

