/*
 * Decompiled with CFR 0.152.
 */
package hec.data.project;

import hec.data.AbstractJDomDataObject;
import hec.data.JDomDataObjectFactory;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.location.Location;
import hec.data.project.IProject;
import hec.lang.annotation.EntityBean;
import hec.lang.annotation.EntityBeanMap;
import hec.lang.annotation.EntityBeanType;
import hec.util.XMLUtilities;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Attribute;
import org.jdom.Element;

@EntityBeanType(beanType="usace.rowcps.db.oracle.ProjectObjTUser")
public class JDomProjectImpl
extends AbstractJDomDataObject
implements IProject {
    private Location _projectLocation;
    private String _authorizingLaw;
    private double _federalCost;
    private String _federalCostUnit = "$";
    private double _nonFederalCost;
    private long _costYear = Long.MIN_VALUE;
    private long _yieldTimeFrameEnd = Long.MIN_VALUE;
    private long _yieldTimeFrameStart = Long.MIN_VALUE;
    private double _federalOandMCost;
    private double _nonFederalOandMCost;
    private String _remarks;
    private String _projectOwner;
    private Location _pumpbackLocation;
    private Location _nearGageLocation;
    private String _nonFederalCostUnit = "$";
    private String _federalOandMCostUnit = "$";
    private String _nonFederalOandMCostUnit = "$";
    private String _bankFullCapacityDescription;
    private String _downstreamUrbanDescription;
    private String _hydropowerDescription;
    private String _sedimentationDescription;

    public JDomProjectImpl(Location projectLocation) {
        this._projectLocation = projectLocation;
    }

    public JDomProjectImpl() {
        this((Location)null);
    }

    public JDomProjectImpl(Element rootElement) {
        Element nearGageLocationElement;
        Date xmlDate;
        Element projectLocationElement = rootElement.getChild("project_location");
        if (projectLocationElement != null) {
            this._projectLocation = Location.parseElement(projectLocationElement);
        }
        this._authorizingLaw = rootElement.getChildText("authorizing_law");
        String[] unitArray = new String[]{"$"};
        this._federalCost = this.parseFormattedDouble(rootElement, "federal_cost", unitArray, 0.0);
        this._federalCostUnit = unitArray[0];
        this._nonFederalCost = this.parseFormattedDouble(rootElement, "nonfederal_cost", unitArray, 0.0);
        this._nonFederalCostUnit = unitArray[0];
        int year = this.parseInt(rootElement, "cost_year", null, Integer.MIN_VALUE);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (year != Integer.MIN_VALUE) {
            cal.clear();
            cal.set(1, year);
            this._costYear = cal.getTimeInMillis();
        }
        if ((xmlDate = JDomProjectImpl.getXmlDate(rootElement, "yield_time_frame_start", "ddMMMyyyy")) != null) {
            this._yieldTimeFrameStart = xmlDate.getTime();
        }
        if ((xmlDate = JDomProjectImpl.getXmlDate(rootElement, "yield_time_frame_end", "ddMMMyyyy")) != null) {
            this._yieldTimeFrameEnd = xmlDate.getTime();
        }
        this._federalOandMCost = this.parseFormattedDouble(rootElement, "federal_om_cost", unitArray, 0.0);
        this._federalOandMCostUnit = unitArray[0];
        this._nonFederalOandMCost = this.parseFormattedDouble(rootElement, "nonfederal_om_cost", unitArray, 0.0);
        this._nonFederalOandMCostUnit = unitArray[0];
        this._remarks = rootElement.getChildText("remarks");
        this._projectOwner = rootElement.getChildText("project_owner");
        Element pumpbackLocationElement = rootElement.getChild("pump_back_location");
        if (pumpbackLocationElement != null) {
            this._pumpbackLocation = Location.parseElement(pumpbackLocationElement);
        }
        if ((nearGageLocationElement = rootElement.getChild("near_gage_location")) != null) {
            this._nearGageLocation = Location.parseElement(nearGageLocationElement);
        }
        this._hydropowerDescription = rootElement.getChildText("hydropower_description");
        this._bankFullCapacityDescription = rootElement.getChildText("bank_full_capacity_description");
        this._downstreamUrbanDescription = rootElement.getChildText("downstream_urban_description");
        this._sedimentationDescription = rootElement.getChildText("sedimentation_description");
    }

    public JDomProjectImpl(IProject iproject) {
        this(JDomDataObjectFactory.getRootElement(iproject.toXmlString()));
    }

    @Override
    public String toString() {
        String retval = null;
        if (this._projectLocation != null) {
            retval = this._projectLocation.getLocationId();
        }
        return retval;
    }

    @Override
    @EntityBean(attributeName="projectLocation")
    public Location getLocation() {
        return this._projectLocation;
    }

    @Override
    public void setLocation(Location projectLocation) {
        this._projectLocation = projectLocation;
    }

    @Override
    public String getProjectOfficeId() {
        return this._projectLocation.getOfficeId();
    }

    public void setProjectOfficeId(String projectOfficeId) {
        this._projectLocation.setOfficeId(projectOfficeId);
    }

    @Override
    public String getFederalCostUnit() {
        return this._federalCostUnit;
    }

    public void setFederalCostUnit(String federalCostUnit) {
        this._federalCostUnit = federalCostUnit;
    }

    @Override
    public String getNonFederalCostUnit() {
        return this._nonFederalCostUnit;
    }

    public void setNonFederalCostUnit(String nonFederalCostUnit) {
        this._nonFederalCostUnit = nonFederalCostUnit;
    }

    @Override
    public String getFederalOandMCostUnit() {
        return this._federalOandMCostUnit;
    }

    public void setFederalOandMCostUnit(String federalOandMCostUnit) {
        this._federalOandMCostUnit = federalOandMCostUnit;
    }

    @Override
    public String getNonFederalOandMCostUnit() {
        return this._nonFederalOandMCostUnit;
    }

    public void setNonFederalOandMCostUnit(String nonFederalOandMCostUnit) {
        this._nonFederalOandMCostUnit = nonFederalOandMCostUnit;
    }

    @Override
    public void setBankFullCapacityDescription(String bankFullCapacityDescription) {
        this._bankFullCapacityDescription = bankFullCapacityDescription;
    }

    @Override
    public void setDownstreamUrbanDescription(String downstreamUrbanDescription) {
        this._downstreamUrbanDescription = downstreamUrbanDescription;
    }

    @Override
    public void setHydropowerDescription(String hydropowerDescription) {
        this._hydropowerDescription = hydropowerDescription;
    }

    @Override
    public void setSedimentationDescription(String sedimentationDescription) {
        this._sedimentationDescription = sedimentationDescription;
    }

    @Override
    public void setYieldTimeFrameEnd(long yieldTimeFrameEnd) {
        this._yieldTimeFrameEnd = yieldTimeFrameEnd;
    }

    @Override
    public void setYieldTimeFrameStart(long yieldTimeFrameStart) {
        this._yieldTimeFrameStart = yieldTimeFrameStart;
    }

    @Override
    public TimeZone getProjectTimeZone() {
        String timezoneId = this.getLocation().getTimezoneId();
        if (timezoneId == null || timezoneId.isEmpty()) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(timezoneId);
    }

    @Override
    public String getProjectId() {
        if (this._projectLocation == null) {
            return null;
        }
        return this._projectLocation.getLocationId();
    }

    @Override
    @EntityBeanMap(attributeName="AuthorizingLaw")
    public String getAuthorizingLaw() {
        return this._authorizingLaw;
    }

    @Override
    public void setAuthorizingLaw(String authorizingLaw) {
        this._authorizingLaw = authorizingLaw;
    }

    @EntityBeanMap(attributeName="FederalCost")
    public BigDecimal getFederalCostObject() {
        return BigDecimal.valueOf(this.getFederalCost());
    }

    public void setFederalCostObject(BigDecimal cost) {
        if (cost == null) {
            this.setFederalCost(0.0);
        } else {
            this.setFederalCost(cost.doubleValue());
        }
    }

    @Override
    public double getFederalCost() {
        return this._federalCost;
    }

    @Override
    public void setFederalCost(double cost) {
        this._federalCost = cost;
    }

    @Override
    public double getNonFederalCost() {
        return this._nonFederalCost;
    }

    @Override
    public void setNonFederalCost(double cost) {
        this._nonFederalCost = cost;
    }

    @EntityBeanMap(attributeName="nonfederalCost")
    public BigDecimal getNonFederalCostObject() {
        return BigDecimal.valueOf(this.getNonFederalCost());
    }

    public void setNonFederalCostObject(BigDecimal cost) {
        if (cost == null) {
            this.setNonFederalCost(0.0);
        } else {
            this.setNonFederalCost(cost.doubleValue());
        }
    }

    @Override
    public long getCostYear() {
        return this._costYear;
    }

    @Override
    public void setCostYear(long year) {
        this._costYear = year;
    }

    @Override
    @EntityBeanMap(attributeName="CostYear")
    public Timestamp getCostYearObject() {
        long time = this.getCostYear();
        if (time == Long.MIN_VALUE) {
            return null;
        }
        return new Timestamp(time);
    }

    public void setCostYearObject(Timestamp time) {
        if (time == null) {
            this.setCostYear(Long.MIN_VALUE);
        } else {
            this.setCostYear(time.getTime());
        }
    }

    @Override
    public double getFederalOandMCost() {
        return this._federalOandMCost;
    }

    @Override
    public void setFederalOandMCost(double cost) {
        this._federalOandMCost = cost;
    }

    @EntityBeanMap(attributeName="FederalOmCost")
    public BigDecimal getFederalOandMCostObject() {
        return BigDecimal.valueOf(this.getFederalOandMCost());
    }

    public void setFederalOandMCostObject(BigDecimal cost) {
        if (cost == null) {
            this.setFederalOandMCost(0.0);
        } else {
            this.setFederalOandMCost(cost.doubleValue());
        }
    }

    @Override
    public double getNonFederalOandMCost() {
        return this._nonFederalOandMCost;
    }

    @Override
    public void setNonFederalOandMCost(double cost) {
        this._nonFederalOandMCost = cost;
    }

    @EntityBeanMap(attributeName="nonfederalOmCost")
    public BigDecimal getNonFederalOandMCostObject() {
        return BigDecimal.valueOf(this.getNonFederalOandMCost());
    }

    public void setNonFederalOandMCostObject(BigDecimal cost) {
        if (cost == null) {
            this.setNonFederalOandMCost(0.0);
        } else {
            this.setNonFederalOandMCost(cost.doubleValue());
        }
    }

    @Override
    @EntityBeanMap(attributeName="remarks")
    public String getRemarks() {
        return this._remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this._remarks = remarks;
    }

    @Override
    @EntityBeanMap(attributeName="ProjectOwner")
    public String getProjectOwner() {
        return this._projectOwner;
    }

    @Override
    public void setProjectOwner(String owner) {
        this._projectOwner = owner;
    }

    @Override
    @EntityBean(attributeName="PumpBackLocation")
    public Location getPumpbackLocation() {
        return this._pumpbackLocation;
    }

    @Override
    public void setPumpbackLocation(Location location) {
        this._pumpbackLocation = location;
    }

    @Override
    @EntityBean(attributeName="NearGageLocation")
    public Location getNearGageLocation() {
        return this._nearGageLocation;
    }

    @Override
    public void setNearGageLocation(Location location) {
        this._nearGageLocation = location;
    }

    @Override
    @EntityBeanMap(attributeName="BankFullCapacityDescription")
    public String getBankFullCapacityDescription() {
        return this._bankFullCapacityDescription;
    }

    @Override
    @EntityBeanMap(attributeName="DownstreamUrbanDescription")
    public String getDownstreamUrbanDescription() {
        return this._downstreamUrbanDescription;
    }

    @Override
    @EntityBeanMap(attributeName="HydropowerDescription")
    public String getHydropowerDescription() {
        return this._hydropowerDescription;
    }

    @Override
    @EntityBeanMap(attributeName="SedimentationDescription")
    public String getSedimentationDescription() {
        return this._sedimentationDescription;
    }

    @Override
    public long getYieldTimeFrameEnd() {
        return this._yieldTimeFrameEnd;
    }

    @Override
    public long getYieldTimeFrameStart() {
        return this._yieldTimeFrameStart;
    }

    @Override
    @EntityBeanMap(attributeName="YieldTimeFrameEnd")
    public Timestamp getYieldTimeFrameEndTimestamp() {
        long time = this.getYieldTimeFrameEnd();
        if (time == Long.MIN_VALUE) {
            return null;
        }
        return new Timestamp(time);
    }

    public void setYieldTimeFrameEndTimestamp(Timestamp input) {
        if (input == null) {
            this.setYieldTimeFrameEnd(Long.MIN_VALUE);
        } else {
            this.setYieldTimeFrameEnd(input.getTime());
        }
    }

    @Override
    @EntityBeanMap(attributeName="YieldTimeFrameStart")
    public Timestamp getYieldTimeFrameStartTimestamp() {
        long time = this.getYieldTimeFrameStart();
        if (time == Long.MIN_VALUE) {
            return null;
        }
        return new Timestamp(time);
    }

    public void setYieldTimeFrameStartTimestamp(Timestamp input) {
        if (input == null) {
            this.setYieldTimeFrameStart(Long.MIN_VALUE);
        } else {
            this.setYieldTimeFrameStart(input.getTime());
        }
    }

    @Override
    public void buildElement(Element element) {
        long yieldTimeFrameStart;
        element.getAttributes().add(new Attribute("version", "1.0"));
        Element projectLocation = XMLUtilities.getOrCreateChild(element, "project_location");
        if (this.getLocation() != null) {
            this.getLocation().buildElement(projectLocation);
        }
        Element pumpBackLocation = XMLUtilities.getOrCreateChild(element, "pump_back_location");
        if (this.getPumpbackLocation() != null) {
            this.getPumpbackLocation().buildElement(pumpBackLocation);
        }
        Element nearGageLocation = XMLUtilities.getOrCreateChild(element, "near_gage_location");
        if (this.getNearGageLocation() != null) {
            this.getNearGageLocation().buildElement(nearGageLocation);
        }
        XMLUtilities.getOrCreateChild(element, "authorizing_law").setText(this.getAuthorizingLaw());
        NumberFormat format = NumberFormat.getNumberInstance();
        Element fedCost = XMLUtilities.getOrCreateChild(element, "federal_cost");
        fedCost.setAttribute("unit", "USD");
        fedCost.setText(format.format(this.getFederalCost()));
        Element nonFedCost = XMLUtilities.getOrCreateChild(element, "nonfederal_cost");
        nonFedCost.setAttribute("unit", "USD");
        nonFedCost.setText(format.format(this.getNonFederalCost()));
        long costYear = this.getCostYear();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (costYear != Long.MIN_VALUE) {
            cal.clear();
            cal.setTimeInMillis(costYear);
            int year = cal.get(1);
            String text = Integer.toString(year);
            XMLUtilities.getOrCreateChild(element, "cost_year").setText(text);
        }
        Date xmlDate = (yieldTimeFrameStart = this.getYieldTimeFrameStart()) != Long.MIN_VALUE ? new Date(yieldTimeFrameStart) : null;
        JDomProjectImpl.setXmlDate(element, "yield_time_frame_start", "ddMMMyyyy", xmlDate);
        long yieldTimeFrameEnd = this.getYieldTimeFrameEnd();
        xmlDate = yieldTimeFrameEnd != Long.MIN_VALUE ? new Date(yieldTimeFrameEnd) : null;
        JDomProjectImpl.setXmlDate(element, "yield_time_frame_end", "ddMMMyyyy", xmlDate);
        Element fedOmCost = XMLUtilities.getOrCreateChild(element, "federal_om_cost");
        fedOmCost.setAttribute("unit", "USD");
        fedOmCost.setText(format.format(this.getFederalOandMCost()));
        Element nonFedOmCost = XMLUtilities.getOrCreateChild(element, "nonfederal_om_cost");
        nonFedOmCost.setAttribute("unit", "USD");
        nonFedOmCost.setText(format.format(this.getNonFederalOandMCost()));
        XMLUtilities.getOrCreateChild(element, "remarks").setText(this.getRemarks());
        XMLUtilities.getOrCreateChild(element, "project_owner").setText(this.getProjectOwner());
        XMLUtilities.getOrCreateChild(element, "bank_full_capacity_description").setText(this.getBankFullCapacityDescription());
        XMLUtilities.getOrCreateChild(element, "downstream_urban_description").setText(this.getDownstreamUrbanDescription());
        XMLUtilities.getOrCreateChild(element, "hydropower_description").setText(this.getHydropowerDescription());
        XMLUtilities.getOrCreateChild(element, "sedimentation_description").setText(this.getSedimentationDescription());
    }

    @Override
    public void getFederalCost(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_CURENCY);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._federalCost);
    }

    @Override
    public void getNonFederalCost(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_CURENCY);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._nonFederalCost);
    }

    @Override
    public void getFederalOandMCost(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_CURENCY);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._federalOandMCost);
    }

    @Override
    public void getNonFederalOandMCost(ParamDouble paramDouble) {
        paramDouble.setParameterId(Parameter.PARAMID_CURENCY);
        paramDouble.setUnitSystem(2);
        paramDouble.setValue(this._nonFederalOandMCost);
    }
}

