/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.Units;
import hec.data.rating.IRatingSpecification;
import java.text.MessageFormat;
import java.util.Date;

public abstract class AbstractRatingInput {
    public static final String EFFECTIVE_DATE = "effective_date";
    public static final String CREATE_DATE = "create_date";
    private IRatingSpecification _ratingSpec = null;
    private Date _ratingTime = null;
    private boolean _roundOutput = false;
    private String _depUnit = null;

    public AbstractRatingInput() {
    }

    public AbstractRatingInput(IRatingSpecification spec, Date ratingTime, boolean roundDependent) {
        this._ratingSpec = spec;
        this._ratingTime = ratingTime;
        this._roundOutput = roundDependent;
    }

    public abstract void validate() throws DataSetException;

    protected void checkUnitAgainstParameter(String unit, Parameter parameter, String paramType) throws DataSetException {
        boolean canConvert;
        if (parameter == null) {
            throw new DataSetException(MessageFormat.format("{0} parameter is null", paramType));
        }
        String paramUnit = parameter.getUnitsString();
        if (!unit.equals(paramUnit) && !(canConvert = Units.canConvertBetweenUnits(unit, paramUnit))) {
            throw new DataSetException(MessageFormat.format("Cant convert from {0} units {1} to {0} parameter units {2}", paramType, unit, paramUnit));
        }
    }

    public IRatingSpecification getRatingSpecification() {
        return this._ratingSpec;
    }

    public Date getRatingTime() {
        return this._ratingTime;
    }

    public boolean getRoundOutput() {
        return this._roundOutput;
    }

    public void setRatingSpecification(IRatingSpecification spec) {
        this._ratingSpec = spec;
    }

    public void setRatingTime(Date ratingTime) {
        this._ratingTime = ratingTime;
    }

    public void setRoundOutput(boolean tf) {
        this._roundOutput = tf;
    }

    public String getDependentUnit() {
        if (this._depUnit != null) {
            return this._depUnit;
        }
        if (this.getRatingSpecification() == null || this.getRatingSpecification().getTemplate() == null || this.getRatingSpecification().getTemplate().getDependentParameter() == null) {
            return null;
        }
        return this.getRatingSpecification().getTemplate().getDependentParameter().getUnitsString();
    }

    public void setDependentUnit(String unit) {
        this._depUnit = unit;
    }
}

