/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.DataSetException;
import hec.data.Version;
import hec.data.location.LocationTemplate;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.IRatingTemplate;
import hec.data.rating.JDomRatingTemplate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDomRatingSpecification
implements IRatingSpecification,
Comparable<IRatingSpecification> {
    private LocationTemplate _locationRef;
    private JDomRatingTemplate _template;
    private Version _specVersion;
    public final String parsingRegexp = "(.*)\\.(.*;.*\\..*)\\.(.*)";
    public final String validationRegexp = "[^;.,-]{1,24}(-[^;.,]{1,32})?\\.[^;.,-]{1,16}(-[^;.,]{1,32})?(,[^;.,-]{1,16}(-[^;.,]{1,32})?)*;[^;.,-]{1,16}(-[^;.,]{1,32})?\\.[^;.,]{1,32}\\.[^.]{1,32}";
    public final Pattern validationPattern = Pattern.compile("[^;.,-]{1,24}(-[^;.,]{1,32})?\\.[^;.,-]{1,16}(-[^;.,]{1,32})?(,[^;.,-]{1,16}(-[^;.,]{1,32})?)*;[^;.,-]{1,16}(-[^;.,]{1,32})?\\.[^;.,]{1,32}\\.[^.]{1,32}");
    public final Pattern parsingPattern = Pattern.compile("(.*)\\.(.*;.*\\..*)\\.(.*)");

    public JDomRatingSpecification() {
    }

    public JDomRatingSpecification(String officeId, String specificationId) throws DataSetException {
        if (specificationId == null) {
            throw new DataSetException("Null rating specification identifier");
        }
        Matcher matcher = this.validationPattern.matcher(specificationId);
        if (!matcher.matches()) {
            throw new DataSetException("Illegal rating specification identifier: " + specificationId);
        }
        matcher = this.parsingPattern.matcher(specificationId);
        if (!matcher.matches() || matcher.groupCount() != 3) {
            throw new DataSetException("Illegal rating specification identifier: " + specificationId);
        }
        String loc = matcher.group(1);
        String templ = matcher.group(2);
        String ver = matcher.group(3);
        this._locationRef = new LocationTemplate(officeId, loc);
        this._template = new JDomRatingTemplate(officeId, templ);
        this._specVersion = new Version(ver);
    }

    public JDomRatingSpecification(LocationTemplate locationRef, IRatingTemplate template, Version specVersion) {
        this._locationRef = locationRef;
        this.setTemplate(template);
        this._specVersion = specVersion;
    }

    public JDomRatingSpecification(IRatingSpecification ratingSpecification) {
        this._locationRef = new LocationTemplate(ratingSpecification.getLocationRef());
        this._template = new JDomRatingTemplate(ratingSpecification.getTemplate());
        this._specVersion = new Version(ratingSpecification.getSpecVersion());
    }

    @Override
    public int compareTo(IRatingSpecification o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        StringBuilder thisSb = new StringBuilder();
        if (this.getLocationRef() != null && this.getLocationRef().getDbOfficeId() != null) {
            thisSb.append(this.getLocationRef().getDbOfficeId().toString());
            thisSb.append(";");
        }
        thisSb.append(this.toString());
        StringBuilder oSb = new StringBuilder();
        if (o.getLocationRef() != null && o.getLocationRef().getDbOfficeId() != null) {
            oSb.append(o.getLocationRef().getDbOfficeId().toString());
            oSb.append(";");
        }
        oSb.append(o.toString());
        return thisSb.toString().compareTo(oSb.toString());
    }

    @Override
    public LocationTemplate getLocationRef() {
        return this._locationRef;
    }

    @Override
    public void setLocationRef(LocationTemplate locRef) {
        this._locationRef = locRef;
    }

    @Override
    public Version getSpecVersion() {
        return this._specVersion;
    }

    @Override
    public void setSpecVersion(Version specVersion) {
        this._specVersion = specVersion;
    }

    @Override
    public IRatingTemplate getTemplate() {
        return this._template;
    }

    @Override
    public void setTemplate(IRatingTemplate template) {
        this._template = template instanceof JDomRatingTemplate ? (JDomRatingTemplate)template : new JDomRatingTemplate(template);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._locationRef == null ? 0 : this._locationRef.hashCode());
        result = 31 * result + (this._template == null ? 0 : this._template.hashCode());
        result = 31 * result + (this._specVersion == null ? 0 : this._specVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomRatingSpecification other = (JDomRatingSpecification)obj;
        if (this._locationRef == null ? other._locationRef != null : !this._locationRef.equals((Object)other._locationRef)) {
            return false;
        }
        if (this._specVersion == null ? other._specVersion != null : !this._specVersion.equals(other._specVersion)) {
            return false;
        }
        return !(this._template == null ? other._template != null : !this._template.equals(other._template));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._locationRef != null) {
            sb.append(this._locationRef.getLocationId());
        }
        sb.append(".");
        if (this._template != null) {
            sb.append(this._template.toString());
        }
        sb.append(".");
        if (this._specVersion != null) {
            sb.append(this._specVersion.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean isSimple() {
        return this._template.isSimple();
    }
}

