/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.location.LocationTemplate;
import hec.data.rating.IRatingSpecCatalog;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.IRatingTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class JDomRatingSpecificationCatalog
implements IRatingSpecCatalog {
    private final Map<LocationTemplate, NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>>> _locSpecMap = new TreeMap<LocationTemplate, NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>>>(LocationTemplate.LocationComparator);

    @Override
    public NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>> getSpecifications(LocationTemplate locRef) {
        return this._locSpecMap.getOrDefault((Object)locRef, new TreeMap());
    }

    @Override
    public Map<LocationTemplate, NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>>> getSpecifications() {
        return this._locSpecMap;
    }

    public void add(IRatingSpecification spec) {
        TreeSet<IRatingSpecification> ratingSpecSet;
        LocationTemplate locationRef = spec.getLocationRef();
        IRatingTemplate template = spec.getTemplate();
        NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>> templateSpecMap = this._locSpecMap.get((Object)locationRef);
        if (templateSpecMap == null) {
            templateSpecMap = new TreeMap<IRatingTemplate, NavigableSet<IRatingSpecification>>();
            this._locSpecMap.put(locationRef, templateSpecMap);
        }
        if ((ratingSpecSet = (TreeSet<IRatingSpecification>)templateSpecMap.get(template)) == null) {
            ratingSpecSet = new TreeSet<IRatingSpecification>();
            templateSpecMap.put(template, ratingSpecSet);
        }
        ratingSpecSet.add(spec);
    }

    @Override
    public int size() {
        int size = 0;
        Set<Map.Entry<LocationTemplate, NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>>>> entrySet = this._locSpecMap.entrySet();
        for (Map.Entry<LocationTemplate, NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>>> entry : entrySet) {
            NavigableMap<IRatingTemplate, NavigableSet<IRatingSpecification>> value = entry.getValue();
            Collection values = value.values();
            size += values.size();
        }
        return size;
    }
}

