/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.DbOfficeId;
import hec.data.Parameter;
import hec.data.Version;
import hec.data.rating.IRatingTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDomRatingTemplate
implements IRatingTemplate,
Comparable<IRatingTemplate> {
    private DbOfficeId _officeId;
    private List<Parameter> _independentParameterList;
    private Parameter _dependentParameter;
    private Version _templateVersion;
    public final String parsingRegexp = "(.*);(.*)\\.(.*)";
    public final String validationRegexp = "[^;.,-]{1,16}(-[^;.,]{1,32})?(,[^;.,-]{1,16}(-[^;.,]{1,32})?)*;[^;.,-]{1,16}(-[^;,.]{1,32})?\\.[^.]{1,32}";
    public final Pattern parsingPattern = Pattern.compile("(.*);(.*)\\.(.*)");
    public final Pattern validationPattern = Pattern.compile("[^;.,-]{1,16}(-[^;.,]{1,32})?(,[^;.,-]{1,16}(-[^;.,]{1,32})?)*;[^;.,-]{1,16}(-[^;,.]{1,32})?\\.[^.]{1,32}");

    public JDomRatingTemplate() {
    }

    public JDomRatingTemplate(DbOfficeId officeId, List<Parameter> independentParameterList, Parameter dependentParameter, Version version) {
        this._officeId = officeId;
        this._independentParameterList = independentParameterList;
        this._dependentParameter = dependentParameter;
        this._templateVersion = version;
    }

    public JDomRatingTemplate(IRatingTemplate template) {
        Version otherVersion;
        Parameter otherDep;
        List<Parameter> otherIndepList;
        DbOfficeId otherOffice = template.getOfficeId();
        if (otherOffice != null) {
            this._officeId = new DbOfficeId(otherOffice);
        }
        if ((otherIndepList = template.getIndependentParameterList()) != null) {
            this._independentParameterList = new ArrayList<Parameter>();
            for (Parameter op : otherIndepList) {
                this._independentParameterList.add(new Parameter(op));
            }
        }
        if ((otherDep = template.getDependentParameter()) != null) {
            this._dependentParameter = new Parameter(otherDep);
        }
        if ((otherVersion = template.getTemplateVersion()) != null) {
            this._templateVersion = new Version(otherVersion);
        }
    }

    public JDomRatingTemplate(String officeId, String templateId) throws DataSetException {
        if (templateId == null) {
            throw new DataSetException("Null rating template identifier.");
        }
        Matcher m = this.validationPattern.matcher(templateId);
        if (!m.matches()) {
            throw new DataSetException("Invalid rating template identifier: " + templateId);
        }
        m = this.parsingPattern.matcher(templateId);
        if (!m.matches() || m.groupCount() != 3) {
            throw new DataSetException("Invalid rating template identifier: " + templateId);
        }
        String indep = m.group(1);
        String dep = m.group(2);
        String ver = m.group(3);
        String[] indepSplit = indep.split(",");
        try {
            this._officeId = new DbOfficeId(officeId);
            this._independentParameterList = new ArrayList<Parameter>();
            for (String p : indepSplit) {
                this._independentParameterList.add(new Parameter(p));
            }
            this._dependentParameter = new Parameter(dep);
            this._templateVersion = new Version(ver);
        }
        catch (DataSetIllegalArgumentException e) {
            throw new DataSetException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._officeId == null ? 0 : this._officeId.hashCode());
        if (this._independentParameterList != null) {
            for (Parameter p : this._independentParameterList) {
                result = 31 * result + (p == null ? 0 : p.hashCode());
            }
        }
        result = 31 * result + (this._dependentParameter == null ? 0 : this._dependentParameter.hashCode());
        result = 31 * result + (this._templateVersion == null ? 0 : this._templateVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDomRatingTemplate other = (JDomRatingTemplate)obj;
        if (this._officeId == null ? other._officeId != null : !this._officeId.equals((Object)other._officeId)) {
            return false;
        }
        if (this._independentParameterList == null ? other._independentParameterList != null : !this._independentParameterList.equals(other._independentParameterList)) {
            return false;
        }
        if (this._dependentParameter == null ? other._dependentParameter != null : !this._dependentParameter.equals((Object)other._dependentParameter)) {
            return false;
        }
        return !(this._templateVersion == null ? other._templateVersion != null : !this._templateVersion.equals(other._templateVersion));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._independentParameterList != null) {
            for (Parameter p : this._independentParameterList) {
                sb.append((Object)p);
                sb.append(",");
            }
            sb.setLength(sb.length() - ",".length());
        }
        sb.append(";");
        if (this._dependentParameter != null) {
            sb.append(this._dependentParameter.toString());
        }
        sb.append(".");
        if (this._templateVersion != null) {
            sb.append(this._templateVersion.toString());
        }
        return sb.toString();
    }

    @Override
    public DbOfficeId getOfficeId() {
        return this._officeId;
    }

    @Override
    public void setOfficeId(DbOfficeId officeId) {
        this._officeId = officeId;
    }

    @Override
    public Parameter getDependentParameter() {
        return this._dependentParameter;
    }

    @Override
    public void setDependentParameter(Parameter dependentParameter) {
        this._dependentParameter = dependentParameter;
    }

    @Override
    public List<Parameter> getIndependentParameterList() {
        return this._independentParameterList;
    }

    @Override
    public void setIndependentParameterList(List<Parameter> independentParameterList) {
        this._independentParameterList = independentParameterList;
    }

    @Override
    public Version getTemplateVersion() {
        return this._templateVersion;
    }

    @Override
    public void setTemplateVersion(Version version) {
        this._templateVersion = version;
    }

    @Override
    public int compareTo(IRatingTemplate o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        StringBuilder thisSb = new StringBuilder();
        if (this.getOfficeId() != null) {
            thisSb.append((Object)this.getOfficeId());
            thisSb.append(";");
        }
        thisSb.append(this.toString());
        StringBuilder oSb = new StringBuilder();
        if (o.getOfficeId() != null) {
            oSb.append((Object)o.getOfficeId());
            oSb.append(";");
        }
        oSb.append(o.toString());
        return thisSb.toString().compareTo(oSb.toString());
    }

    @Override
    public boolean isSimple() {
        return this._independentParameterList.size() == 1;
    }

    @Override
    public int getIndependentParameterCount() {
        return this._independentParameterList.size();
    }
}

