/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.Parameter;
import hec.data.rating.IParameterExtents;
import hec.data.rating.IRatingExtents;
import hec.data.rating.IRatingSpecification;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RatingExtents
implements IRatingExtents {
    private final IRatingSpecification _ratingSpecification;
    private final Date _ratingTime;
    private Map<Parameter, IParameterExtents> _parameterExtentsMap = new HashMap<Parameter, IParameterExtents>();

    public RatingExtents(IRatingSpecification ratingSpecification, Date ratingTime) {
        this._ratingSpecification = ratingSpecification;
        this._ratingTime = ratingTime;
    }

    @Override
    public void setParameterExtents(Parameter p, double minval, double maxval) {
        ParameterExtents parameterExtents = new ParameterExtents(p, minval, maxval);
        this._parameterExtentsMap.put(p, parameterExtents);
    }

    @Override
    public IParameterExtents getParameterExtents(Parameter parameter) {
        IParameterExtents parameterExtents = this._parameterExtentsMap.get((Object)parameter);
        return parameterExtents;
    }

    @Override
    public int size() {
        return this._parameterExtentsMap.size();
    }

    @Override
    public Map<Parameter, IParameterExtents> getParameterExtentsMap() {
        return this._parameterExtentsMap;
    }

    @Override
    public IRatingSpecification getRatingSpecification() {
        return this._ratingSpecification;
    }

    @Override
    public Date getRatingTime() {
        return this._ratingTime;
    }

    public class ParameterExtents
    implements IParameterExtents {
        private Parameter _parameter;
        private double _minimumValue;
        private double _maximumValue;

        private ParameterExtents(Parameter p, double minval, double maxval) {
            this._parameter = p;
            this._minimumValue = minval;
            this._maximumValue = maxval;
        }

        @Override
        public Parameter getParameter() {
            return this._parameter;
        }

        @Override
        public double getMinimumValue() {
            return this._minimumValue;
        }

        @Override
        public double getMaximumValue() {
            return this._maximumValue;
        }

        @Override
        public String getUnits() {
            return this._parameter.getUnitsStringForSystem(2);
        }
    }
}

