/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.rating.AbstractRatingInput;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.IRatingTemplate;
import hec.data.rating.ParameterValues;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RatingInput
extends AbstractRatingInput {
    List<ParameterValues> _indepInputValues = new ArrayList<ParameterValues>();
    List<Date> _indepInputDates = new ArrayList<Date>();
    private List<String> _indepUnitList = new ArrayList<String>();

    public RatingInput() {
    }

    public RatingInput(IRatingSpecification spec, Date ratingTime, List<Date> indepDates, List<ParameterValues> indepValues, List<String> indepUnitList, String depUnit, boolean roundDependent) {
        super(spec, ratingTime, roundDependent);
        super.setDependentUnit(depUnit);
        this.setIndependentInput(indepDates, indepValues);
        this.setIndepdentUnitList(indepUnitList);
    }

    public RatingInput(IRatingSpecification ratingSpecification, Date ratingTime) {
        super(ratingSpecification, ratingTime, true);
        this.buildIndependentValues();
    }

    @Override
    public void validate() throws DataSetException {
        int ii;
        if (this.getRatingSpecification() == null) {
            throw new DataSetException("Null rating specification");
        }
        if (this.getRatingSpecification().getTemplate() == null) {
            throw new DataSetException("Rating specification has a null template");
        }
        if (this._indepInputValues.isEmpty()) {
            throw new DataSetException("No independent input defined");
        }
        String dependentUnit = this.getDependentUnit();
        IRatingTemplate template = this.getRatingSpecification().getTemplate();
        Parameter dependentParameter = template.getDependentParameter();
        List<Parameter> independentParameterList = template.getIndependentParameterList();
        this.checkUnitAgainstParameter(dependentUnit, dependentParameter, "Dependent");
        List<String> indepUnitList = this.getIndependentUnitList();
        for (ii = 0; ii < indepUnitList.size(); ++ii) {
            String unit = indepUnitList.get(ii);
            Parameter p = independentParameterList.get(ii);
            this.checkUnitAgainstParameter(unit, p, "Independent");
        }
        for (ii = 0; ii < this._indepInputValues.size(); ++ii) {
            ParameterValues pv = this._indepInputValues.get(ii);
            if (pv.getDoubleArray() == null) {
                throw new DataSetException("No independent value data defined");
            }
            if (this._indepInputDates.isEmpty() || this._indepInputDates.size() == pv.getDoubleArray().length) continue;
            throw new DataSetException("Independent value count does not match date count.");
        }
    }

    private void buildIndependentValues() {
        this._indepInputValues.clear();
        if (this.getRatingSpecification() != null && this.getRatingSpecification().getTemplate() != null) {
            List<Parameter> indepParams = this.getRatingSpecification().getTemplate().getIndependentParameterList();
            for (Parameter p : indepParams) {
                ParameterValues pv = new ParameterValues(p, null);
                this._indepInputValues.add(pv);
            }
        }
    }

    public List<ParameterValues> getIndependentValues() {
        ArrayList<ParameterValues> indepValues = new ArrayList<ParameterValues>();
        indepValues.addAll(this._indepInputValues);
        return indepValues;
    }

    public List<Date> getIndependentDates() {
        ArrayList<Date> indepDates = new ArrayList<Date>();
        indepDates.addAll(this._indepInputDates);
        return indepDates;
    }

    public final void setIndependentInput(List<Date> indepDates, List<ParameterValues> indepValues) {
        this._indepInputDates.clear();
        this._indepInputDates.addAll(indepDates);
        this._indepInputValues.clear();
        this._indepInputValues.addAll(indepValues);
    }

    public List<String> getUnitList() {
        ArrayList<String> unitList = new ArrayList<String>();
        unitList.addAll(this.getIndependentUnitList());
        String dependentUnit = this.getDependentUnit();
        unitList.add(dependentUnit);
        return unitList;
    }

    public final void setIndepdentUnitList(List<String> unitList) {
        this._indepUnitList.clear();
        this._indepUnitList.addAll(unitList);
    }

    public List<String> getIndependentUnitList() {
        ArrayList<String> unitList = new ArrayList<String>();
        if (this._indepUnitList.isEmpty() && this.getRatingSpecification() != null && this.getRatingSpecification().getTemplate() != null) {
            List<Parameter> indepParams = this.getRatingSpecification().getTemplate().getIndependentParameterList();
            for (Parameter p : indepParams) {
                unitList.add(p.getUnitsString());
            }
        } else {
            unitList.addAll(this._indepUnitList);
        }
        return unitList;
    }
}

