/*
 * Decompiled with CFR 0.152.
 */
package hec.data.rating;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.rating.AbstractRatingInput;
import hec.data.rating.IRatingSpecification;
import hec.data.rating.IRatingTemplate;
import hec.data.rating.ParameterValues;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReverseRatingInput
extends AbstractRatingInput {
    private ParameterValues _depValues;
    private List<Date> _depInputDates = new ArrayList<Date>();
    private String _indepUnit;

    public ReverseRatingInput() {
    }

    public ReverseRatingInput(IRatingSpecification ratingSpecification, Date ratingTime) {
        super(ratingSpecification, ratingTime, false);
        this.buildValues();
    }

    public ReverseRatingInput(IRatingSpecification spec, Date ratingTime, List<Date> depDates, ParameterValues depValues, String depUnit, String indepUnit, boolean roundDependent) {
        super(spec, ratingTime, roundDependent);
        this.setDependentUnit(depUnit);
        this.setDependentInput(depDates, depValues);
        this.setIndependentUnit(indepUnit);
    }

    private void buildValues() {
        if (this.getRatingSpecification() != null && this.getRatingSpecification().getTemplate() != null && this.getRatingSpecification().getTemplate().getDependentParameter() != null) {
            ParameterValues pv;
            Parameter depParam = this.getRatingSpecification().getTemplate().getDependentParameter();
            this._depValues = pv = new ParameterValues(depParam, null);
        }
    }

    public final void setDependentInput(List<Date> depDates, ParameterValues depValues) {
        this._depValues = depValues;
        this._depInputDates.clear();
        this._depInputDates.addAll(depDates);
    }

    @Override
    public void validate() throws DataSetException {
        if (this.getRatingSpecification() == null) {
            throw new DataSetException("Null rating specification");
        }
        if (this.getRatingSpecification().getTemplate() == null) {
            throw new DataSetException("Rating specification has a null template");
        }
        if (this.getRatingSpecification().getTemplate().getIndependentParameterCount() > 1) {
            throw new DataSetException("Cannot perform a reverse rating on a rating specification that has more than one independent parameter");
        }
        if (this._depValues == null || this._depValues.getDoubleArray() == null || this._depValues.getDoubleArray().length < 1) {
            throw new DataSetException("No dependent input values defined");
        }
        if (!this._depInputDates.isEmpty() && this._depInputDates.size() != this._depValues.getDoubleArray().length) {
            throw new DataSetException("Independent value count does not match date count.");
        }
        String dependentUnit = this.getDependentUnit();
        IRatingTemplate template = this.getRatingSpecification().getTemplate();
        Parameter dependentParameter = template.getDependentParameter();
        List<Parameter> independentParameterList = template.getIndependentParameterList();
        Parameter indepParam = independentParameterList.get(0);
        String indepUnit = this.getIndependentUnit();
        this.checkUnitAgainstParameter(dependentUnit, dependentParameter, "Dependent");
        this.checkUnitAgainstParameter(indepUnit, indepParam, "Independent");
    }

    public ParameterValues getDependentValues() {
        return this._depValues;
    }

    public List<String> getUnitList() {
        ArrayList<String> unitList = new ArrayList<String>();
        String dependentUnit = this.getDependentUnit();
        String indepUnit = this.getIndependentUnit();
        unitList.add(indepUnit);
        unitList.add(dependentUnit);
        return unitList;
    }

    public List<Date> getDependentDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.addAll(this._depInputDates);
        return dates;
    }

    public final void setIndependentUnit(String indepUnit) {
        this._indepUnit = indepUnit;
    }

    private String getIndependentUnit() {
        return this._indepUnit;
    }
}

